/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: proc
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class proc {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _p_acctOffset_;
	public static final int _p_activeOffset_;
	public static final int _p_adspaceOffset_;
	public static final int _p_asoOffset_;
	public static final int _p_atomicOffset_;
	public static final int _p_boost_levelOffset_;
	public static final int _p_boost_typeOffset_;
	public static final int _p_boundcountOffset_;
	public static final int _p_caccel_countOffset_;
	public static final int _p_caccel_flagsOffset_;
	public static final int _p_caccel_lockOffset_;
	public static final int _p_caccel_next_procOffset_;
	public static final int _p_caccel_prev_procOffset_;
	public static final int _p_caccel_uctxlistOffset_;
	public static final int _p_chkblockOffset_;
	public static final int _p_chkfileOffset_;
	public static final int _p_clockOffset_;
	public static final int _p_cpticksOffset_;
	public static final int _p_diskiostatOffset_;
	public static final int _p_entry_probesOffset_;
	public static final int _p_etrc_procd_ptrOffset_;
	public static final int _p_exit_probesOffset_;
	public static final int _p_eyecOffset_;
	public static final int _p_flagOffset_;
	public static final int _p_flag2Offset_;
	public static final int _p_forktimeOffset_;
	public static final int _p_infoqOffset_;
	public static final int _p_intOffset_;
	public static final int _p_interval_startOffset_;
	public static final int _p_io_priorityOffset_;
	public static final int _p_jobOffset_;
	public static final int _p_lgpageOffset_;
	public static final int _p_localOffset_;
	public static final int _p_maj_pf_data_termOffset_;
	public static final int _p_maj_pf_kernel_termOffset_;
	public static final int _p_maj_pf_text_termOffset_;
	public static final int _p_majfltOffset_;
	public static final int _p_majfltsecOffset_;
	public static final int _p_memory_lboltOffset_;
	public static final int _p_min_pf_data_termOffset_;
	public static final int _p_min_pf_kernel_termOffset_;
	public static final int _p_min_pf_text_termOffset_;
	public static final int _p_minfltOffset_;
	public static final int _p_msgcntOffset_;
	public static final int _p_niceOffset_;
	public static final int _p_nx_accel_data_pOffset_;
	public static final int _p_padOffset_;
	public static final int _p_pctcpuOffset_;
	public static final int _p_peventOffset_;
	public static final int _p_pidOffset_;
	public static final int _p_process_sradOffset_;
	public static final int _p_prtrcsetOffset_;
	public static final int _p_ptbptOffset_;
	public static final int _p_ptsynchOffset_;
	public static final int _p_pvprocpOffset_;
	public static final int _p_repageOffset_;
	public static final int _p_rs_attinfoOffset_;
	public static final int _p_rssOffset_;
	public static final int _p_rt_timerOffset_;
	public static final int _p_sched_countOffset_;
	public static final int _p_sched_priOffset_;
	public static final int _p_sigOffset_;
	public static final int _p_sigcatchOffset_;
	public static final int _p_sigignoreOffset_;
	public static final int _p_siginfoOffset_;
	public static final int _p_sizeOffset_;
	public static final int _p_sradassignOffset_;
	public static final int _p_suspendedOffset_;
	public static final int _p_terminatingOffset_;
	public static final int _p_threadcountOffset_;
	public static final int _p_thrsetcntOffset_;
	public static final int _p_thsradcntOffset_;
	public static final int _p_uprobeOffset_;
	public static final int _p_wlmocthrdsOffset_;
	public static final int _p_wlmthrdsOffset_;
	public static final int _sysidmodOffset_;
	public static final int _unused1Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_p_acctOffset_ = 0;
		_p_activeOffset_ = 0;
		_p_adspaceOffset_ = 0;
		_p_asoOffset_ = 0;
		_p_atomicOffset_ = 0;
		_p_boost_levelOffset_ = 0;
		_p_boost_typeOffset_ = 0;
		_p_boundcountOffset_ = 0;
		_p_caccel_countOffset_ = 0;
		_p_caccel_flagsOffset_ = 0;
		_p_caccel_lockOffset_ = 0;
		_p_caccel_next_procOffset_ = 0;
		_p_caccel_prev_procOffset_ = 0;
		_p_caccel_uctxlistOffset_ = 0;
		_p_chkblockOffset_ = 0;
		_p_chkfileOffset_ = 0;
		_p_clockOffset_ = 0;
		_p_cpticksOffset_ = 0;
		_p_diskiostatOffset_ = 0;
		_p_entry_probesOffset_ = 0;
		_p_etrc_procd_ptrOffset_ = 0;
		_p_exit_probesOffset_ = 0;
		_p_eyecOffset_ = 0;
		_p_flagOffset_ = 0;
		_p_flag2Offset_ = 0;
		_p_forktimeOffset_ = 0;
		_p_infoqOffset_ = 0;
		_p_intOffset_ = 0;
		_p_interval_startOffset_ = 0;
		_p_io_priorityOffset_ = 0;
		_p_jobOffset_ = 0;
		_p_lgpageOffset_ = 0;
		_p_localOffset_ = 0;
		_p_maj_pf_data_termOffset_ = 0;
		_p_maj_pf_kernel_termOffset_ = 0;
		_p_maj_pf_text_termOffset_ = 0;
		_p_majfltOffset_ = 0;
		_p_majfltsecOffset_ = 0;
		_p_memory_lboltOffset_ = 0;
		_p_min_pf_data_termOffset_ = 0;
		_p_min_pf_kernel_termOffset_ = 0;
		_p_min_pf_text_termOffset_ = 0;
		_p_minfltOffset_ = 0;
		_p_msgcntOffset_ = 0;
		_p_niceOffset_ = 0;
		_p_nx_accel_data_pOffset_ = 0;
		_p_padOffset_ = 0;
		_p_pctcpuOffset_ = 0;
		_p_peventOffset_ = 0;
		_p_pidOffset_ = 0;
		_p_process_sradOffset_ = 0;
		_p_prtrcsetOffset_ = 0;
		_p_ptbptOffset_ = 0;
		_p_ptsynchOffset_ = 0;
		_p_pvprocpOffset_ = 0;
		_p_repageOffset_ = 0;
		_p_rs_attinfoOffset_ = 0;
		_p_rssOffset_ = 0;
		_p_rt_timerOffset_ = 0;
		_p_sched_countOffset_ = 0;
		_p_sched_priOffset_ = 0;
		_p_sigOffset_ = 0;
		_p_sigcatchOffset_ = 0;
		_p_sigignoreOffset_ = 0;
		_p_siginfoOffset_ = 0;
		_p_sizeOffset_ = 0;
		_p_sradassignOffset_ = 0;
		_p_suspendedOffset_ = 0;
		_p_terminatingOffset_ = 0;
		_p_threadcountOffset_ = 0;
		_p_thrsetcntOffset_ = 0;
		_p_thsradcntOffset_ = 0;
		_p_uprobeOffset_ = 0;
		_p_wlmocthrdsOffset_ = 0;
		_p_wlmthrdsOffset_ = 0;
		_sysidmodOffset_ = 0;
		_unused1Offset_ = 0;
	}

}
