/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ucred_extPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ucred_extPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ucred_ext.class)
public class ucred_extPointer extends StructurePointer {

	// NULL
	public static final ucred_extPointer NULL = new ucred_extPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ucred_extPointer(long address) {
		super(address);
	}

	public static ucred_extPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ucred_extPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ucred_extPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ucred_extPointer(address);
	}

	public ucred_extPointer add(long count) {
		return ucred_extPointer.cast(address + (ucred_ext.SIZEOF * count));
	}

	public ucred_extPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ucred_extPointer addOffset(long offset) {
		return ucred_extPointer.cast(address + offset);
	}

	public ucred_extPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ucred_extPointer sub(long count) {
		return ucred_extPointer.cast(address - (ucred_ext.SIZEOF * count));
	}

	public ucred_extPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ucred_extPointer subOffset(long offset) {
		return ucred_extPointer.cast(address - offset);
	}

	public ucred_extPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ucred_extPointer untag(long mask) {
		return ucred_extPointer.cast(address & ~mask);
	}

	public ucred_extPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ucred_ext.SIZEOF;
	}

	// Implementation methods

	// uid_t crx_acctid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_acctidOffset_", declaredType="uid_t")
	public UDATA crx_acctid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_acctidOffset_));
	}

	// uid_t crx_acctid
	public UDATAPointer crx_acctidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_acctidOffset_));
	}

	// priv_t crx_bpriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_bprivOffset_", declaredType="priv_t")
	public privPointer crx_bpriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_ext._crx_bprivOffset_));
	}

	// priv_t crx_bpriv
	public PointerPointer crx_bprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_ext._crx_bprivOffset_));
	}

	// __cap_t crx_caps
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_capsOffset_", declaredType="__cap_t")
	public __cap_tPointer crx_caps() throws CorruptDataException {
		return __cap_tPointer.cast(nonNullFieldEA(ucred_ext._crx_capsOffset_));
	}

	// __cap_t crx_caps
	public PointerPointer crx_capsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_ext._crx_capsOffset_));
	}

	// privg_t crx_effpriv
	public UDATAPointer crx_effprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_ext._crx_effprivOffset_));
	}

	// priv_t crx_epriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_eprivOffset_", declaredType="priv_t")
	public privPointer crx_epriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_ext._crx_eprivOffset_));
	}

	// priv_t crx_epriv
	public PointerPointer crx_eprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_ext._crx_eprivOffset_));
	}

	// uint_t crx_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_flagsOffset_", declaredType="uint_t")
	public UDATA crx_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_flagsOffset_));
	}

	// uint_t crx_flags
	public UDATAPointer crx_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_flagsOffset_));
	}

	// gid_t crx_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_gidOffset_", declaredType="gid_t")
	public UDATA crx_gid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_gidOffset_));
	}

	// gid_t crx_gid
	public UDATAPointer crx_gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_gidOffset_));
	}

	// gid_t[] crx_groups
	public UDATAPointer crx_groupsEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_ext._crx_groupsOffset_));
	}

	// privg_t crx_inhpriv
	public UDATAPointer crx_inhprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_ext._crx_inhprivOffset_));
	}

	// priv_t crx_ipriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_iprivOffset_", declaredType="priv_t")
	public privPointer crx_ipriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_ext._crx_iprivOffset_));
	}

	// priv_t crx_ipriv
	public PointerPointer crx_iprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_ext._crx_iprivOffset_));
	}

	// privg_t crx_limpriv
	public UDATAPointer crx_limprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_ext._crx_limprivOffset_));
	}

	// uid_t crx_luid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_luidOffset_", declaredType="uid_t")
	public UDATA crx_luid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_luidOffset_));
	}

	// uid_t crx_luid
	public UDATAPointer crx_luidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_luidOffset_));
	}

	// privg_t crx_maxpriv
	public UDATAPointer crx_maxprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_ext._crx_maxprivOffset_));
	}

	// priv_t crx_mpriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_mprivOffset_", declaredType="priv_t")
	public privPointer crx_mpriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_ext._crx_mprivOffset_));
	}

	// priv_t crx_mpriv
	public PointerPointer crx_mprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_ext._crx_mprivOffset_));
	}

	// I32 crx_ngrps
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_ngrpsOffset_", declaredType="I32")
	public IDATA crx_ngrps() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred_ext._crx_ngrpsOffset_));
	}

	// I32 crx_ngrps
	public IDATAPointer crx_ngrpsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_ngrpsOffset_));
	}

	// I32 crx_npags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_npagsOffset_", declaredType="I32")
	public IDATA crx_npags() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred_ext._crx_npagsOffset_));
	}

	// I32 crx_npags
	public IDATAPointer crx_npagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_npagsOffset_));
	}

	// I16 crx_nroles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_nrolesOffset_", declaredType="I16")
	public I16 crx_nroles() throws CorruptDataException {
		return new I16(getShortAtOffset(ucred_ext._crx_nrolesOffset_));
	}

	// I16 crx_nroles
	public I16Pointer crx_nrolesEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(ucred_ext._crx_nrolesOffset_));
	}

	// I32[] crx_pad
	public IDATAPointer crx_padEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(ucred_ext._crx_padOffset_));
	}

	// U8[] crx_pagids
	public U8Pointer crx_pagidsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(ucred_ext._crx_pagidsOffset_));
	}

	// I32[] crx_pags
	public IDATAPointer crx_pagsEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(ucred_ext._crx_pagsOffset_));
	}

	// I32 crx_reserved_1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_reserved_1Offset_", declaredType="I32")
	public IDATA crx_reserved_1() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred_ext._crx_reserved_1Offset_));
	}

	// I32 crx_reserved_1
	public IDATAPointer crx_reserved_1EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_reserved_1Offset_));
	}

	// I32 crx_reserved_2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_reserved_2Offset_", declaredType="I32")
	public IDATA crx_reserved_2() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred_ext._crx_reserved_2Offset_));
	}

	// I32 crx_reserved_2
	public IDATAPointer crx_reserved_2EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_reserved_2Offset_));
	}

	// I16 crx_reserved_3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_reserved_3Offset_", declaredType="I16")
	public I16 crx_reserved_3() throws CorruptDataException {
		return new I16(getShortAtOffset(ucred_ext._crx_reserved_3Offset_));
	}

	// I16 crx_reserved_3
	public I16Pointer crx_reserved_3EA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(ucred_ext._crx_reserved_3Offset_));
	}

	// gid_t crx_rgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_rgidOffset_", declaredType="gid_t")
	public UDATA crx_rgid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_rgidOffset_));
	}

	// gid_t crx_rgid
	public UDATAPointer crx_rgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_rgidOffset_));
	}

	// rid_t[] crx_roles
	public UDATAPointer crx_rolesEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_ext._crx_rolesOffset_));
	}

	// uid_t crx_ruid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_ruidOffset_", declaredType="uid_t")
	public UDATA crx_ruid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_ruidOffset_));
	}

	// uid_t crx_ruid
	public UDATAPointer crx_ruidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_ruidOffset_));
	}

	// gid_t crx_sgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_sgidOffset_", declaredType="gid_t")
	public UDATA crx_sgid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_sgidOffset_));
	}

	// gid_t crx_sgid
	public UDATAPointer crx_sgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_sgidOffset_));
	}

	// uid_t crx_suid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_suidOffset_", declaredType="uid_t")
	public UDATA crx_suid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_suidOffset_));
	}

	// uid_t crx_suid
	public UDATAPointer crx_suidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_suidOffset_));
	}

	// uid_t crx_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crx_uidOffset_", declaredType="uid_t")
	public UDATA crx_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_ext._crx_uidOffset_));
	}

	// uid_t crx_uid
	public UDATAPointer crx_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_ext._crx_uidOffset_));
	}

	// privg_t crx_usedpriv
	public UDATAPointer crx_usedprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_ext._crx_usedprivOffset_));
	}

}
