/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: j9cmdlineOptionsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the j9cmdlineOptionsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=j9cmdlineOptions.class)
public class j9cmdlineOptionsPointer extends StructurePointer {

	// NULL
	public static final j9cmdlineOptionsPointer NULL = new j9cmdlineOptionsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected j9cmdlineOptionsPointer(long address) {
		super(address);
	}

	public static j9cmdlineOptionsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static j9cmdlineOptionsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static j9cmdlineOptionsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new j9cmdlineOptionsPointer(address);
	}

	public j9cmdlineOptionsPointer add(long count) {
		return j9cmdlineOptionsPointer.cast(address + (j9cmdlineOptions.SIZEOF * count));
	}

	public j9cmdlineOptionsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public j9cmdlineOptionsPointer addOffset(long offset) {
		return j9cmdlineOptionsPointer.cast(address + offset);
	}

	public j9cmdlineOptionsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public j9cmdlineOptionsPointer sub(long count) {
		return j9cmdlineOptionsPointer.cast(address - (j9cmdlineOptions.SIZEOF * count));
	}

	public j9cmdlineOptionsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public j9cmdlineOptionsPointer subOffset(long offset) {
		return j9cmdlineOptionsPointer.cast(address - offset);
	}

	public j9cmdlineOptionsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public j9cmdlineOptionsPointer untag(long mask) {
		return j9cmdlineOptionsPointer.cast(address & ~mask);
	}

	public j9cmdlineOptionsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return j9cmdlineOptions.SIZEOF;
	}

	// Implementation methods

	// I32 argc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_argcOffset_", declaredType="I32")
	public IDATA argc() throws CorruptDataException {
		return new I32(getIntAtOffset(j9cmdlineOptions._argcOffset_));
	}

	// I32 argc
	public IDATAPointer argcEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(j9cmdlineOptions._argcOffset_));
	}

	// void** argv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_argvOffset_", declaredType="void**")
	public PointerPointer argv() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(j9cmdlineOptions._argvOffset_));
	}

	// void** argv
	public PointerPointer argvEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(j9cmdlineOptions._argvOffset_));
	}

	// void** envp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_envpOffset_", declaredType="void**")
	public PointerPointer envp() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(j9cmdlineOptions._envpOffset_));
	}

	// void** envp
	public PointerPointer envpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(j9cmdlineOptions._envpOffset_));
	}

	// J9PortLibrary* portLibrary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_portLibraryOffset_", declaredType="J9PortLibrary*")
	public J9PortLibraryPointer portLibrary() throws CorruptDataException {
		return J9PortLibraryPointer.cast(getPointerAtOffset(j9cmdlineOptions._portLibraryOffset_));
	}

	// J9PortLibrary* portLibrary
	public PointerPointer portLibraryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(j9cmdlineOptions._portLibraryOffset_));
	}

	// BOOLEAN shutdownPortLib
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shutdownPortLibOffset_", declaredType="BOOLEAN")
	public UDATA shutdownPortLib() throws CorruptDataException {
		return new U32(getIntAtOffset(j9cmdlineOptions._shutdownPortLibOffset_));
	}

	// BOOLEAN shutdownPortLib
	public UDATAPointer shutdownPortLibEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(j9cmdlineOptions._shutdownPortLibOffset_));
	}

}
