/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: mstsavePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the mstsavePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=mstsave.class)
public class mstsavePointer extends StructurePointer {

	// NULL
	public static final mstsavePointer NULL = new mstsavePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected mstsavePointer(long address) {
		super(address);
	}

	public static mstsavePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static mstsavePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static mstsavePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new mstsavePointer(address);
	}

	public mstsavePointer add(long count) {
		return mstsavePointer.cast(address + (mstsave.SIZEOF * count));
	}

	public mstsavePointer add(Scalar count) {
		return add(count.longValue());
	}

	public mstsavePointer addOffset(long offset) {
		return mstsavePointer.cast(address + offset);
	}

	public mstsavePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public mstsavePointer sub(long count) {
		return mstsavePointer.cast(address - (mstsave.SIZEOF * count));
	}

	public mstsavePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public mstsavePointer subOffset(long offset) {
		return mstsavePointer.cast(address - offset);
	}

	public mstsavePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public mstsavePointer untag(long mask) {
		return mstsavePointer.cast(address & ~mask);
	}

	public mstsavePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return mstsave.SIZEOF;
	}

	// Implementation methods

	// adspace_t as
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_asOffset_", declaredType="adspace_t")
	public adspace_tPointer as() throws CorruptDataException {
		return adspace_tPointer.cast(nonNullFieldEA(mstsave._asOffset_));
	}

	// adspace_t as
	public PointerPointer asEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mstsave._asOffset_));
	}

	// U8 backt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_backtOffset_", declaredType="U8")
	public U8 backt() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave._backtOffset_));
	}

	// U8 backt
	public U8Pointer backtEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._backtOffset_));
	}

	// ulong_t[] cachealign
	public UDATAPointer cachealignEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(mstsave._cachealignOffset_));
	}

	// ulong_t cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crOffset_", declaredType="ulong_t")
	public UDATA cr() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._crOffset_));
	}

	// ulong_t cr
	public UDATAPointer crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._crOffset_));
	}

	// ulong_t ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ctrOffset_", declaredType="ulong_t")
	public UDATA ctr() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._ctrOffset_));
	}

	// ulong_t ctr
	public UDATAPointer ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._ctrOffset_));
	}

	// pid_t curid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_curidOffset_", declaredType="pid_t")
	public IDATA curid() throws CorruptDataException {
		return new I32(getIntAtOffset(mstsave._curidOffset_));
	}

	// pid_t curid
	public IDATAPointer curidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mstsave._curidOffset_));
	}

	// ulong_t excbranch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_excbranchOffset_", declaredType="ulong_t")
	public UDATA excbranch() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._excbranchOffset_));
	}

	// ulong_t excbranch
	public UDATAPointer excbranchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._excbranchOffset_));
	}

	// ulong_t[] except
	public UDATAPointer exceptEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(mstsave._exceptOffset_));
	}

	// I32 excp_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_excp_typeOffset_", declaredType="I32")
	public IDATA excp_type() throws CorruptDataException {
		return new I32(getIntAtOffset(mstsave._excp_typeOffset_));
	}

	// I32 excp_type
	public IDATAPointer excp_typeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mstsave._excp_typeOffset_));
	}

	// U8 fpeu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpeuOffset_", declaredType="U8")
	public U8 fpeu() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave._fpeuOffset_));
	}

	// U8 fpeu
	public U8Pointer fpeuEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._fpeuOffset_));
	}

	// U8 fpinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpinfoOffset_", declaredType="U8")
	public U8 fpinfo() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave._fpinfoOffset_));
	}

	// U8 fpinfo
	public U8Pointer fpinfoEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._fpinfoOffset_));
	}

	// double[] fpr
	public DoublePointer fprEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(mstsave._fprOffset_));
	}

	// ulong_t fpscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrOffset_", declaredType="ulong_t")
	public UDATA fpscr() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._fpscrOffset_));
	}

	// ulong_t fpscr
	public UDATAPointer fpscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._fpscrOffset_));
	}

	// uchar fpscr24_31
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscr24_31Offset_", declaredType="uchar")
	public U8 fpscr24_31() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave._fpscr24_31Offset_));
	}

	// uchar fpscr24_31
	public U8Pointer fpscr24_31EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._fpscr24_31Offset_));
	}

	// ulong_t fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrxOffset_", declaredType="ulong_t")
	public UDATA fpscrx() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._fpscrxOffset_));
	}

	// ulong_t fpscrx
	public UDATAPointer fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._fpscrxOffset_));
	}

	// ulong_t[] gpr
	public UDATAPointer gprEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(mstsave._gprOffset_));
	}

	// ulong_t iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iarOffset_", declaredType="ulong_t")
	public UDATA iar() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._iarOffset_));
	}

	// ulong_t iar
	public UDATAPointer iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._iarOffset_));
	}

	// U8 intpri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_intpriOffset_", declaredType="U8")
	public U8 intpri() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave._intpriOffset_));
	}

	// U8 intpri
	public U8Pointer intpriEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._intpriOffset_));
	}

	// label_t* kjmpbuf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_kjmpbufOffset_", declaredType="label_t*")
	public label_tPointer kjmpbuf() throws CorruptDataException {
		return label_tPointer.cast(getPointerAtOffset(mstsave._kjmpbufOffset_));
	}

	// label_t* kjmpbuf
	public PointerPointer kjmpbufEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mstsave._kjmpbufOffset_));
	}

	// ulong_t lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lrOffset_", declaredType="ulong_t")
	public UDATA lr() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._lrOffset_));
	}

	// ulong_t lr
	public UDATAPointer lrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._lrOffset_));
	}

	// ulong_t mq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mqOffset_", declaredType="ulong_t")
	public UDATA mq() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._mqOffset_));
	}

	// ulong_t mq
	public UDATAPointer mqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._mqOffset_));
	}

	// ulong_t msr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_msrOffset_", declaredType="ulong_t")
	public UDATA msr() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._msrOffset_));
	}

	// ulong_t msr
	public UDATAPointer msrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._msrOffset_));
	}

	// ulong_t o_arg1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_arg1Offset_", declaredType="ulong_t")
	public UDATA o_arg1() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._o_arg1Offset_));
	}

	// ulong_t o_arg1
	public UDATAPointer o_arg1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._o_arg1Offset_));
	}

	// ulong_t o_iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_iarOffset_", declaredType="ulong_t")
	public UDATA o_iar() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._o_iarOffset_));
	}

	// ulong_t o_iar
	public UDATAPointer o_iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._o_iarOffset_));
	}

	// ulong_t o_toc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_tocOffset_", declaredType="ulong_t")
	public UDATA o_toc() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._o_tocOffset_));
	}

	// ulong_t o_toc
	public UDATAPointer o_tocEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._o_tocOffset_));
	}

	// ulong_t o_vaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_vaddrOffset_", declaredType="ulong_t")
	public UDATA o_vaddr() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._o_vaddrOffset_));
	}

	// ulong_t o_vaddr
	public UDATAPointer o_vaddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._o_vaddrOffset_));
	}

	// U8[] pad
	public U8Pointer padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._padOffset_));
	}

	// U8[] pad1
	public U8Pointer pad1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._pad1Offset_));
	}

	// mstsave* prev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevOffset_", declaredType="mstsave*")
	public mstsavePointer prev() throws CorruptDataException {
		return mstsavePointer.cast(getPointerAtOffset(mstsave._prevOffset_));
	}

	// mstsave* prev
	public PointerPointer prevEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mstsave._prevOffset_));
	}

	// U8[] rsvd
	public U8Pointer rsvdEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave._rsvdOffset_));
	}

	// U8* stackfix
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackfixOffset_", declaredType="U8*")
	public U8Pointer stackfix() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(mstsave._stackfixOffset_));
	}

	// U8* stackfix
	public PointerPointer stackfixEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mstsave._stackfixOffset_));
	}

	// ulong_t tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tidOffset_", declaredType="ulong_t")
	public UDATA tid() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._tidOffset_));
	}

	// ulong_t tid
	public UDATAPointer tidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._tidOffset_));
	}

	// ulong_t xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xerOffset_", declaredType="ulong_t")
	public UDATA xer() throws CorruptDataException {
		return new U64(getLongAtOffset(mstsave._xerOffset_));
	}

	// ulong_t xer
	public UDATAPointer xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave._xerOffset_));
	}

}
