/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ucontext32_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ucontext32_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ucontext32_t.class)
public class ucontext32_tPointer extends StructurePointer {

	// NULL
	public static final ucontext32_tPointer NULL = new ucontext32_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ucontext32_tPointer(long address) {
		super(address);
	}

	public static ucontext32_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ucontext32_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ucontext32_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ucontext32_tPointer(address);
	}

	public ucontext32_tPointer add(long count) {
		return ucontext32_tPointer.cast(address + (ucontext32_t.SIZEOF * count));
	}

	public ucontext32_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ucontext32_tPointer addOffset(long offset) {
		return ucontext32_tPointer.cast(address + offset);
	}

	public ucontext32_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ucontext32_tPointer sub(long count) {
		return ucontext32_tPointer.cast(address - (ucontext32_t.SIZEOF * count));
	}

	public ucontext32_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ucontext32_tPointer subOffset(long offset) {
		return ucontext32_tPointer.cast(address - offset);
	}

	public ucontext32_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ucontext32_tPointer untag(long mask) {
		return ucontext32_tPointer.cast(address & ~mask);
	}

	public ucontext32_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ucontext32_t.SIZEOF;
	}

	// Implementation methods

	// __ptr32 __extctx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___extctxOffset_", declaredType="__ptr32")
	public UDATA __extctx() throws CorruptDataException {
		return new U32(getIntAtOffset(ucontext32_t.___extctxOffset_));
	}

	// __ptr32 __extctx
	public UDATAPointer __extctxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucontext32_t.___extctxOffset_));
	}

	// I32 __extctx_magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___extctx_magicOffset_", declaredType="I32")
	public IDATA __extctx_magic() throws CorruptDataException {
		return new I32(getIntAtOffset(ucontext32_t.___extctx_magicOffset_));
	}

	// I32 __extctx_magic
	public IDATAPointer __extctx_magicEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucontext32_t.___extctx_magicOffset_));
	}

	// I32[] __pad
	public IDATAPointer __padEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(ucontext32_t.___padOffset_));
	}

	// I32 __sc_onstack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___sc_onstackOffset_", declaredType="I32")
	public IDATA __sc_onstack() throws CorruptDataException {
		return new I32(getIntAtOffset(ucontext32_t.___sc_onstackOffset_));
	}

	// I32 __sc_onstack
	public IDATAPointer __sc_onstackEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucontext32_t.___sc_onstackOffset_));
	}

	// I32 __sc_uerror
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___sc_uerrorOffset_", declaredType="I32")
	public IDATA __sc_uerror() throws CorruptDataException {
		return new I32(getIntAtOffset(ucontext32_t.___sc_uerrorOffset_));
	}

	// I32 __sc_uerror
	public IDATAPointer __sc_uerrorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucontext32_t.___sc_uerrorOffset_));
	}

	// __ptr32 uc_link
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_linkOffset_", declaredType="__ptr32")
	public UDATA uc_link() throws CorruptDataException {
		return new U32(getIntAtOffset(ucontext32_t._uc_linkOffset_));
	}

	// __ptr32 uc_link
	public UDATAPointer uc_linkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucontext32_t._uc_linkOffset_));
	}

	// mcontext32_t uc_mcontext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_mcontextOffset_", declaredType="mcontext32_t")
	public __jmpbuf32Pointer uc_mcontext() throws CorruptDataException {
		return __jmpbuf32Pointer.cast(nonNullFieldEA(ucontext32_t._uc_mcontextOffset_));
	}

	// mcontext32_t uc_mcontext
	public PointerPointer uc_mcontextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext32_t._uc_mcontextOffset_));
	}

	// sigset32_t uc_sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_sigmaskOffset_", declaredType="sigset32_t")
	public sigset32_tPointer uc_sigmask() throws CorruptDataException {
		return sigset32_tPointer.cast(nonNullFieldEA(ucontext32_t._uc_sigmaskOffset_));
	}

	// sigset32_t uc_sigmask
	public PointerPointer uc_sigmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext32_t._uc_sigmaskOffset_));
	}

	// stack32_t uc_stack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_stackOffset_", declaredType="stack32_t")
	public stack32_tPointer uc_stack() throws CorruptDataException {
		return stack32_tPointer.cast(nonNullFieldEA(ucontext32_t._uc_stackOffset_));
	}

	// stack32_t uc_stack
	public PointerPointer uc_stackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext32_t._uc_stackOffset_));
	}

}
