/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9RelocationStruct
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9RelocationStruct {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _bcaClassOffset_;
	public static final int _bctClassOffset_;
	public static final int _bctCompactClassOffset_;
	public static final int _cmClassOffset_;
	public static final int _cpmClassOffset_;
	public static final int _dbStringClassOffset_;
	public static final int _fixOffset_;
	public static final int _flagsOffset_;
	public static final int _floatClassOffset_;
	public static final int _maClassOffset_;
	public static final int _mcClassOffset_;
	public static final int _mixedObjectCountOffset_;
	public static final int _pfClassOffset_;
	public static final int _relocationListOffset_;
	public static final int _stringClassOffset_;
	public static final int _symbolClassOffset_;
	public static final int _threadClassOffset_;
	public static final int _vmContextOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_bcaClassOffset_ = 0;
		_bctClassOffset_ = 0;
		_bctCompactClassOffset_ = 0;
		_cmClassOffset_ = 0;
		_cpmClassOffset_ = 0;
		_dbStringClassOffset_ = 0;
		_fixOffset_ = 0;
		_flagsOffset_ = 0;
		_floatClassOffset_ = 0;
		_maClassOffset_ = 0;
		_mcClassOffset_ = 0;
		_mixedObjectCountOffset_ = 0;
		_pfClassOffset_ = 0;
		_relocationListOffset_ = 0;
		_stringClassOffset_ = 0;
		_symbolClassOffset_ = 0;
		_threadClassOffset_ = 0;
		_vmContextOffset_ = 0;
	}

}
