/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: v
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class v {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _turbo_acct$fillOffset_;
	public static final int _turbo_acct$valueOffset_;
	public static final int _v_acl_config$valueOffset_;
	public static final int _v_autost$fillOffset_;
	public static final int _v_autost$valueOffset_;
	public static final int _v_bufhw$valueOffset_;
	public static final int _v_chown_restrict$valueOffset_;
	public static final int _v_clist$valueOffset_;
	public static final int _v_cluster_aware$valueOffset_;
	public static final int _v_coreformat$fillOffset_;
	public static final int _v_coreformat$valueOffset_;
	public static final int _v_cpuguard$fillOffset_;
	public static final int _v_cpuguard$valueOffset_;
	public static final int _v_enhanced_rbac$valueOffset_;
	public static final int _v_file$valueOffset_;
	public static final int _v_file_max$valueOffset_;
	public static final int _v_fullcore$fillOffset_;
	public static final int _v_fullcore$valueOffset_;
	public static final int _v_hardstack$fillOffset_;
	public static final int _v_hardstack$valueOffset_;
	public static final int _v_initlvl$fillOffset_;
	public static final int _v_initlvl$valueOffset_;
	public static final int _v_iostrun$fillOffset_;
	public static final int _v_iostrun$valueOffset_;
	public static final int _v_leastpriv$fillOffset_;
	public static final int _v_leastpriv$valueOffset_;
	public static final int _v_lock$valueOffset_;
	public static final int _v_lock_max$valueOffset_;
	public static final int _v_max_logname$fillOffset_;
	public static final int _v_max_logname$valueOffset_;
	public static final int _v_maxpout$valueOffset_;
	public static final int _v_maxup$valueOffset_;
	public static final int _v_mbufhw$valueOffset_;
	public static final int _v_memscrub$fillOffset_;
	public static final int _v_memscrub$valueOffset_;
	public static final int _v_minpout$valueOffset_;
	public static final int _v_ncargs$fillOffset_;
	public static final int _v_ncargs$valueOffset_;
	public static final int _v_ncpus$fillOffset_;
	public static final int _v_ncpus$valueOffset_;
	public static final int _v_ncpus_cfg$fillOffset_;
	public static final int _v_ncpus_cfg$valueOffset_;
	public static final int _v_ngroups_allowed$fillOffset_;
	public static final int _v_ngroups_allowed$valueOffset_;
	public static final int _v_num_xmfrecs$fillOffset_;
	public static final int _v_num_xmfrecs$valueOffset_;
	public static final int _v_pmu_access$fillOffset_;
	public static final int _v_pmu_access$valueOffset_;
	public static final int _v_pre520tune$fillOffset_;
	public static final int _v_pre520tune$valueOffset_;
	public static final int _v_proc$valueOffset_;
	public static final int _v_sed_config$valueOffset_;
	public static final int _v_thread$valueOffset_;
	public static final int _v_xmdbg_segs$fillOffset_;
	public static final int _v_xmdbg_segs$valueOffset_;
	public static final int _v_xmgc$fillOffset_;
	public static final int _v_xmgc$valueOffset_;
	public static final int _vb_proc$valueOffset_;
	public static final int _vb_thread$valueOffset_;
	public static final int _ve_file$valueOffset_;
	public static final int _ve_lock$valueOffset_;
	public static final int _ve_proc$valueOffset_;
	public static final int _ve_thread$valueOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_turbo_acct$fillOffset_ = 0;
		_turbo_acct$valueOffset_ = 0;
		_v_acl_config$valueOffset_ = 0;
		_v_autost$fillOffset_ = 0;
		_v_autost$valueOffset_ = 0;
		_v_bufhw$valueOffset_ = 0;
		_v_chown_restrict$valueOffset_ = 0;
		_v_clist$valueOffset_ = 0;
		_v_cluster_aware$valueOffset_ = 0;
		_v_coreformat$fillOffset_ = 0;
		_v_coreformat$valueOffset_ = 0;
		_v_cpuguard$fillOffset_ = 0;
		_v_cpuguard$valueOffset_ = 0;
		_v_enhanced_rbac$valueOffset_ = 0;
		_v_file$valueOffset_ = 0;
		_v_file_max$valueOffset_ = 0;
		_v_fullcore$fillOffset_ = 0;
		_v_fullcore$valueOffset_ = 0;
		_v_hardstack$fillOffset_ = 0;
		_v_hardstack$valueOffset_ = 0;
		_v_initlvl$fillOffset_ = 0;
		_v_initlvl$valueOffset_ = 0;
		_v_iostrun$fillOffset_ = 0;
		_v_iostrun$valueOffset_ = 0;
		_v_leastpriv$fillOffset_ = 0;
		_v_leastpriv$valueOffset_ = 0;
		_v_lock$valueOffset_ = 0;
		_v_lock_max$valueOffset_ = 0;
		_v_max_logname$fillOffset_ = 0;
		_v_max_logname$valueOffset_ = 0;
		_v_maxpout$valueOffset_ = 0;
		_v_maxup$valueOffset_ = 0;
		_v_mbufhw$valueOffset_ = 0;
		_v_memscrub$fillOffset_ = 0;
		_v_memscrub$valueOffset_ = 0;
		_v_minpout$valueOffset_ = 0;
		_v_ncargs$fillOffset_ = 0;
		_v_ncargs$valueOffset_ = 0;
		_v_ncpus$fillOffset_ = 0;
		_v_ncpus$valueOffset_ = 0;
		_v_ncpus_cfg$fillOffset_ = 0;
		_v_ncpus_cfg$valueOffset_ = 0;
		_v_ngroups_allowed$fillOffset_ = 0;
		_v_ngroups_allowed$valueOffset_ = 0;
		_v_num_xmfrecs$fillOffset_ = 0;
		_v_num_xmfrecs$valueOffset_ = 0;
		_v_pmu_access$fillOffset_ = 0;
		_v_pmu_access$valueOffset_ = 0;
		_v_pre520tune$fillOffset_ = 0;
		_v_pre520tune$valueOffset_ = 0;
		_v_proc$valueOffset_ = 0;
		_v_sed_config$valueOffset_ = 0;
		_v_thread$valueOffset_ = 0;
		_v_xmdbg_segs$fillOffset_ = 0;
		_v_xmdbg_segs$valueOffset_ = 0;
		_v_xmgc$fillOffset_ = 0;
		_v_xmgc$valueOffset_ = 0;
		_vb_proc$valueOffset_ = 0;
		_vb_thread$valueOffset_ = 0;
		_ve_file$valueOffset_ = 0;
		_ve_lock$valueOffset_ = 0;
		_ve_proc$valueOffset_ = 0;
		_ve_thread$valueOffset_ = 0;
	}

}
