/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: RasDumpGlobalStoragePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the RasDumpGlobalStoragePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=RasDumpGlobalStorage.class)
public class RasDumpGlobalStoragePointer extends StructurePointer {

	// NULL
	public static final RasDumpGlobalStoragePointer NULL = new RasDumpGlobalStoragePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected RasDumpGlobalStoragePointer(long address) {
		super(address);
	}

	public static RasDumpGlobalStoragePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static RasDumpGlobalStoragePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static RasDumpGlobalStoragePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new RasDumpGlobalStoragePointer(address);
	}

	public RasDumpGlobalStoragePointer add(long count) {
		return RasDumpGlobalStoragePointer.cast(address + (RasDumpGlobalStorage.SIZEOF * count));
	}

	public RasDumpGlobalStoragePointer add(Scalar count) {
		return add(count.longValue());
	}

	public RasDumpGlobalStoragePointer addOffset(long offset) {
		return RasDumpGlobalStoragePointer.cast(address + offset);
	}

	public RasDumpGlobalStoragePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public RasDumpGlobalStoragePointer sub(long count) {
		return RasDumpGlobalStoragePointer.cast(address - (RasDumpGlobalStorage.SIZEOF * count));
	}

	public RasDumpGlobalStoragePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public RasDumpGlobalStoragePointer subOffset(long offset) {
		return RasDumpGlobalStoragePointer.cast(address - offset);
	}

	public RasDumpGlobalStoragePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public RasDumpGlobalStoragePointer untag(long mask) {
		return RasDumpGlobalStoragePointer.cast(address & ~mask);
	}

	public RasDumpGlobalStoragePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return RasDumpGlobalStorage.SIZEOF;
	}

	// Implementation methods

	// UDATA allocationRangeMax
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_allocationRangeMaxOffset_", declaredType="UDATA")
	public UDATA allocationRangeMax() throws CorruptDataException {
		return getUDATAAtOffset(RasDumpGlobalStorage._allocationRangeMaxOffset_);
	}

	// UDATA allocationRangeMax
	public UDATAPointer allocationRangeMaxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RasDumpGlobalStorage._allocationRangeMaxOffset_));
	}

	// UDATA allocationRangeMin
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_allocationRangeMinOffset_", declaredType="UDATA")
	public UDATA allocationRangeMin() throws CorruptDataException {
		return getUDATAAtOffset(RasDumpGlobalStorage._allocationRangeMinOffset_);
	}

	// UDATA allocationRangeMin
	public UDATAPointer allocationRangeMinEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RasDumpGlobalStorage._allocationRangeMinOffset_));
	}

	// U32 dumpFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dumpFlagsOffset_", declaredType="U32")
	public UDATA dumpFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(RasDumpGlobalStorage._dumpFlagsOffset_));
	}

	// U32 dumpFlags
	public UDATAPointer dumpFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RasDumpGlobalStorage._dumpFlagsOffset_));
	}

	// void* dumpLabelTokens
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dumpLabelTokensOffset_", declaredType="void*")
	public VoidPointer dumpLabelTokens() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(RasDumpGlobalStorage._dumpLabelTokensOffset_));
	}

	// void* dumpLabelTokens
	public PointerPointer dumpLabelTokensEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RasDumpGlobalStorage._dumpLabelTokensOffset_));
	}

	// omrthread_monitor_t dumpLabelTokensMutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dumpLabelTokensMutexOffset_", declaredType="omrthread_monitor_t")
	public J9ThreadMonitorPointer dumpLabelTokensMutex() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(RasDumpGlobalStorage._dumpLabelTokensMutexOffset_));
	}

	// omrthread_monitor_t dumpLabelTokensMutex
	public PointerPointer dumpLabelTokensMutexEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RasDumpGlobalStorage._dumpLabelTokensMutexOffset_));
	}

	// U32 noFailover
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_noFailoverOffset_", declaredType="U32")
	public UDATA noFailover() throws CorruptDataException {
		return new U32(getIntAtOffset(RasDumpGlobalStorage._noFailoverOffset_));
	}

	// U32 noFailover
	public UDATAPointer noFailoverEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RasDumpGlobalStorage._noFailoverOffset_));
	}

	// U32 noProtect
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_noProtectOffset_", declaredType="U32")
	public UDATA noProtect() throws CorruptDataException {
		return new U32(getIntAtOffset(RasDumpGlobalStorage._noProtectOffset_));
	}

	// U32 noProtect
	public UDATAPointer noProtectEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RasDumpGlobalStorage._noProtectOffset_));
	}

}
