/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __vmx_contextPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __vmx_contextPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__vmx_context.class)
public class __vmx_contextPointer extends StructurePointer {

	// NULL
	public static final __vmx_contextPointer NULL = new __vmx_contextPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __vmx_contextPointer(long address) {
		super(address);
	}

	public static __vmx_contextPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __vmx_contextPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __vmx_contextPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __vmx_contextPointer(address);
	}

	public __vmx_contextPointer add(long count) {
		return __vmx_contextPointer.cast(address + (__vmx_context.SIZEOF * count));
	}

	public __vmx_contextPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __vmx_contextPointer addOffset(long offset) {
		return __vmx_contextPointer.cast(address + offset);
	}

	public __vmx_contextPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __vmx_contextPointer sub(long count) {
		return __vmx_contextPointer.cast(address - (__vmx_context.SIZEOF * count));
	}

	public __vmx_contextPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __vmx_contextPointer subOffset(long offset) {
		return __vmx_contextPointer.cast(address - offset);
	}

	public __vmx_contextPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __vmx_contextPointer untag(long mask) {
		return __vmx_contextPointer.cast(address & ~mask);
	}

	public __vmx_contextPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __vmx_context.SIZEOF;
	}

	// Implementation methods

	// U32[] __pad1
	public UDATAPointer __pad1EA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(__vmx_context.___pad1Offset_));
	}

	// U32[] __pad2
	public UDATAPointer __pad2EA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(__vmx_context.___pad2Offset_));
	}

	// __vmxreg_t[] __vr
	public __vmxreg_tPointer __vrEA() throws CorruptDataException {
		return __vmxreg_tPointer.cast(nonNullFieldEA(__vmx_context.___vrOffset_));
	}

	// U32 __vrsave
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___vrsaveOffset_", declaredType="U32")
	public UDATA __vrsave() throws CorruptDataException {
		return new U32(getIntAtOffset(__vmx_context.___vrsaveOffset_));
	}

	// U32 __vrsave
	public UDATAPointer __vrsaveEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__vmx_context.___vrsaveOffset_));
	}

	// U32 __vscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___vscrOffset_", declaredType="U32")
	public UDATA __vscr() throws CorruptDataException {
		return new U32(getIntAtOffset(__vmx_context.___vscrOffset_));
	}

	// U32 __vscr
	public UDATAPointer __vscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__vmx_context.___vscrOffset_));
	}

}
