/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _pt_watchpointPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _pt_watchpointPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_pt_watchpoint.class)
public class _pt_watchpointPointer extends StructurePointer {

	// NULL
	public static final _pt_watchpointPointer NULL = new _pt_watchpointPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _pt_watchpointPointer(long address) {
		super(address);
	}

	public static _pt_watchpointPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _pt_watchpointPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _pt_watchpointPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _pt_watchpointPointer(address);
	}

	public _pt_watchpointPointer add(long count) {
		return _pt_watchpointPointer.cast(address + (_pt_watchpoint.SIZEOF * count));
	}

	public _pt_watchpointPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _pt_watchpointPointer addOffset(long offset) {
		return _pt_watchpointPointer.cast(address + offset);
	}

	public _pt_watchpointPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _pt_watchpointPointer sub(long count) {
		return _pt_watchpointPointer.cast(address - (_pt_watchpoint.SIZEOF * count));
	}

	public _pt_watchpointPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _pt_watchpointPointer subOffset(long offset) {
		return _pt_watchpointPointer.cast(address - offset);
	}

	public _pt_watchpointPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _pt_watchpointPointer untag(long mask) {
		return _pt_watchpointPointer.cast(address & ~mask);
	}

	public _pt_watchpointPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _pt_watchpoint.SIZEOF;
	}

	// Implementation methods

	// U16 pt_wp_u.pt_watchpoint_info.wp_align
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_u$pt_watchpoint_info$wp_alignOffset_", declaredType="U16")
	public U16 pt_wp_u$pt_watchpoint_info$wp_align() throws CorruptDataException {
		return new U16(getShortAtOffset(_pt_watchpoint._pt_wp_u$pt_watchpoint_info$wp_alignOffset_));
	}

	// U16 pt_wp_u.pt_watchpoint_info.wp_align
	public U16Pointer pt_wp_u$pt_watchpoint_info$wp_alignEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_pt_watchpoint._pt_wp_u$pt_watchpoint_info$wp_alignOffset_));
	}

	// U16 pt_wp_u.pt_watchpoint_info.wp_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_u$pt_watchpoint_info$wp_countOffset_", declaredType="U16")
	public U16 pt_wp_u$pt_watchpoint_info$wp_count() throws CorruptDataException {
		return new U16(getShortAtOffset(_pt_watchpoint._pt_wp_u$pt_watchpoint_info$wp_countOffset_));
	}

	// U16 pt_wp_u.pt_watchpoint_info.wp_count
	public U16Pointer pt_wp_u$pt_watchpoint_info$wp_countEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_pt_watchpoint._pt_wp_u$pt_watchpoint_info$wp_countOffset_));
	}

	// U32 pt_wp_u.pt_watchpoint_info.wp_minsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_u$pt_watchpoint_info$wp_minsizeOffset_", declaredType="U32")
	public UDATA pt_wp_u$pt_watchpoint_info$wp_minsize() throws CorruptDataException {
		return new U32(getIntAtOffset(_pt_watchpoint._pt_wp_u$pt_watchpoint_info$wp_minsizeOffset_));
	}

	// U32 pt_wp_u.pt_watchpoint_info.wp_minsize
	public UDATAPointer pt_wp_u$pt_watchpoint_info$wp_minsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pt_watchpoint._pt_wp_u$pt_watchpoint_info$wp_minsizeOffset_));
	}

	// U64 pt_wp_u.wp_tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_u$wp_tidOffset_", declaredType="U64")
	public UDATA pt_wp_u$wp_tid() throws CorruptDataException {
		return new U64(getLongAtOffset(_pt_watchpoint._pt_wp_u$wp_tidOffset_));
	}

	// U64 pt_wp_u.wp_tid
	public UDATAPointer pt_wp_u$wp_tidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pt_watchpoint._pt_wp_u$wp_tidOffset_));
	}

	// U32:1 wp_filter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_filterOffset_", declaredType="U32:1")
	public UDATA wp_filter() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_filter_s_, _pt_watchpoint._wp_filter_b_);
	}

	// U32:1 wp_ignore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_ignoreOffset_", declaredType="U32:1")
	public UDATA wp_ignore() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_ignore_s_, _pt_watchpoint._wp_ignore_b_);
	}

	// U32:1 wp_invalid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_invalidOffset_", declaredType="U32:1")
	public UDATA wp_invalid() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_invalid_s_, _pt_watchpoint._wp_invalid_b_);
	}

	// U32:1 wp_mapped
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_mappedOffset_", declaredType="U32:1")
	public UDATA wp_mapped() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_mapped_s_, _pt_watchpoint._wp_mapped_b_);
	}

	// U32:1 wp_read
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_readOffset_", declaredType="U32:1")
	public UDATA wp_read() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_read_s_, _pt_watchpoint._wp_read_b_);
	}

	// U32:1 wp_shmem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_shmemOffset_", declaredType="U32:1")
	public UDATA wp_shmem() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_shmem_s_, _pt_watchpoint._wp_shmem_b_);
	}

	// U64 wp_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_sizeOffset_", declaredType="U64")
	public UDATA wp_size() throws CorruptDataException {
		return new U64(getLongAtOffset(_pt_watchpoint._wp_sizeOffset_));
	}

	// U64 wp_size
	public UDATAPointer wp_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pt_watchpoint._wp_sizeOffset_));
	}

	// U64 wp_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_startOffset_", declaredType="U64")
	public UDATA wp_start() throws CorruptDataException {
		return new U64(getLongAtOffset(_pt_watchpoint._wp_startOffset_));
	}

	// U64 wp_start
	public UDATAPointer wp_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pt_watchpoint._wp_startOffset_));
	}

	// U8 wp_style
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_styleOffset_", declaredType="U8")
	public U8 wp_style() throws CorruptDataException {
		return new U8(getByteAtOffset(_pt_watchpoint._wp_styleOffset_));
	}

	// U8 wp_style
	public U8Pointer wp_styleEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_pt_watchpoint._wp_styleOffset_));
	}

	// U32:1 wp_thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_threadOffset_", declaredType="U32:1")
	public UDATA wp_thread() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_thread_s_, _pt_watchpoint._wp_thread_b_);
	}

	// void* wp_value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_valueOffset_", declaredType="void*")
	public VoidPointer wp_value() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_pt_watchpoint._wp_valueOffset_));
	}

	// void* wp_value
	public PointerPointer wp_valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_pt_watchpoint._wp_valueOffset_));
	}

	// U32:1 wp_write
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wp_writeOffset_", declaredType="U32:1")
	public UDATA wp_write() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoint._wp_write_s_, _pt_watchpoint._wp_write_b_);
	}

}
