/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: collation_tablePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the collation_tablePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=collation_table.class)
public class collation_tablePointer extends StructurePointer {

	// NULL
	public static final collation_tablePointer NULL = new collation_tablePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected collation_tablePointer(long address) {
		super(address);
	}

	public static collation_tablePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static collation_tablePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static collation_tablePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new collation_tablePointer(address);
	}

	public collation_tablePointer add(long count) {
		return collation_tablePointer.cast(address + (collation_table.SIZEOF * count));
	}

	public collation_tablePointer add(Scalar count) {
		return add(count.longValue());
	}

	public collation_tablePointer addOffset(long offset) {
		return collation_tablePointer.cast(address + offset);
	}

	public collation_tablePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public collation_tablePointer sub(long count) {
		return collation_tablePointer.cast(address - (collation_table.SIZEOF * count));
	}

	public collation_tablePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public collation_tablePointer subOffset(long offset) {
		return collation_tablePointer.cast(address - offset);
	}

	public collation_tablePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public collation_tablePointer untag(long mask) {
		return collation_tablePointer.cast(address & ~mask);
	}

	public collation_tablePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return collation_table.SIZEOF;
	}

	// Implementation methods

	// I32 high_cvalue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_high_cvalueOffset_", declaredType="I32")
	public IDATA high_cvalue() throws CorruptDataException {
		return new I32(getIntAtOffset(collation_table._high_cvalueOffset_));
	}

	// I32 high_cvalue
	public IDATAPointer high_cvalueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(collation_table._high_cvalueOffset_));
	}

	// coldesc_t* lc_coldesc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_coldescOffset_", declaredType="coldesc_t*")
	public coldescPointer lc_coldesc() throws CorruptDataException {
		return coldescPointer.cast(getPointerAtOffset(collation_table._lc_coldescOffset_));
	}

	// coldesc_t* lc_coldesc
	public PointerPointer lc_coldescEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(collation_table._lc_coldescOffset_));
	}

	// I16* lc_collate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_collateOffset_", declaredType="I16*")
	public I16Pointer lc_collate() throws CorruptDataException {
		return I16Pointer.cast(getPointerAtOffset(collation_table._lc_collateOffset_));
	}

	// I16* lc_collate
	public PointerPointer lc_collateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(collation_table._lc_collateOffset_));
	}

	// I16* lc_coluniq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_coluniqOffset_", declaredType="I16*")
	public I16Pointer lc_coluniq() throws CorruptDataException {
		return I16Pointer.cast(getPointerAtOffset(collation_table._lc_coluniqOffset_));
	}

	// I16* lc_coluniq
	public PointerPointer lc_coluniqEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(collation_table._lc_coluniqOffset_));
	}

	// I16 lc_length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_lengthOffset_", declaredType="I16")
	public I16 lc_length() throws CorruptDataException {
		return new I16(getShortAtOffset(collation_table._lc_lengthOffset_));
	}

	// I16 lc_length
	public I16Pointer lc_lengthEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(collation_table._lc_lengthOffset_));
	}

	// U8* lc_locale_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_locale_nameOffset_", declaredType="U8*")
	public U8Pointer lc_locale_name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(collation_table._lc_locale_nameOffset_));
	}

	// U8* lc_locale_name
	public PointerPointer lc_locale_nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(collation_table._lc_locale_nameOffset_));
	}

	// wchar_t* lc_strings
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_stringsOffset_", declaredType="wchar_t*")
	public UDATAPointer lc_strings() throws CorruptDataException {
		return U32Pointer.cast(getPointerAtOffset(collation_table._lc_stringsOffset_));
	}

	// wchar_t* lc_strings
	public PointerPointer lc_stringsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(collation_table._lc_stringsOffset_));
	}

	// I16 lc_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_versionOffset_", declaredType="I16")
	public I16 lc_version() throws CorruptDataException {
		return new I16(getShortAtOffset(collation_table._lc_versionOffset_));
	}

	// I16 lc_version
	public I16Pointer lc_versionEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(collation_table._lc_versionOffset_));
	}

	// I32 len_coldesc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_len_coldescOffset_", declaredType="I32")
	public IDATA len_coldesc() throws CorruptDataException {
		return new I32(getIntAtOffset(collation_table._len_coldescOffset_));
	}

	// I32 len_coldesc
	public IDATAPointer len_coldescEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(collation_table._len_coldescOffset_));
	}

	// I32 len_collate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_len_collateOffset_", declaredType="I32")
	public IDATA len_collate() throws CorruptDataException {
		return new I32(getIntAtOffset(collation_table._len_collateOffset_));
	}

	// I32 len_collate
	public IDATAPointer len_collateEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(collation_table._len_collateOffset_));
	}

	// I32 len_coluniq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_len_coluniqOffset_", declaredType="I32")
	public IDATA len_coluniq() throws CorruptDataException {
		return new I32(getIntAtOffset(collation_table._len_coluniqOffset_));
	}

	// I32 len_coluniq
	public IDATAPointer len_coluniqEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(collation_table._len_coluniqOffset_));
	}

	// I32 len_strings
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_len_stringsOffset_", declaredType="I32")
	public IDATA len_strings() throws CorruptDataException {
		return new I32(getIntAtOffset(collation_table._len_stringsOffset_));
	}

	// I32 len_strings
	public IDATAPointer len_stringsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(collation_table._len_stringsOffset_));
	}

}
