/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: mstsave32Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the mstsave32Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=mstsave32.class)
public class mstsave32Pointer extends StructurePointer {

	// NULL
	public static final mstsave32Pointer NULL = new mstsave32Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected mstsave32Pointer(long address) {
		super(address);
	}

	public static mstsave32Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static mstsave32Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static mstsave32Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new mstsave32Pointer(address);
	}

	public mstsave32Pointer add(long count) {
		return mstsave32Pointer.cast(address + (mstsave32.SIZEOF * count));
	}

	public mstsave32Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public mstsave32Pointer addOffset(long offset) {
		return mstsave32Pointer.cast(address + offset);
	}

	public mstsave32Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public mstsave32Pointer sub(long count) {
		return mstsave32Pointer.cast(address - (mstsave32.SIZEOF * count));
	}

	public mstsave32Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public mstsave32Pointer subOffset(long offset) {
		return mstsave32Pointer.cast(address - offset);
	}

	public mstsave32Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public mstsave32Pointer untag(long mask) {
		return mstsave32Pointer.cast(address & ~mask);
	}

	public mstsave32Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return mstsave32.SIZEOF;
	}

	// Implementation methods

	// adspace32_t as
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_asOffset_", declaredType="adspace32_t")
	public adspace32_tPointer as() throws CorruptDataException {
		return adspace32_tPointer.cast(nonNullFieldEA(mstsave32._asOffset_));
	}

	// adspace32_t as
	public PointerPointer asEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mstsave32._asOffset_));
	}

	// U8 backt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_backtOffset_", declaredType="U8")
	public U8 backt() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave32._backtOffset_));
	}

	// U8 backt
	public U8Pointer backtEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._backtOffset_));
	}

	// uint_t[] cachealign
	public UDATAPointer cachealignEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(mstsave32._cachealignOffset_));
	}

	// uint_t cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crOffset_", declaredType="uint_t")
	public UDATA cr() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._crOffset_));
	}

	// uint_t cr
	public UDATAPointer crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._crOffset_));
	}

	// uint_t ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ctrOffset_", declaredType="uint_t")
	public UDATA ctr() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._ctrOffset_));
	}

	// uint_t ctr
	public UDATAPointer ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._ctrOffset_));
	}

	// I32 curid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_curidOffset_", declaredType="I32")
	public IDATA curid() throws CorruptDataException {
		return new I32(getIntAtOffset(mstsave32._curidOffset_));
	}

	// I32 curid
	public IDATAPointer curidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mstsave32._curidOffset_));
	}

	// uint_t excbranch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_excbranchOffset_", declaredType="uint_t")
	public UDATA excbranch() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._excbranchOffset_));
	}

	// uint_t excbranch
	public UDATAPointer excbranchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._excbranchOffset_));
	}

	// uint_t[] except
	public UDATAPointer exceptEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(mstsave32._exceptOffset_));
	}

	// I32 excp_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_excp_typeOffset_", declaredType="I32")
	public IDATA excp_type() throws CorruptDataException {
		return new I32(getIntAtOffset(mstsave32._excp_typeOffset_));
	}

	// I32 excp_type
	public IDATAPointer excp_typeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mstsave32._excp_typeOffset_));
	}

	// U8 fpeu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpeuOffset_", declaredType="U8")
	public U8 fpeu() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave32._fpeuOffset_));
	}

	// U8 fpeu
	public U8Pointer fpeuEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._fpeuOffset_));
	}

	// U8 fpinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpinfoOffset_", declaredType="U8")
	public U8 fpinfo() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave32._fpinfoOffset_));
	}

	// U8 fpinfo
	public U8Pointer fpinfoEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._fpinfoOffset_));
	}

	// double[] fpr
	public DoublePointer fprEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(mstsave32._fprOffset_));
	}

	// uint_t fpscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrOffset_", declaredType="uint_t")
	public UDATA fpscr() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._fpscrOffset_));
	}

	// uint_t fpscr
	public UDATAPointer fpscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._fpscrOffset_));
	}

	// uchar_t fpscr24_31
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscr24_31Offset_", declaredType="uchar_t")
	public U8 fpscr24_31() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave32._fpscr24_31Offset_));
	}

	// uchar_t fpscr24_31
	public U8Pointer fpscr24_31EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._fpscr24_31Offset_));
	}

	// uint_t fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrxOffset_", declaredType="uint_t")
	public UDATA fpscrx() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._fpscrxOffset_));
	}

	// uint_t fpscrx
	public UDATAPointer fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._fpscrxOffset_));
	}

	// uint_t[] gpr
	public UDATAPointer gprEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(mstsave32._gprOffset_));
	}

	// uint_t iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iarOffset_", declaredType="uint_t")
	public UDATA iar() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._iarOffset_));
	}

	// uint_t iar
	public UDATAPointer iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._iarOffset_));
	}

	// U8 intpri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_intpriOffset_", declaredType="U8")
	public U8 intpri() throws CorruptDataException {
		return new U8(getByteAtOffset(mstsave32._intpriOffset_));
	}

	// U8 intpri
	public U8Pointer intpriEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._intpriOffset_));
	}

	// __ptr32 kjmpbuf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_kjmpbufOffset_", declaredType="__ptr32")
	public UDATA kjmpbuf() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._kjmpbufOffset_));
	}

	// __ptr32 kjmpbuf
	public UDATAPointer kjmpbufEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._kjmpbufOffset_));
	}

	// uint_t lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lrOffset_", declaredType="uint_t")
	public UDATA lr() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._lrOffset_));
	}

	// uint_t lr
	public UDATAPointer lrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._lrOffset_));
	}

	// uint_t mq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mqOffset_", declaredType="uint_t")
	public UDATA mq() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._mqOffset_));
	}

	// uint_t mq
	public UDATAPointer mqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._mqOffset_));
	}

	// uint_t msr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_msrOffset_", declaredType="uint_t")
	public UDATA msr() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._msrOffset_));
	}

	// uint_t msr
	public UDATAPointer msrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._msrOffset_));
	}

	// uint_t o_arg1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_arg1Offset_", declaredType="uint_t")
	public UDATA o_arg1() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._o_arg1Offset_));
	}

	// uint_t o_arg1
	public UDATAPointer o_arg1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._o_arg1Offset_));
	}

	// uint_t o_iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_iarOffset_", declaredType="uint_t")
	public UDATA o_iar() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._o_iarOffset_));
	}

	// uint_t o_iar
	public UDATAPointer o_iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._o_iarOffset_));
	}

	// uint_t o_toc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_tocOffset_", declaredType="uint_t")
	public UDATA o_toc() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._o_tocOffset_));
	}

	// uint_t o_toc
	public UDATAPointer o_tocEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._o_tocOffset_));
	}

	// uint_t o_vaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_o_vaddrOffset_", declaredType="uint_t")
	public UDATA o_vaddr() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._o_vaddrOffset_));
	}

	// uint_t o_vaddr
	public UDATAPointer o_vaddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._o_vaddrOffset_));
	}

	// U8[] pad
	public U8Pointer padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._padOffset_));
	}

	// U8[] pad1
	public U8Pointer pad1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._pad1Offset_));
	}

	// __ptr32 prev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevOffset_", declaredType="__ptr32")
	public UDATA prev() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._prevOffset_));
	}

	// __ptr32 prev
	public UDATAPointer prevEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._prevOffset_));
	}

	// U8[] rsvd
	public U8Pointer rsvdEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(mstsave32._rsvdOffset_));
	}

	// __cptr32 stackfix
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackfixOffset_", declaredType="__cptr32")
	public UDATA stackfix() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._stackfixOffset_));
	}

	// __cptr32 stackfix
	public UDATAPointer stackfixEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._stackfixOffset_));
	}

	// uint_t tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tidOffset_", declaredType="uint_t")
	public UDATA tid() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._tidOffset_));
	}

	// uint_t tid
	public UDATAPointer tidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._tidOffset_));
	}

	// uint_t xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xerOffset_", declaredType="uint_t")
	public UDATA xer() throws CorruptDataException {
		return new U32(getIntAtOffset(mstsave32._xerOffset_));
	}

	// uint_t xer
	public UDATAPointer xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mstsave32._xerOffset_));
	}

}
