/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: perfstat_cpu_total_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the perfstat_cpu_total_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=perfstat_cpu_total_t.class)
public class perfstat_cpu_total_tPointer extends StructurePointer {

	// NULL
	public static final perfstat_cpu_total_tPointer NULL = new perfstat_cpu_total_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected perfstat_cpu_total_tPointer(long address) {
		super(address);
	}

	public static perfstat_cpu_total_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static perfstat_cpu_total_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static perfstat_cpu_total_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new perfstat_cpu_total_tPointer(address);
	}

	public perfstat_cpu_total_tPointer add(long count) {
		return perfstat_cpu_total_tPointer.cast(address + (perfstat_cpu_total_t.SIZEOF * count));
	}

	public perfstat_cpu_total_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public perfstat_cpu_total_tPointer addOffset(long offset) {
		return perfstat_cpu_total_tPointer.cast(address + offset);
	}

	public perfstat_cpu_total_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public perfstat_cpu_total_tPointer sub(long count) {
		return perfstat_cpu_total_tPointer.cast(address - (perfstat_cpu_total_t.SIZEOF * count));
	}

	public perfstat_cpu_total_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public perfstat_cpu_total_tPointer subOffset(long offset) {
		return perfstat_cpu_total_tPointer.cast(address - offset);
	}

	public perfstat_cpu_total_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public perfstat_cpu_total_tPointer untag(long mask) {
		return perfstat_cpu_total_tPointer.cast(address & ~mask);
	}

	public perfstat_cpu_total_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return perfstat_cpu_total_t.SIZEOF;
	}

	// Implementation methods

	// u_longlong_t bread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_breadOffset_", declaredType="u_longlong_t")
	public UDATA bread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._breadOffset_));
	}

	// u_longlong_t bread
	public UDATAPointer breadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._breadOffset_));
	}

	// u_longlong_t busy_donated_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_donated_purrOffset_", declaredType="u_longlong_t")
	public UDATA busy_donated_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._busy_donated_purrOffset_));
	}

	// u_longlong_t busy_donated_purr
	public UDATAPointer busy_donated_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._busy_donated_purrOffset_));
	}

	// u_longlong_t busy_donated_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_donated_spurrOffset_", declaredType="u_longlong_t")
	public UDATA busy_donated_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._busy_donated_spurrOffset_));
	}

	// u_longlong_t busy_donated_spurr
	public UDATAPointer busy_donated_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._busy_donated_spurrOffset_));
	}

	// u_longlong_t busy_stolen_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_stolen_purrOffset_", declaredType="u_longlong_t")
	public UDATA busy_stolen_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._busy_stolen_purrOffset_));
	}

	// u_longlong_t busy_stolen_purr
	public UDATAPointer busy_stolen_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._busy_stolen_purrOffset_));
	}

	// u_longlong_t busy_stolen_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_stolen_spurrOffset_", declaredType="u_longlong_t")
	public UDATA busy_stolen_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._busy_stolen_spurrOffset_));
	}

	// u_longlong_t busy_stolen_spurr
	public UDATAPointer busy_stolen_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._busy_stolen_spurrOffset_));
	}

	// u_longlong_t bwrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bwriteOffset_", declaredType="u_longlong_t")
	public UDATA bwrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._bwriteOffset_));
	}

	// u_longlong_t bwrite
	public UDATAPointer bwriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._bwriteOffset_));
	}

	// u_longlong_t decrintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_decrintrsOffset_", declaredType="u_longlong_t")
	public UDATA decrintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._decrintrsOffset_));
	}

	// u_longlong_t decrintrs
	public UDATAPointer decrintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._decrintrsOffset_));
	}

	// U8[] description
	public U8Pointer descriptionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(perfstat_cpu_total_t._descriptionOffset_));
	}

	// u_longlong_t devintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_devintrsOffset_", declaredType="u_longlong_t")
	public UDATA devintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._devintrsOffset_));
	}

	// u_longlong_t devintrs
	public UDATAPointer devintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._devintrsOffset_));
	}

	// u_longlong_t dirblk
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dirblkOffset_", declaredType="u_longlong_t")
	public UDATA dirblk() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._dirblkOffset_));
	}

	// u_longlong_t dirblk
	public UDATAPointer dirblkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._dirblkOffset_));
	}

	// u_longlong_t hpi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hpiOffset_", declaredType="u_longlong_t")
	public UDATA hpi() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._hpiOffset_));
	}

	// u_longlong_t hpi
	public UDATAPointer hpiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._hpiOffset_));
	}

	// u_longlong_t hpit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hpitOffset_", declaredType="u_longlong_t")
	public UDATA hpit() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._hpitOffset_));
	}

	// u_longlong_t hpit
	public UDATAPointer hpitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._hpitOffset_));
	}

	// u_longlong_t idle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idleOffset_", declaredType="u_longlong_t")
	public UDATA idle() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._idleOffset_));
	}

	// u_longlong_t idle
	public UDATAPointer idleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._idleOffset_));
	}

	// u_longlong_t idle_donated_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_donated_purrOffset_", declaredType="u_longlong_t")
	public UDATA idle_donated_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._idle_donated_purrOffset_));
	}

	// u_longlong_t idle_donated_purr
	public UDATAPointer idle_donated_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._idle_donated_purrOffset_));
	}

	// u_longlong_t idle_donated_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_donated_spurrOffset_", declaredType="u_longlong_t")
	public UDATA idle_donated_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._idle_donated_spurrOffset_));
	}

	// u_longlong_t idle_donated_spurr
	public UDATAPointer idle_donated_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._idle_donated_spurrOffset_));
	}

	// u_longlong_t idle_stolen_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_stolen_purrOffset_", declaredType="u_longlong_t")
	public UDATA idle_stolen_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._idle_stolen_purrOffset_));
	}

	// u_longlong_t idle_stolen_purr
	public UDATAPointer idle_stolen_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._idle_stolen_purrOffset_));
	}

	// u_longlong_t idle_stolen_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_stolen_spurrOffset_", declaredType="u_longlong_t")
	public UDATA idle_stolen_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._idle_stolen_spurrOffset_));
	}

	// u_longlong_t idle_stolen_spurr
	public UDATAPointer idle_stolen_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._idle_stolen_spurrOffset_));
	}

	// u_longlong_t iget
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_igetOffset_", declaredType="u_longlong_t")
	public UDATA iget() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._igetOffset_));
	}

	// u_longlong_t iget
	public UDATAPointer igetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._igetOffset_));
	}

	// I16 iowait
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iowaitOffset_", declaredType="I16")
	public I16 iowait() throws CorruptDataException {
		return new I16(getShortAtOffset(perfstat_cpu_total_t._iowaitOffset_));
	}

	// I16 iowait
	public I16Pointer iowaitEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(perfstat_cpu_total_t._iowaitOffset_));
	}

	// u_longlong_t kexit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_kexitOffset_", declaredType="u_longlong_t")
	public UDATA kexit() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._kexitOffset_));
	}

	// u_longlong_t kexit
	public UDATAPointer kexitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._kexitOffset_));
	}

	// u_longlong_t koverf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_koverfOffset_", declaredType="u_longlong_t")
	public UDATA koverf() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._koverfOffset_));
	}

	// u_longlong_t koverf
	public UDATAPointer koverfEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._koverfOffset_));
	}

	// u_longlong_t ksched
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_kschedOffset_", declaredType="u_longlong_t")
	public UDATA ksched() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._kschedOffset_));
	}

	// u_longlong_t ksched
	public UDATAPointer kschedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._kschedOffset_));
	}

	// time_t lbolt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lboltOffset_", declaredType="time_t")
	public IDATA lbolt() throws CorruptDataException {
		return new I64(getLongAtOffset(perfstat_cpu_total_t._lboltOffset_));
	}

	// time_t lbolt
	public IDATAPointer lboltEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._lboltOffset_));
	}

	// u_longlong_t[] loadavg
	public UDATAPointer loadavgEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(perfstat_cpu_total_t._loadavgOffset_));
	}

	// u_longlong_t lread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lreadOffset_", declaredType="u_longlong_t")
	public UDATA lread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._lreadOffset_));
	}

	// u_longlong_t lread
	public UDATAPointer lreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._lreadOffset_));
	}

	// u_longlong_t lwrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lwriteOffset_", declaredType="u_longlong_t")
	public UDATA lwrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._lwriteOffset_));
	}

	// u_longlong_t lwrite
	public UDATAPointer lwriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._lwriteOffset_));
	}

	// u_longlong_t mdmint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mdmintOffset_", declaredType="u_longlong_t")
	public UDATA mdmint() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._mdmintOffset_));
	}

	// u_longlong_t mdmint
	public UDATAPointer mdmintEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._mdmintOffset_));
	}

	// u_longlong_t mpcrintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mpcrintrsOffset_", declaredType="u_longlong_t")
	public UDATA mpcrintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._mpcrintrsOffset_));
	}

	// u_longlong_t mpcrintrs
	public UDATAPointer mpcrintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._mpcrintrsOffset_));
	}

	// u_longlong_t mpcsintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mpcsintrsOffset_", declaredType="u_longlong_t")
	public UDATA mpcsintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._mpcsintrsOffset_));
	}

	// u_longlong_t mpcsintrs
	public UDATAPointer mpcsintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._mpcsintrsOffset_));
	}

	// u_longlong_t msg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_msgOffset_", declaredType="u_longlong_t")
	public UDATA msg() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._msgOffset_));
	}

	// u_longlong_t msg
	public UDATAPointer msgEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._msgOffset_));
	}

	// u_longlong_t namei
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameiOffset_", declaredType="u_longlong_t")
	public UDATA namei() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._nameiOffset_));
	}

	// u_longlong_t namei
	public UDATAPointer nameiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._nameiOffset_));
	}

	// I32 ncpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ncpusOffset_", declaredType="I32")
	public IDATA ncpus() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_cpu_total_t._ncpusOffset_));
	}

	// I32 ncpus
	public IDATAPointer ncpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._ncpusOffset_));
	}

	// I32 ncpus_cfg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ncpus_cfgOffset_", declaredType="I32")
	public IDATA ncpus_cfg() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_cpu_total_t._ncpus_cfgOffset_));
	}

	// I32 ncpus_cfg
	public IDATAPointer ncpus_cfgEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._ncpus_cfgOffset_));
	}

	// I32 ncpus_high
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ncpus_highOffset_", declaredType="I32")
	public IDATA ncpus_high() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_cpu_total_t._ncpus_highOffset_));
	}

	// I32 ncpus_high
	public IDATAPointer ncpus_highEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._ncpus_highOffset_));
	}

	// u_longlong_t phantintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phantintrsOffset_", declaredType="u_longlong_t")
	public UDATA phantintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._phantintrsOffset_));
	}

	// u_longlong_t phantintrs
	public UDATAPointer phantintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._phantintrsOffset_));
	}

	// u_longlong_t phread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phreadOffset_", declaredType="u_longlong_t")
	public UDATA phread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._phreadOffset_));
	}

	// u_longlong_t phread
	public UDATAPointer phreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._phreadOffset_));
	}

	// u_longlong_t phwrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phwriteOffset_", declaredType="u_longlong_t")
	public UDATA phwrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._phwriteOffset_));
	}

	// u_longlong_t phwrite
	public UDATAPointer phwriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._phwriteOffset_));
	}

	// I16 physio
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_physioOffset_", declaredType="I16")
	public I16 physio() throws CorruptDataException {
		return new I16(getShortAtOffset(perfstat_cpu_total_t._physioOffset_));
	}

	// I16 physio
	public I16Pointer physioEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(perfstat_cpu_total_t._physioOffset_));
	}

	// u_longlong_t pidle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidleOffset_", declaredType="u_longlong_t")
	public UDATA pidle() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._pidleOffset_));
	}

	// u_longlong_t pidle
	public UDATAPointer pidleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._pidleOffset_));
	}

	// u_longlong_t pidle_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidle_spurrOffset_", declaredType="u_longlong_t")
	public UDATA pidle_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._pidle_spurrOffset_));
	}

	// u_longlong_t pidle_spurr
	public UDATAPointer pidle_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._pidle_spurrOffset_));
	}

	// u_longlong_t processorHZ
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_processorHZOffset_", declaredType="u_longlong_t")
	public UDATA processorHZ() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._processorHZOffset_));
	}

	// u_longlong_t processorHZ
	public UDATAPointer processorHZEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._processorHZOffset_));
	}

	// u_longlong_t pswitch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pswitchOffset_", declaredType="u_longlong_t")
	public UDATA pswitch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._pswitchOffset_));
	}

	// u_longlong_t pswitch
	public UDATAPointer pswitchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._pswitchOffset_));
	}

	// u_longlong_t psys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psysOffset_", declaredType="u_longlong_t")
	public UDATA psys() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._psysOffset_));
	}

	// u_longlong_t psys
	public UDATAPointer psysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._psysOffset_));
	}

	// u_longlong_t psys_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psys_spurrOffset_", declaredType="u_longlong_t")
	public UDATA psys_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._psys_spurrOffset_));
	}

	// u_longlong_t psys_spurr
	public UDATAPointer psys_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._psys_spurrOffset_));
	}

	// u_longlong_t purr_coalescing
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_purr_coalescingOffset_", declaredType="u_longlong_t")
	public UDATA purr_coalescing() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._purr_coalescingOffset_));
	}

	// u_longlong_t purr_coalescing
	public UDATAPointer purr_coalescingEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._purr_coalescingOffset_));
	}

	// u_longlong_t puser
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puserOffset_", declaredType="u_longlong_t")
	public UDATA puser() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._puserOffset_));
	}

	// u_longlong_t puser
	public UDATAPointer puserEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._puserOffset_));
	}

	// u_longlong_t puser_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puser_spurrOffset_", declaredType="u_longlong_t")
	public UDATA puser_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._puser_spurrOffset_));
	}

	// u_longlong_t puser_spurr
	public UDATAPointer puser_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._puser_spurrOffset_));
	}

	// u_longlong_t pwait
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwaitOffset_", declaredType="u_longlong_t")
	public UDATA pwait() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._pwaitOffset_));
	}

	// u_longlong_t pwait
	public UDATAPointer pwaitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._pwaitOffset_));
	}

	// u_longlong_t pwait_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwait_spurrOffset_", declaredType="u_longlong_t")
	public UDATA pwait_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._pwait_spurrOffset_));
	}

	// u_longlong_t pwait_spurr
	public UDATAPointer pwait_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._pwait_spurrOffset_));
	}

	// u_longlong_t rbread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rbreadOffset_", declaredType="u_longlong_t")
	public UDATA rbread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._rbreadOffset_));
	}

	// u_longlong_t rbread
	public UDATAPointer rbreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._rbreadOffset_));
	}

	// u_longlong_t rbwrt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rbwrtOffset_", declaredType="u_longlong_t")
	public UDATA rbwrt() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._rbwrtOffset_));
	}

	// u_longlong_t rbwrt
	public UDATAPointer rbwrtEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._rbwrtOffset_));
	}

	// u_longlong_t rcread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rcreadOffset_", declaredType="u_longlong_t")
	public UDATA rcread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._rcreadOffset_));
	}

	// u_longlong_t rcread
	public UDATAPointer rcreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._rcreadOffset_));
	}

	// u_longlong_t rcvint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rcvintOffset_", declaredType="u_longlong_t")
	public UDATA rcvint() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._rcvintOffset_));
	}

	// u_longlong_t rcvint
	public UDATAPointer rcvintEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._rcvintOffset_));
	}

	// u_longlong_t rcwrt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rcwrtOffset_", declaredType="u_longlong_t")
	public UDATA rcwrt() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._rcwrtOffset_));
	}

	// u_longlong_t rcwrt
	public UDATAPointer rcwrtEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._rcwrtOffset_));
	}

	// u_longlong_t readch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_readchOffset_", declaredType="u_longlong_t")
	public UDATA readch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._readchOffset_));
	}

	// u_longlong_t readch
	public UDATAPointer readchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._readchOffset_));
	}

	// u_longlong_t runocc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runoccOffset_", declaredType="u_longlong_t")
	public UDATA runocc() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._runoccOffset_));
	}

	// u_longlong_t runocc
	public UDATAPointer runoccEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._runoccOffset_));
	}

	// u_longlong_t runque
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runqueOffset_", declaredType="u_longlong_t")
	public UDATA runque() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._runqueOffset_));
	}

	// u_longlong_t runque
	public UDATAPointer runqueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._runqueOffset_));
	}

	// u_longlong_t sema
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_semaOffset_", declaredType="u_longlong_t")
	public UDATA sema() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._semaOffset_));
	}

	// u_longlong_t sema
	public UDATAPointer semaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._semaOffset_));
	}

	// u_longlong_t softintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_softintrsOffset_", declaredType="u_longlong_t")
	public UDATA softintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._softintrsOffset_));
	}

	// u_longlong_t softintrs
	public UDATAPointer softintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._softintrsOffset_));
	}

	// u_longlong_t spurr_coalescing
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spurr_coalescingOffset_", declaredType="u_longlong_t")
	public UDATA spurr_coalescing() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._spurr_coalescingOffset_));
	}

	// u_longlong_t spurr_coalescing
	public UDATAPointer spurr_coalescingEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._spurr_coalescingOffset_));
	}

	// I32 spurrflag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spurrflagOffset_", declaredType="I32")
	public IDATA spurrflag() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_cpu_total_t._spurrflagOffset_));
	}

	// I32 spurrflag
	public IDATAPointer spurrflagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._spurrflagOffset_));
	}

	// u_longlong_t swpocc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_swpoccOffset_", declaredType="u_longlong_t")
	public UDATA swpocc() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._swpoccOffset_));
	}

	// u_longlong_t swpocc
	public UDATAPointer swpoccEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._swpoccOffset_));
	}

	// u_longlong_t swpque
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_swpqueOffset_", declaredType="u_longlong_t")
	public UDATA swpque() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._swpqueOffset_));
	}

	// u_longlong_t swpque
	public UDATAPointer swpqueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._swpqueOffset_));
	}

	// u_longlong_t sys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysOffset_", declaredType="u_longlong_t")
	public UDATA sys() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._sysOffset_));
	}

	// u_longlong_t sys
	public UDATAPointer sysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._sysOffset_));
	}

	// u_longlong_t syscall
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_syscallOffset_", declaredType="u_longlong_t")
	public UDATA syscall() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._syscallOffset_));
	}

	// u_longlong_t syscall
	public UDATAPointer syscallEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._syscallOffset_));
	}

	// u_longlong_t sysexec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysexecOffset_", declaredType="u_longlong_t")
	public UDATA sysexec() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._sysexecOffset_));
	}

	// u_longlong_t sysexec
	public UDATAPointer sysexecEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._sysexecOffset_));
	}

	// u_longlong_t sysfork
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysforkOffset_", declaredType="u_longlong_t")
	public UDATA sysfork() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._sysforkOffset_));
	}

	// u_longlong_t sysfork
	public UDATAPointer sysforkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._sysforkOffset_));
	}

	// u_longlong_t sysread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysreadOffset_", declaredType="u_longlong_t")
	public UDATA sysread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._sysreadOffset_));
	}

	// u_longlong_t sysread
	public UDATAPointer sysreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._sysreadOffset_));
	}

	// u_longlong_t syswrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_syswriteOffset_", declaredType="u_longlong_t")
	public UDATA syswrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._syswriteOffset_));
	}

	// u_longlong_t syswrite
	public UDATAPointer syswriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._syswriteOffset_));
	}

	// u_longlong_t tb_last
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tb_lastOffset_", declaredType="u_longlong_t")
	public UDATA tb_last() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._tb_lastOffset_));
	}

	// u_longlong_t tb_last
	public UDATAPointer tb_lastEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._tb_lastOffset_));
	}

	// u_longlong_t traps
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_trapsOffset_", declaredType="u_longlong_t")
	public UDATA traps() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._trapsOffset_));
	}

	// u_longlong_t traps
	public UDATAPointer trapsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._trapsOffset_));
	}

	// u_longlong_t tty_caninch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_caninchOffset_", declaredType="u_longlong_t")
	public UDATA tty_caninch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._tty_caninchOffset_));
	}

	// u_longlong_t tty_caninch
	public UDATAPointer tty_caninchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._tty_caninchOffset_));
	}

	// u_longlong_t tty_rawinch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_rawinchOffset_", declaredType="u_longlong_t")
	public UDATA tty_rawinch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._tty_rawinchOffset_));
	}

	// u_longlong_t tty_rawinch
	public UDATAPointer tty_rawinchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._tty_rawinchOffset_));
	}

	// u_longlong_t tty_rawoutch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_rawoutchOffset_", declaredType="u_longlong_t")
	public UDATA tty_rawoutch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._tty_rawoutchOffset_));
	}

	// u_longlong_t tty_rawoutch
	public UDATAPointer tty_rawoutchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._tty_rawoutchOffset_));
	}

	// longlong_t twait
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_twaitOffset_", declaredType="longlong_t")
	public IDATA twait() throws CorruptDataException {
		return new I64(getLongAtOffset(perfstat_cpu_total_t._twaitOffset_));
	}

	// longlong_t twait
	public IDATAPointer twaitEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._twaitOffset_));
	}

	// u_longlong_t user
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_userOffset_", declaredType="u_longlong_t")
	public UDATA user() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._userOffset_));
	}

	// u_longlong_t user
	public UDATAPointer userEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._userOffset_));
	}

	// u_longlong_t version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="u_longlong_t")
	public UDATA version() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._versionOffset_));
	}

	// u_longlong_t version
	public UDATAPointer versionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._versionOffset_));
	}

	// u_longlong_t wait_field
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wait_fieldOffset_", declaredType="u_longlong_t")
	public UDATA wait_field() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._wait_fieldOffset_));
	}

	// u_longlong_t wait_field
	public UDATAPointer wait_fieldEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._wait_fieldOffset_));
	}

	// u_longlong_t writech
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_writechOffset_", declaredType="u_longlong_t")
	public UDATA writech() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._writechOffset_));
	}

	// u_longlong_t writech
	public UDATAPointer writechEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._writechOffset_));
	}

	// u_longlong_t xmtint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xmtintOffset_", declaredType="u_longlong_t")
	public UDATA xmtint() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_total_t._xmtintOffset_));
	}

	// u_longlong_t xmtint
	public UDATAPointer xmtintEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_total_t._xmtintOffset_));
	}

}
