/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: perfstat_partition_type_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the perfstat_partition_type_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=perfstat_partition_type_t.class)
public class perfstat_partition_type_tPointer extends StructurePointer {

	// NULL
	public static final perfstat_partition_type_tPointer NULL = new perfstat_partition_type_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected perfstat_partition_type_tPointer(long address) {
		super(address);
	}

	public static perfstat_partition_type_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static perfstat_partition_type_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static perfstat_partition_type_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new perfstat_partition_type_tPointer(address);
	}

	public perfstat_partition_type_tPointer add(long count) {
		return perfstat_partition_type_tPointer.cast(address + (perfstat_partition_type_t.SIZEOF * count));
	}

	public perfstat_partition_type_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public perfstat_partition_type_tPointer addOffset(long offset) {
		return perfstat_partition_type_tPointer.cast(address + offset);
	}

	public perfstat_partition_type_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public perfstat_partition_type_tPointer sub(long count) {
		return perfstat_partition_type_tPointer.cast(address - (perfstat_partition_type_t.SIZEOF * count));
	}

	public perfstat_partition_type_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public perfstat_partition_type_tPointer subOffset(long offset) {
		return perfstat_partition_type_tPointer.cast(address - offset);
	}

	public perfstat_partition_type_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public perfstat_partition_type_tPointer untag(long mask) {
		return perfstat_partition_type_tPointer.cast(address & ~mask);
	}

	public perfstat_partition_type_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return perfstat_partition_type_t.SIZEOF;
	}

	// Implementation methods

	// U32:1 b.ame_enabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$ame_enabledOffset_", declaredType="U32:1")
	public UDATA b$ame_enabled() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$ame_enabled_s_, perfstat_partition_type_t._b$ame_enabled_b_);
	}

	// U32:1 b.ams_capable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$ams_capableOffset_", declaredType="U32:1")
	public UDATA b$ams_capable() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$ams_capable_s_, perfstat_partition_type_t._b$ams_capable_b_);
	}

	// U32:1 b.ams_enabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$ams_enabledOffset_", declaredType="U32:1")
	public UDATA b$ams_enabled() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$ams_enabled_s_, perfstat_partition_type_t._b$ams_enabled_b_);
	}

	// U32:1 b.capped
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$cappedOffset_", declaredType="U32:1")
	public UDATA b$capped() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$capped_s_, perfstat_partition_type_t._b$capped_b_);
	}

	// U32:1 b.dlpar_capable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$dlpar_capableOffset_", declaredType="U32:1")
	public UDATA b$dlpar_capable() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$dlpar_capable_s_, perfstat_partition_type_t._b$dlpar_capable_b_);
	}

	// U32:1 b.donate_capable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$donate_capableOffset_", declaredType="U32:1")
	public UDATA b$donate_capable() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$donate_capable_s_, perfstat_partition_type_t._b$donate_capable_b_);
	}

	// U32:1 b.donate_enabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$donate_enabledOffset_", declaredType="U32:1")
	public UDATA b$donate_enabled() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$donate_enabled_s_, perfstat_partition_type_t._b$donate_enabled_b_);
	}

	// U32:1 b.kernel_is_64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$kernel_is_64Offset_", declaredType="U32:1")
	public UDATA b$kernel_is_64() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$kernel_is_64_s_, perfstat_partition_type_t._b$kernel_is_64_b_);
	}

	// U32:1 b.lpar_capable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$lpar_capableOffset_", declaredType="U32:1")
	public UDATA b$lpar_capable() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$lpar_capable_s_, perfstat_partition_type_t._b$lpar_capable_b_);
	}

	// U32:1 b.lpar_enabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$lpar_enabledOffset_", declaredType="U32:1")
	public UDATA b$lpar_enabled() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$lpar_enabled_s_, perfstat_partition_type_t._b$lpar_enabled_b_);
	}

	// U32:1 b.pool_util_authority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$pool_util_authorityOffset_", declaredType="U32:1")
	public UDATA b$pool_util_authority() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$pool_util_authority_s_, perfstat_partition_type_t._b$pool_util_authority_b_);
	}

	// U32:1 b.power_save
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$power_saveOffset_", declaredType="U32:1")
	public UDATA b$power_save() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$power_save_s_, perfstat_partition_type_t._b$power_save_b_);
	}

	// U32:1 b.shared_capable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$shared_capableOffset_", declaredType="U32:1")
	public UDATA b$shared_capable() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$shared_capable_s_, perfstat_partition_type_t._b$shared_capable_b_);
	}

	// U32:1 b.shared_enabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$shared_enabledOffset_", declaredType="U32:1")
	public UDATA b$shared_enabled() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$shared_enabled_s_, perfstat_partition_type_t._b$shared_enabled_b_);
	}

	// U32:1 b.shared_extended
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$shared_extendedOffset_", declaredType="U32:1")
	public UDATA b$shared_extended() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$shared_extended_s_, perfstat_partition_type_t._b$shared_extended_b_);
	}

	// U32:1 b.smt_capable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$smt_capableOffset_", declaredType="U32:1")
	public UDATA b$smt_capable() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$smt_capable_s_, perfstat_partition_type_t._b$smt_capable_b_);
	}

	// U32:1 b.smt_enabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$smt_enabledOffset_", declaredType="U32:1")
	public UDATA b$smt_enabled() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$smt_enabled_s_, perfstat_partition_type_t._b$smt_enabled_b_);
	}

	// U32:15 b.spare
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_b$spareOffset_", declaredType="U32:15")
	public UDATA b$spare() throws CorruptDataException {
		return getU32Bitfield(perfstat_partition_type_t._b$spare_s_, perfstat_partition_type_t._b$spare_b_);
	}

	// uint w
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wOffset_", declaredType="uint")
	public UDATA w() throws CorruptDataException {
		return new U32(getIntAtOffset(perfstat_partition_type_t._wOffset_));
	}

	// uint w
	public UDATAPointer wEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_type_t._wOffset_));
	}

}
