/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: random_dataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the random_dataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=random_data.class)
public class random_dataPointer extends StructurePointer {

	// NULL
	public static final random_dataPointer NULL = new random_dataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected random_dataPointer(long address) {
		super(address);
	}

	public static random_dataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static random_dataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static random_dataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new random_dataPointer(address);
	}

	public random_dataPointer add(long count) {
		return random_dataPointer.cast(address + (random_data.SIZEOF * count));
	}

	public random_dataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public random_dataPointer addOffset(long offset) {
		return random_dataPointer.cast(address + offset);
	}

	public random_dataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public random_dataPointer sub(long count) {
		return random_dataPointer.cast(address - (random_data.SIZEOF * count));
	}

	public random_dataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public random_dataPointer subOffset(long offset) {
		return random_dataPointer.cast(address - offset);
	}

	public random_dataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public random_dataPointer untag(long mask) {
		return random_dataPointer.cast(address & ~mask);
	}

	public random_dataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return random_data.SIZEOF;
	}

	// Implementation methods

	// I32* end_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_end_ptrOffset_", declaredType="I32*")
	public IDATAPointer end_ptr() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(random_data._end_ptrOffset_));
	}

	// I32* end_ptr
	public PointerPointer end_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(random_data._end_ptrOffset_));
	}

	// I32* fptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fptrOffset_", declaredType="I32*")
	public IDATAPointer fptr() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(random_data._fptrOffset_));
	}

	// I32* fptr
	public PointerPointer fptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(random_data._fptrOffset_));
	}

	// I32 rand_deg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rand_degOffset_", declaredType="I32")
	public IDATA rand_deg() throws CorruptDataException {
		return new I32(getIntAtOffset(random_data._rand_degOffset_));
	}

	// I32 rand_deg
	public IDATAPointer rand_degEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(random_data._rand_degOffset_));
	}

	// I32 rand_sep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rand_sepOffset_", declaredType="I32")
	public IDATA rand_sep() throws CorruptDataException {
		return new I32(getIntAtOffset(random_data._rand_sepOffset_));
	}

	// I32 rand_sep
	public IDATAPointer rand_sepEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(random_data._rand_sepOffset_));
	}

	// I32 rand_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rand_typeOffset_", declaredType="I32")
	public IDATA rand_type() throws CorruptDataException {
		return new I32(getIntAtOffset(random_data._rand_typeOffset_));
	}

	// I32 rand_type
	public IDATAPointer rand_typeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(random_data._rand_typeOffset_));
	}

	// I32* rptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rptrOffset_", declaredType="I32*")
	public IDATAPointer rptr() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(random_data._rptrOffset_));
	}

	// I32* rptr
	public PointerPointer rptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(random_data._rptrOffset_));
	}

	// I32* state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stateOffset_", declaredType="I32*")
	public IDATAPointer state() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(random_data._stateOffset_));
	}

	// I32* state
	public PointerPointer stateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(random_data._stateOffset_));
	}

}
