/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: sec_attrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the sec_attrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=sec_attr.class)
public class sec_attrPointer extends StructurePointer {

	// NULL
	public static final sec_attrPointer NULL = new sec_attrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected sec_attrPointer(long address) {
		super(address);
	}

	public static sec_attrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static sec_attrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static sec_attrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new sec_attrPointer(address);
	}

	public sec_attrPointer add(long count) {
		return sec_attrPointer.cast(address + (sec_attr.SIZEOF * count));
	}

	public sec_attrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public sec_attrPointer addOffset(long offset) {
		return sec_attrPointer.cast(address + offset);
	}

	public sec_attrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public sec_attrPointer sub(long count) {
		return sec_attrPointer.cast(address - (sec_attr.SIZEOF * count));
	}

	public sec_attrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public sec_attrPointer subOffset(long offset) {
		return sec_attrPointer.cast(address - offset);
	}

	public sec_attrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public sec_attrPointer untag(long mask) {
		return sec_attrPointer.cast(address & ~mask);
	}

	public sec_attrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return sec_attr.SIZEOF;
	}

	// Implementation methods

	// subsec_attr_t sc_attr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_attrOffset_", declaredType="subsec_attr_t")
	public subsec_attrPointer sc_attr() throws CorruptDataException {
		return subsec_attrPointer.cast(nonNullFieldEA(sec_attr._sc_attrOffset_));
	}

	// subsec_attr_t sc_attr
	public PointerPointer sc_attrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sec_attr._sc_attrOffset_));
	}

	// uid_t sc_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_gidOffset_", declaredType="uid_t")
	public UDATA sc_gid() throws CorruptDataException {
		return new U32(getIntAtOffset(sec_attr._sc_gidOffset_));
	}

	// uid_t sc_gid
	public UDATAPointer sc_gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sec_attr._sc_gidOffset_));
	}

	// gid_t[] sc_groups
	public UDATAPointer sc_groupsEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(sec_attr._sc_groupsOffset_));
	}

	// uid_t sc_luid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_luidOffset_", declaredType="uid_t")
	public UDATA sc_luid() throws CorruptDataException {
		return new U32(getIntAtOffset(sec_attr._sc_luidOffset_));
	}

	// uid_t sc_luid
	public UDATAPointer sc_luidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sec_attr._sc_luidOffset_));
	}

	// I16 sc_ngrps
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_ngrpsOffset_", declaredType="I16")
	public I16 sc_ngrps() throws CorruptDataException {
		return new I16(getShortAtOffset(sec_attr._sc_ngrpsOffset_));
	}

	// I16 sc_ngrps
	public I16Pointer sc_ngrpsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(sec_attr._sc_ngrpsOffset_));
	}

	// I16 sc_pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_padOffset_", declaredType="I16")
	public I16 sc_pad() throws CorruptDataException {
		return new I16(getShortAtOffset(sec_attr._sc_padOffset_));
	}

	// I16 sc_pad
	public I16Pointer sc_padEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(sec_attr._sc_padOffset_));
	}

	// uid_t sc_rgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_rgidOffset_", declaredType="uid_t")
	public UDATA sc_rgid() throws CorruptDataException {
		return new U32(getIntAtOffset(sec_attr._sc_rgidOffset_));
	}

	// uid_t sc_rgid
	public UDATAPointer sc_rgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sec_attr._sc_rgidOffset_));
	}

	// uid_t sc_ruid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_ruidOffset_", declaredType="uid_t")
	public UDATA sc_ruid() throws CorruptDataException {
		return new U32(getIntAtOffset(sec_attr._sc_ruidOffset_));
	}

	// uid_t sc_ruid
	public UDATAPointer sc_ruidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sec_attr._sc_ruidOffset_));
	}

	// uid_t sc_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_uidOffset_", declaredType="uid_t")
	public UDATA sc_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(sec_attr._sc_uidOffset_));
	}

	// uid_t sc_uid
	public UDATAPointer sc_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sec_attr._sc_uidOffset_));
	}

}
