/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: sigcontext64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the sigcontext64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=sigcontext64.class)
public class sigcontext64Pointer extends StructurePointer {

	// NULL
	public static final sigcontext64Pointer NULL = new sigcontext64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected sigcontext64Pointer(long address) {
		super(address);
	}

	public static sigcontext64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static sigcontext64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static sigcontext64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new sigcontext64Pointer(address);
	}

	public sigcontext64Pointer add(long count) {
		return sigcontext64Pointer.cast(address + (sigcontext64.SIZEOF * count));
	}

	public sigcontext64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public sigcontext64Pointer addOffset(long offset) {
		return sigcontext64Pointer.cast(address + offset);
	}

	public sigcontext64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public sigcontext64Pointer sub(long count) {
		return sigcontext64Pointer.cast(address - (sigcontext64.SIZEOF * count));
	}

	public sigcontext64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public sigcontext64Pointer subOffset(long offset) {
		return sigcontext64Pointer.cast(address - offset);
	}

	public sigcontext64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public sigcontext64Pointer untag(long mask) {
		return sigcontext64Pointer.cast(address & ~mask);
	}

	public sigcontext64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return sigcontext64.SIZEOF;
	}

	// Implementation methods

	// __context64 sc_context
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_contextOffset_", declaredType="__context64")
	public __context64Pointer sc_context() throws CorruptDataException {
		return __context64Pointer.cast(nonNullFieldEA(sigcontext64._sc_contextOffset_));
	}

	// __context64 sc_context
	public PointerPointer sc_contextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sigcontext64._sc_contextOffset_));
	}

	// sigset64_t sc_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_maskOffset_", declaredType="sigset64_t")
	public sigset64_tPointer sc_mask() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(sigcontext64._sc_maskOffset_));
	}

	// sigset64_t sc_mask
	public PointerPointer sc_maskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sigcontext64._sc_maskOffset_));
	}

	// I32 sc_onstack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_onstackOffset_", declaredType="I32")
	public IDATA sc_onstack() throws CorruptDataException {
		return new I32(getIntAtOffset(sigcontext64._sc_onstackOffset_));
	}

	// I32 sc_onstack
	public IDATAPointer sc_onstackEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(sigcontext64._sc_onstackOffset_));
	}

	// I32 sc_uerror
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_uerrorOffset_", declaredType="I32")
	public IDATA sc_uerror() throws CorruptDataException {
		return new I32(getIntAtOffset(sigcontext64._sc_uerrorOffset_));
	}

	// I32 sc_uerror
	public IDATAPointer sc_uerrorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(sigcontext64._sc_uerrorOffset_));
	}

}
