/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: thread_cputimePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the thread_cputimePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=thread_cputime.class)
public class thread_cputimePointer extends StructurePointer {

	// NULL
	public static final thread_cputimePointer NULL = new thread_cputimePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected thread_cputimePointer(long address) {
		super(address);
	}

	public static thread_cputimePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static thread_cputimePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static thread_cputimePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new thread_cputimePointer(address);
	}

	public thread_cputimePointer add(long count) {
		return thread_cputimePointer.cast(address + (thread_cputime.SIZEOF * count));
	}

	public thread_cputimePointer add(Scalar count) {
		return add(count.longValue());
	}

	public thread_cputimePointer addOffset(long offset) {
		return thread_cputimePointer.cast(address + offset);
	}

	public thread_cputimePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public thread_cputimePointer sub(long count) {
		return thread_cputimePointer.cast(address - (thread_cputime.SIZEOF * count));
	}

	public thread_cputimePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public thread_cputimePointer subOffset(long offset) {
		return thread_cputimePointer.cast(address - offset);
	}

	public thread_cputimePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public thread_cputimePointer untag(long mask) {
		return thread_cputimePointer.cast(address & ~mask);
	}

	public thread_cputimePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return thread_cputime.SIZEOF;
	}

	// Implementation methods

	// U64 stime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stimeOffset_", declaredType="U64")
	public UDATA stime() throws CorruptDataException {
		return new U64(getLongAtOffset(thread_cputime._stimeOffset_));
	}

	// U64 stime
	public UDATAPointer stimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread_cputime._stimeOffset_));
	}

	// U64 utime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_utimeOffset_", declaredType="U64")
	public UDATA utime() throws CorruptDataException {
		return new U64(getLongAtOffset(thread_cputime._utimeOffset_));
	}

	// U64 utime
	public UDATAPointer utimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread_cputime._utimeOffset_));
	}

}
