/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: wpar_info_format_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the wpar_info_format_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=wpar_info_format_t.class)
public class wpar_info_format_tPointer extends StructurePointer {

	// NULL
	public static final wpar_info_format_tPointer NULL = new wpar_info_format_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected wpar_info_format_tPointer(long address) {
		super(address);
	}

	public static wpar_info_format_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static wpar_info_format_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static wpar_info_format_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new wpar_info_format_tPointer(address);
	}

	public wpar_info_format_tPointer add(long count) {
		return wpar_info_format_tPointer.cast(address + (wpar_info_format_t.SIZEOF * count));
	}

	public wpar_info_format_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public wpar_info_format_tPointer addOffset(long offset) {
		return wpar_info_format_tPointer.cast(address + offset);
	}

	public wpar_info_format_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public wpar_info_format_tPointer sub(long count) {
		return wpar_info_format_tPointer.cast(address - (wpar_info_format_t.SIZEOF * count));
	}

	public wpar_info_format_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public wpar_info_format_tPointer subOffset(long offset) {
		return wpar_info_format_tPointer.cast(address - offset);
	}

	public wpar_info_format_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public wpar_info_format_tPointer untag(long mask) {
		return wpar_info_format_tPointer.cast(address & ~mask);
	}

	public wpar_info_format_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return wpar_info_format_t.SIZEOF;
	}

	// Implementation methods

	// U8[] pad1
	public U8Pointer pad1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(wpar_info_format_t._pad1Offset_));
	}

	// uint partition_cpu_limit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_partition_cpu_limitOffset_", declaredType="uint")
	public UDATA partition_cpu_limit() throws CorruptDataException {
		return new U32(getIntAtOffset(wpar_info_format_t._partition_cpu_limitOffset_));
	}

	// uint partition_cpu_limit
	public UDATAPointer partition_cpu_limitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(wpar_info_format_t._partition_cpu_limitOffset_));
	}

	// I32 percent_cpu_limit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_percent_cpu_limitOffset_", declaredType="I32")
	public IDATA percent_cpu_limit() throws CorruptDataException {
		return new I32(getIntAtOffset(wpar_info_format_t._percent_cpu_limitOffset_));
	}

	// I32 percent_cpu_limit
	public IDATAPointer percent_cpu_limitEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(wpar_info_format_t._percent_cpu_limitOffset_));
	}

	// I32 version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="I32")
	public IDATA version() throws CorruptDataException {
		return new I32(getIntAtOffset(wpar_info_format_t._versionOffset_));
	}

	// I32 version
	public IDATAPointer versionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(wpar_info_format_t._versionOffset_));
	}

	// cid_t wpar_cid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wpar_cidOffset_", declaredType="cid_t")
	public U16 wpar_cid() throws CorruptDataException {
		return new U16(getShortAtOffset(wpar_info_format_t._wpar_cidOffset_));
	}

	// cid_t wpar_cid
	public U16Pointer wpar_cidEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(wpar_info_format_t._wpar_cidOffset_));
	}

	// ckey_t wpar_ckey
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wpar_ckeyOffset_", declaredType="ckey_t")
	public UDATA wpar_ckey() throws CorruptDataException {
		return new U32(getIntAtOffset(wpar_info_format_t._wpar_ckeyOffset_));
	}

	// ckey_t wpar_ckey
	public UDATAPointer wpar_ckeyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(wpar_info_format_t._wpar_ckeyOffset_));
	}

	// uint wpar_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wpar_flagsOffset_", declaredType="uint")
	public UDATA wpar_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(wpar_info_format_t._wpar_flagsOffset_));
	}

	// uint wpar_flags
	public UDATAPointer wpar_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(wpar_info_format_t._wpar_flagsOffset_));
	}

}
