/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LC_time_objhdlPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LC_time_objhdlPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LC_time_objhdl.class)
public class _LC_time_objhdlPointer extends StructurePointer {

	// NULL
	public static final _LC_time_objhdlPointer NULL = new _LC_time_objhdlPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LC_time_objhdlPointer(long address) {
		super(address);
	}

	public static _LC_time_objhdlPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LC_time_objhdlPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LC_time_objhdlPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LC_time_objhdlPointer(address);
	}

	public _LC_time_objhdlPointer add(long count) {
		return _LC_time_objhdlPointer.cast(address + (_LC_time_objhdl.SIZEOF * count));
	}

	public _LC_time_objhdlPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LC_time_objhdlPointer addOffset(long offset) {
		return _LC_time_objhdlPointer.cast(address + offset);
	}

	public _LC_time_objhdlPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LC_time_objhdlPointer sub(long count) {
		return _LC_time_objhdlPointer.cast(address - (_LC_time_objhdl.SIZEOF * count));
	}

	public _LC_time_objhdlPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LC_time_objhdlPointer subOffset(long offset) {
		return _LC_time_objhdlPointer.cast(address - offset);
	}

	public _LC_time_objhdlPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LC_time_objhdlPointer untag(long mask) {
		return _LC_time_objhdlPointer.cast(address & ~mask);
	}

	public _LC_time_objhdlPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LC_time_objhdl.SIZEOF;
	}

	// Implementation methods

	// _LC_locale_objhdl* loc_hdl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loc_hdlOffset_", declaredType="_LC_locale_objhdl*")
	public _LC_locale_objhdlPointer loc_hdl() throws CorruptDataException {
		return _LC_locale_objhdlPointer.cast(getPointerAtOffset(_LC_time_objhdl._loc_hdlOffset_));
	}

	// _LC_locale_objhdl* loc_hdl
	public PointerPointer loc_hdlEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_time_objhdl._loc_hdlOffset_));
	}

	// void** meth
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methOffset_", declaredType="void**")
	public PointerPointer meth() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(_LC_time_objhdl._methOffset_));
	}

	// void** meth
	public PointerPointer methEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_time_objhdl._methOffset_));
	}

	// _LC_time_t* obj
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_objOffset_", declaredType="_LC_time_t*")
	public _LC_time_tPointer obj() throws CorruptDataException {
		return _LC_time_tPointer.cast(getPointerAtOffset(_LC_time_objhdl._objOffset_));
	}

	// _LC_time_t* obj
	public PointerPointer objEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_time_objhdl._objOffset_));
	}

}
