/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _ptrace_infoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _ptrace_infoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_ptrace_info.class)
public class _ptrace_infoPointer extends StructurePointer {

	// NULL
	public static final _ptrace_infoPointer NULL = new _ptrace_infoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _ptrace_infoPointer(long address) {
		super(address);
	}

	public static _ptrace_infoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _ptrace_infoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _ptrace_infoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _ptrace_infoPointer(address);
	}

	public _ptrace_infoPointer add(long count) {
		return _ptrace_infoPointer.cast(address + (_ptrace_info.SIZEOF * count));
	}

	public _ptrace_infoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _ptrace_infoPointer addOffset(long offset) {
		return _ptrace_infoPointer.cast(address + offset);
	}

	public _ptrace_infoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _ptrace_infoPointer sub(long count) {
		return _ptrace_infoPointer.cast(address - (_ptrace_info.SIZEOF * count));
	}

	public _ptrace_infoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _ptrace_infoPointer subOffset(long offset) {
		return _ptrace_infoPointer.cast(address - offset);
	}

	public _ptrace_infoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _ptrace_infoPointer untag(long mask) {
		return _ptrace_infoPointer.cast(address & ~mask);
	}

	public _ptrace_infoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _ptrace_info.SIZEOF;
	}

	// Implementation methods

	// U32 ptrace_info_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ptrace_info_sizeOffset_", declaredType="U32")
	public UDATA ptrace_info_size() throws CorruptDataException {
		return new U32(getIntAtOffset(_ptrace_info._ptrace_info_sizeOffset_));
	}

	// U32 ptrace_info_size
	public UDATAPointer ptrace_info_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_ptrace_info._ptrace_info_sizeOffset_));
	}

	// U32 total_info_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_total_info_sizeOffset_", declaredType="U32")
	public UDATA total_info_size() throws CorruptDataException {
		return new U32(getIntAtOffset(_ptrace_info._total_info_sizeOffset_));
	}

	// U32 total_info_size
	public UDATAPointer total_info_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_ptrace_info._total_info_sizeOffset_));
	}

	// offset_t watchpoints_hdr_off
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_watchpoints_hdr_offOffset_", declaredType="offset_t")
	public IDATA watchpoints_hdr_off() throws CorruptDataException {
		return new I64(getLongAtOffset(_ptrace_info._watchpoints_hdr_offOffset_));
	}

	// offset_t watchpoints_hdr_off
	public IDATAPointer watchpoints_hdr_offEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_ptrace_info._watchpoints_hdr_offOffset_));
	}

}
