/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: stat64xPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the stat64xPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=stat64x.class)
public class stat64xPointer extends StructurePointer {

	// NULL
	public static final stat64xPointer NULL = new stat64xPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected stat64xPointer(long address) {
		super(address);
	}

	public static stat64xPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static stat64xPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static stat64xPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new stat64xPointer(address);
	}

	public stat64xPointer add(long count) {
		return stat64xPointer.cast(address + (stat64x.SIZEOF * count));
	}

	public stat64xPointer add(Scalar count) {
		return add(count.longValue());
	}

	public stat64xPointer addOffset(long offset) {
		return stat64xPointer.cast(address + offset);
	}

	public stat64xPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public stat64xPointer sub(long count) {
		return stat64xPointer.cast(address - (stat64x.SIZEOF * count));
	}

	public stat64xPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public stat64xPointer subOffset(long offset) {
		return stat64xPointer.cast(address - offset);
	}

	public stat64xPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public stat64xPointer untag(long mask) {
		return stat64xPointer.cast(address & ~mask);
	}

	public stat64xPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return stat64x.SIZEOF;
	}

	// Implementation methods

	// timespec64 st_atim
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_atimOffset_", declaredType="timespec64")
	public timespec64Pointer st_atim() throws CorruptDataException {
		return timespec64Pointer.cast(nonNullFieldEA(stat64x._st_atimOffset_));
	}

	// timespec64 st_atim
	public PointerPointer st_atimEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(stat64x._st_atimOffset_));
	}

	// blksize64_t st_blksize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_blksizeOffset_", declaredType="blksize64_t")
	public UDATA st_blksize() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64x._st_blksizeOffset_));
	}

	// blksize64_t st_blksize
	public UDATAPointer st_blksizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_blksizeOffset_));
	}

	// blkcnt64_t st_blocks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_blocksOffset_", declaredType="blkcnt64_t")
	public UDATA st_blocks() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64x._st_blocksOffset_));
	}

	// blkcnt64_t st_blocks
	public UDATAPointer st_blocksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_blocksOffset_));
	}

	// timespec64 st_ctim
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_ctimOffset_", declaredType="timespec64")
	public timespec64Pointer st_ctim() throws CorruptDataException {
		return timespec64Pointer.cast(nonNullFieldEA(stat64x._st_ctimOffset_));
	}

	// timespec64 st_ctim
	public PointerPointer st_ctimEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(stat64x._st_ctimOffset_));
	}

	// dev64_t st_dev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_devOffset_", declaredType="dev64_t")
	public UDATA st_dev() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64x._st_devOffset_));
	}

	// dev64_t st_dev
	public UDATAPointer st_devEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_devOffset_));
	}

	// ushort_t st_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_flagOffset_", declaredType="ushort_t")
	public U16 st_flag() throws CorruptDataException {
		return new U16(getShortAtOffset(stat64x._st_flagOffset_));
	}

	// ushort_t st_flag
	public U16Pointer st_flagEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(stat64x._st_flagOffset_));
	}

	// U32 st_gen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_genOffset_", declaredType="U32")
	public UDATA st_gen() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64x._st_genOffset_));
	}

	// U32 st_gen
	public UDATAPointer st_genEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_genOffset_));
	}

	// gid_t st_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_gidOffset_", declaredType="gid_t")
	public UDATA st_gid() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64x._st_gidOffset_));
	}

	// gid_t st_gid
	public UDATAPointer st_gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_gidOffset_));
	}

	// ino64_t st_ino
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_inoOffset_", declaredType="ino64_t")
	public UDATA st_ino() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64x._st_inoOffset_));
	}

	// ino64_t st_ino
	public UDATAPointer st_inoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_inoOffset_));
	}

	// mode_t st_mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_modeOffset_", declaredType="mode_t")
	public UDATA st_mode() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64x._st_modeOffset_));
	}

	// mode_t st_mode
	public UDATAPointer st_modeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_modeOffset_));
	}

	// timespec64 st_mtim
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_mtimOffset_", declaredType="timespec64")
	public timespec64Pointer st_mtim() throws CorruptDataException {
		return timespec64Pointer.cast(nonNullFieldEA(stat64x._st_mtimOffset_));
	}

	// timespec64 st_mtim
	public PointerPointer st_mtimEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(stat64x._st_mtimOffset_));
	}

	// nlink_t st_nlink
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_nlinkOffset_", declaredType="nlink_t")
	public I16 st_nlink() throws CorruptDataException {
		return new I16(getShortAtOffset(stat64x._st_nlinkOffset_));
	}

	// nlink_t st_nlink
	public I16Pointer st_nlinkEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(stat64x._st_nlinkOffset_));
	}

	// dev64_t st_rdev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_rdevOffset_", declaredType="dev64_t")
	public UDATA st_rdev() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64x._st_rdevOffset_));
	}

	// dev64_t st_rdev
	public UDATAPointer st_rdevEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_rdevOffset_));
	}

	// U32[] st_reserved
	public UDATAPointer st_reservedEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(stat64x._st_reservedOffset_));
	}

	// off_t st_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_sizeOffset_", declaredType="off_t")
	public IDATA st_size() throws CorruptDataException {
		return new I64(getLongAtOffset(stat64x._st_sizeOffset_));
	}

	// off_t st_size
	public IDATAPointer st_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(stat64x._st_sizeOffset_));
	}

	// U32 st_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_typeOffset_", declaredType="U32")
	public UDATA st_type() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64x._st_typeOffset_));
	}

	// U32 st_type
	public UDATAPointer st_typeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_typeOffset_));
	}

	// uid_t st_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_uidOffset_", declaredType="uid_t")
	public UDATA st_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64x._st_uidOffset_));
	}

	// uid_t st_uid
	public UDATAPointer st_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_uidOffset_));
	}

	// U32 st_vfs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_vfsOffset_", declaredType="U32")
	public UDATA st_vfs() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64x._st_vfsOffset_));
	}

	// U32 st_vfs
	public UDATAPointer st_vfsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64x._st_vfsOffset_));
	}

	// I32 st_vfstype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_vfstypeOffset_", declaredType="I32")
	public IDATA st_vfstype() throws CorruptDataException {
		return new I32(getIntAtOffset(stat64x._st_vfstypeOffset_));
	}

	// I32 st_vfstype
	public IDATAPointer st_vfstypeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(stat64x._st_vfstypeOffset_));
	}

}
