/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: pvthread
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class pvthread {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _tv_affinityOffset_;
	public static final int _tv_chkfileOffset_;
	public static final int _tv_classOffset_;
	public static final int _tv_eyecOffset_;
	public static final int _tv_flagsOffset_;
	public static final int _tv_flags2Offset_;
	public static final int _tv_hmcr_lockOffset_;
	public static final int _tv_intercept_countOffset_;
	public static final int _tv_itagsOffset_;
	public static final int _tv_itags_ptrOffset_;
	public static final int _tv_lock_dOffset_;
	public static final int _tv_nextzombieOffset_;
	public static final int _tv_padOffset_;
	public static final int _tv_pad1Offset_;
	public static final int _tv_pad2Offset_;
	public static final int _tv_pmcontextOffset_;
	public static final int _tv_prbaseOffset_;
	public static final int _tv_prbufcountOffset_;
	public static final int _tv_prflagsOffset_;
	public static final int _tv_priOffset_;
	public static final int _tv_procfsvnOffset_;
	public static final int _tv_prpinnedOffset_;
	public static final int _tv_ptagOffset_;
	public static final int _tv_ptidOffset_;
	public static final int _tv_pvprocpOffset_;
	public static final int _tv_rsetOffset_;
	public static final int _tv_stateOffset_;
	public static final int _tv_synchOffset_;
	public static final int _tv_threadlist$nextthreadOffset_;
	public static final int _tv_threadlist$prevthreadOffset_;
	public static final int _tv_threadpOffset_;
	public static final int _tv_tidOffset_;
	public static final int _tv_totalcputimeOffset_;
	public static final int _tv_totalscputimeOffset_;
	public static final int _tv_tsleepOffset_;
	public static final int _tv_vtidOffset_;
	public static final int _tv_wchanOffset_;
	public static final int _tv_wlmOffset_;
	public static final int _tv_wtypeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_tv_affinityOffset_ = 0;
		_tv_chkfileOffset_ = 0;
		_tv_classOffset_ = 0;
		_tv_eyecOffset_ = 0;
		_tv_flagsOffset_ = 0;
		_tv_flags2Offset_ = 0;
		_tv_hmcr_lockOffset_ = 0;
		_tv_intercept_countOffset_ = 0;
		_tv_itagsOffset_ = 0;
		_tv_itags_ptrOffset_ = 0;
		_tv_lock_dOffset_ = 0;
		_tv_nextzombieOffset_ = 0;
		_tv_padOffset_ = 0;
		_tv_pad1Offset_ = 0;
		_tv_pad2Offset_ = 0;
		_tv_pmcontextOffset_ = 0;
		_tv_prbaseOffset_ = 0;
		_tv_prbufcountOffset_ = 0;
		_tv_prflagsOffset_ = 0;
		_tv_priOffset_ = 0;
		_tv_procfsvnOffset_ = 0;
		_tv_prpinnedOffset_ = 0;
		_tv_ptagOffset_ = 0;
		_tv_ptidOffset_ = 0;
		_tv_pvprocpOffset_ = 0;
		_tv_rsetOffset_ = 0;
		_tv_stateOffset_ = 0;
		_tv_synchOffset_ = 0;
		_tv_threadlist$nextthreadOffset_ = 0;
		_tv_threadlist$prevthreadOffset_ = 0;
		_tv_threadpOffset_ = 0;
		_tv_tidOffset_ = 0;
		_tv_totalcputimeOffset_ = 0;
		_tv_totalscputimeOffset_ = 0;
		_tv_tsleepOffset_ = 0;
		_tv_vtidOffset_ = 0;
		_tv_wchanOffset_ = 0;
		_tv_wlmOffset_ = 0;
		_tv_wtypeOffset_ = 0;
	}

}
