/*
 * Copyright IBM Corp. and others 2006
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.jvm;

import java.util.Objects;

/**
 *
 * The <code>Log</code> class contains methods for controlling system log options
 * This class cannot be instantiated.
 */
public class Log {

	/**
	 * Query the log options. Returns a String representation of the log options.
	 * @return The current log options
	 */
	public static String QueryOptions() {
		return QueryOptionsImpl();
	}

	/**
	 * Set the log options.
	 * Use the same syntax as the -Xsyslog command-line option, with the initial -Xsyslog: omitted.
	 *
	 * @param options The command line log flags.
	 * @return status 0 on success otherwise a RuntimeException is thrown
	 *
	 * @throws RuntimeException if there is a problem setting the log options
	 */
	public static int SetOptions(String options) {
		Objects.requireNonNull(options, "options"); //$NON-NLS-1$
		return SetOptionsImpl(options);
	}

	/*
	 * Log should not be instantiated.
	 */
	private Log() {
	}

	private static native String QueryOptionsImpl();
	private static native int SetOptionsImpl(String options);
}
