/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: dr_infoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the dr_infoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=dr_info.class)
public class dr_infoPointer extends StructurePointer {

	// NULL
	public static final dr_infoPointer NULL = new dr_infoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected dr_infoPointer(long address) {
		super(address);
	}

	public static dr_infoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static dr_infoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static dr_infoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new dr_infoPointer(address);
	}

	public dr_infoPointer add(long count) {
		return dr_infoPointer.cast(address + (dr_info.SIZEOF * count));
	}

	public dr_infoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public dr_infoPointer addOffset(long offset) {
		return dr_infoPointer.cast(address + offset);
	}

	public dr_infoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public dr_infoPointer sub(long count) {
		return dr_infoPointer.cast(address - (dr_info.SIZEOF * count));
	}

	public dr_infoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public dr_infoPointer subOffset(long offset) {
		return dr_infoPointer.cast(address - offset);
	}

	public dr_infoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public dr_infoPointer untag(long mask) {
		return dr_infoPointer.cast(address & ~mask);
	}

	public dr_infoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return dr_info.SIZEOF;
	}

	// Implementation methods

	// U32:1 acc_update
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_acc_updateOffset_", declaredType="U32:1")
	public UDATA acc_update() throws CorruptDataException {
		return getU32Bitfield(dr_info._acc_update_s_, dr_info._acc_update_b_);
	}

	// U32:1 acu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_acuOffset_", declaredType="U32:1")
	public UDATA acu() throws CorruptDataException {
		return getU32Bitfield(dr_info._acu_s_, dr_info._acu_b_);
	}

	// U32:1 add
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_addOffset_", declaredType="U32:1")
	public UDATA add() throws CorruptDataException {
		return getU32Bitfield(dr_info._add_s_, dr_info._add_b_);
	}

	// I32 bcpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bcpuOffset_", declaredType="I32")
	public IDATA bcpu() throws CorruptDataException {
		return new I32(getIntAtOffset(dr_info._bcpuOffset_));
	}

	// I32 bcpu
	public IDATAPointer bcpuEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(dr_info._bcpuOffset_));
	}

	// U32:1 bindproc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bindprocOffset_", declaredType="U32:1")
	public UDATA bindproc() throws CorruptDataException {
		return getU32Bitfield(dr_info._bindproc_s_, dr_info._bindproc_b_);
	}

	// U32:1 cap_constrained
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cap_constrainedOffset_", declaredType="U32:1")
	public UDATA cap_constrained() throws CorruptDataException {
		return getU32Bitfield(dr_info._cap_constrained_s_, dr_info._cap_constrained_b_);
	}

	// U64 capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_capacityOffset_", declaredType="U64")
	public UDATA capacity() throws CorruptDataException {
		return new U64(getLongAtOffset(dr_info._capacityOffset_));
	}

	// U64 capacity
	public UDATAPointer capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dr_info._capacityOffset_));
	}

	// U32:1 check
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_checkOffset_", declaredType="U32:1")
	public UDATA check() throws CorruptDataException {
		return getU32Bitfield(dr_info._check_s_, dr_info._check_b_);
	}

	// U32:1 checkpoint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_checkpointOffset_", declaredType="U32:1")
	public UDATA checkpoint() throws CorruptDataException {
		return getU32Bitfield(dr_info._checkpoint_s_, dr_info._checkpoint_b_);
	}

	// U32:1 chlmb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_chlmbOffset_", declaredType="U32:1")
	public UDATA chlmb() throws CorruptDataException {
		return getU32Bitfield(dr_info._chlmb_s_, dr_info._chlmb_b_);
	}

	// U32:1 cpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpuOffset_", declaredType="U32:1")
	public UDATA cpu() throws CorruptDataException {
		return getU32Bitfield(dr_info._cpu_s_, dr_info._cpu_b_);
	}

	// I32 delta_cap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_delta_capOffset_", declaredType="I32")
	public IDATA delta_cap() throws CorruptDataException {
		return new I32(getIntAtOffset(dr_info._delta_capOffset_));
	}

	// I32 delta_cap
	public IDATAPointer delta_capEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(dr_info._delta_capOffset_));
	}

	// ssize64_t delta_mem_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_delta_mem_capacityOffset_", declaredType="ssize64_t")
	public IDATA delta_mem_capacity() throws CorruptDataException {
		return new I64(getLongAtOffset(dr_info._delta_mem_capacityOffset_));
	}

	// ssize64_t delta_mem_capacity
	public IDATAPointer delta_mem_capacityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(dr_info._delta_mem_capacityOffset_));
	}

	// U32:1 doit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_doitOffset_", declaredType="U32:1")
	public UDATA doit() throws CorruptDataException {
		return getU32Bitfield(dr_info._doit_s_, dr_info._doit_b_);
	}

	// ushort dr_op
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dr_opOffset_", declaredType="ushort")
	public U16 dr_op() throws CorruptDataException {
		return new U16(getShortAtOffset(dr_info._dr_opOffset_));
	}

	// ushort dr_op
	public U16Pointer dr_opEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(dr_info._dr_opOffset_));
	}

	// ushort dr_pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dr_padOffset_", declaredType="ushort")
	public U16 dr_pad() throws CorruptDataException {
		return new U16(getShortAtOffset(dr_info._dr_padOffset_));
	}

	// ushort dr_pad
	public U16Pointer dr_padEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(dr_info._dr_padOffset_));
	}

	// dr_wlm_info_t dr_wlm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dr_wlmOffset_", declaredType="dr_wlm_info_t")
	public dr_wlm_info_tPointer dr_wlm() throws CorruptDataException {
		return dr_wlm_info_tPointer.cast(nonNullFieldEA(dr_info._dr_wlmOffset_));
	}

	// dr_wlm_info_t dr_wlm
	public PointerPointer dr_wlmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(dr_info._dr_wlmOffset_));
	}

	// U32:1 ent_cap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ent_capOffset_", declaredType="U32:1")
	public UDATA ent_cap() throws CorruptDataException {
		return getU32Bitfield(dr_info._ent_cap_s_, dr_info._ent_cap_b_);
	}

	// U32:1 force
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_forceOffset_", declaredType="U32:1")
	public UDATA force() throws CorruptDataException {
		return getU32Bitfield(dr_info._force_s_, dr_info._force_b_);
	}

	// U32:1 hardpset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hardpsetOffset_", declaredType="U32:1")
	public UDATA hardpset() throws CorruptDataException {
		return getU32Bitfield(dr_info._hardpset_s_, dr_info._hardpset_b_);
	}

	// U32:1 hibernate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hibernateOffset_", declaredType="U32:1")
	public UDATA hibernate() throws CorruptDataException {
		return getU32Bitfield(dr_info._hibernate_s_, dr_info._hibernate_b_);
	}

	// I32 lcpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lcpuOffset_", declaredType="I32")
	public IDATA lcpu() throws CorruptDataException {
		return new I32(getIntAtOffset(dr_info._lcpuOffset_));
	}

	// I32 lcpu
	public IDATAPointer lcpuEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(dr_info._lcpuOffset_));
	}

	// ushort lvup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lvupOffset_", declaredType="ushort")
	public U16 lvup() throws CorruptDataException {
		return new U16(getShortAtOffset(dr_info._lvupOffset_));
	}

	// ushort lvup
	public U16Pointer lvupEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(dr_info._lvupOffset_));
	}

	// U32:1 mem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memOffset_", declaredType="U32:1")
	public UDATA mem() throws CorruptDataException {
		return getU32Bitfield(dr_info._mem_s_, dr_info._mem_b_);
	}

	// size64_t mem_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mem_capacityOffset_", declaredType="size64_t")
	public UDATA mem_capacity() throws CorruptDataException {
		return new U64(getLongAtOffset(dr_info._mem_capacityOffset_));
	}

	// size64_t mem_capacity
	public UDATAPointer mem_capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dr_info._mem_capacityOffset_));
	}

	// U32:1 migrate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_migrateOffset_", declaredType="U32:1")
	public UDATA migrate() throws CorruptDataException {
		return getU32Bitfield(dr_info._migrate_s_, dr_info._migrate_b_);
	}

	// U32:1 partition
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_partitionOffset_", declaredType="U32:1")
	public UDATA partition() throws CorruptDataException {
		return getU32Bitfield(dr_info._partition_s_, dr_info._partition_b_);
	}

	// uint phase_gen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phase_genOffset_", declaredType="uint")
	public UDATA phase_gen() throws CorruptDataException {
		return new U32(getIntAtOffset(dr_info._phase_genOffset_));
	}

	// uint phase_gen
	public UDATAPointer phase_genEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dr_info._phase_genOffset_));
	}

	// U32:1 plock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_plockOffset_", declaredType="U32:1")
	public UDATA plock() throws CorruptDataException {
		return getU32Bitfield(dr_info._plock_s_, dr_info._plock_b_);
	}

	// U32:1 post
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_postOffset_", declaredType="U32:1")
	public UDATA post() throws CorruptDataException {
		return getU32Bitfield(dr_info._post_s_, dr_info._post_b_);
	}

	// U32:1 posterror
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_posterrorOffset_", declaredType="U32:1")
	public UDATA posterror() throws CorruptDataException {
		return getU32Bitfield(dr_info._posterror_s_, dr_info._posterror_b_);
	}

	// U32:1 pre
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_preOffset_", declaredType="U32:1")
	public UDATA pre() throws CorruptDataException {
		return getU32Bitfield(dr_info._pre_s_, dr_info._pre_b_);
	}

	// U32:1 pshm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pshmOffset_", declaredType="U32:1")
	public UDATA pshm() throws CorruptDataException {
		return getU32Bitfield(dr_info._pshm_s_, dr_info._pshm_b_);
	}

	// U32:1 rem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_remOffset_", declaredType="U32:1")
	public UDATA rem() throws CorruptDataException {
		return getU32Bitfield(dr_info._rem_s_, dr_info._rem_b_);
	}

	// size64_t req_memsz_change
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_req_memsz_changeOffset_", declaredType="size64_t")
	public UDATA req_memsz_change() throws CorruptDataException {
		return new U64(getLongAtOffset(dr_info._req_memsz_changeOffset_));
	}

	// size64_t req_memsz_change
	public UDATAPointer req_memsz_changeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dr_info._req_memsz_changeOffset_));
	}

	// ushort res_pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_res_padOffset_", declaredType="ushort")
	public U16 res_pad() throws CorruptDataException {
		return new U16(getShortAtOffset(dr_info._res_padOffset_));
	}

	// ushort res_pad
	public U16Pointer res_padEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(dr_info._res_padOffset_));
	}

	// I32[] reserved
	public IDATAPointer reservedEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(dr_info._reservedOffset_));
	}

	// U32:1 restart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_restartOffset_", declaredType="U32:1")
	public UDATA restart() throws CorruptDataException {
		return getU32Bitfield(dr_info._restart_s_, dr_info._restart_b_);
	}

	// U32:1 softpset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_softpsetOffset_", declaredType="U32:1")
	public UDATA softpset() throws CorruptDataException {
		return getU32Bitfield(dr_info._softpset_s_, dr_info._softpset_b_);
	}

	// U32:1 splpar_capable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_splpar_capableOffset_", declaredType="U32:1")
	public UDATA splpar_capable() throws CorruptDataException {
		return getU32Bitfield(dr_info._splpar_capable_s_, dr_info._splpar_capable_b_);
	}

	// U32:1 splpar_capped
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_splpar_cappedOffset_", declaredType="U32:1")
	public UDATA splpar_capped() throws CorruptDataException {
		return getU32Bitfield(dr_info._splpar_capped_s_, dr_info._splpar_capped_b_);
	}

	// U32:1 splpar_shared
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_splpar_sharedOffset_", declaredType="U32:1")
	public UDATA splpar_shared() throws CorruptDataException {
		return getU32Bitfield(dr_info._splpar_shared_s_, dr_info._splpar_shared_b_);
	}

	// rpn64_t sys_free_frames
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sys_free_framesOffset_", declaredType="rpn64_t")
	public IDATA sys_free_frames() throws CorruptDataException {
		return new I64(getLongAtOffset(dr_info._sys_free_framesOffset_));
	}

	// rpn64_t sys_free_frames
	public IDATAPointer sys_free_framesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(dr_info._sys_free_framesOffset_));
	}

	// size64_t sys_memsz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sys_memszOffset_", declaredType="size64_t")
	public UDATA sys_memsz() throws CorruptDataException {
		return new U64(getLongAtOffset(dr_info._sys_memszOffset_));
	}

	// size64_t sys_memsz
	public UDATAPointer sys_memszEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dr_info._sys_memszOffset_));
	}

	// rpn64_t sys_pinnable_frames
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sys_pinnable_framesOffset_", declaredType="rpn64_t")
	public IDATA sys_pinnable_frames() throws CorruptDataException {
		return new I64(getLongAtOffset(dr_info._sys_pinnable_framesOffset_));
	}

	// rpn64_t sys_pinnable_frames
	public IDATAPointer sys_pinnable_framesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(dr_info._sys_pinnable_framesOffset_));
	}

	// rpn64_t sys_total_frames
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sys_total_framesOffset_", declaredType="rpn64_t")
	public IDATA sys_total_frames() throws CorruptDataException {
		return new I64(getLongAtOffset(dr_info._sys_total_framesOffset_));
	}

	// rpn64_t sys_total_frames
	public IDATAPointer sys_total_framesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(dr_info._sys_total_framesOffset_));
	}

	// U32:1 topology_update
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_topology_updateOffset_", declaredType="U32:1")
	public UDATA topology_update() throws CorruptDataException {
		return getU32Bitfield(dr_info._topology_update_s_, dr_info._topology_update_b_);
	}

	// U32:1 var_wgt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_var_wgtOffset_", declaredType="U32:1")
	public UDATA var_wgt() throws CorruptDataException {
		return getU32Bitfield(dr_info._var_wgt_s_, dr_info._var_wgt_b_);
	}

	// U32:1 workload_partition
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_workload_partitionOffset_", declaredType="U32:1")
	public UDATA workload_partition() throws CorruptDataException {
		return getU32Bitfield(dr_info._workload_partition_s_, dr_info._workload_partition_b_);
	}

}
