/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9VMGC_SublistFragment
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9VMGC_SublistFragment {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9MMCONSTANT_EXPLICIT_GC_EXCLUSIVE_VMACCESS_ALREADY_ACQUIRED;
	public static final long J9MMCONSTANT_EXPLICIT_GC_NATIVE_OUT_OF_MEMORY;
	public static final long J9MMCONSTANT_EXPLICIT_GC_NOT_AGGRESSIVE;
	public static final long J9MMCONSTANT_EXPLICIT_GC_RASDUMP_COMPACT;
	public static final long J9MMCONSTANT_EXPLICIT_GC_SYSTEM_GC;
	public static final long J9MMCONSTANT_IMPLICIT_GC_AGGRESSIVE;
	public static final long J9MMCONSTANT_IMPLICIT_GC_DEFAULT;
	public static final long J9MMCONSTANT_IMPLICIT_GC_EXCESSIVE;
	public static final long J9MMCONSTANT_IMPLICIT_GC_PERCOLATE;
	public static final long J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_ABORTED_SCAVENGE;
	public static final long J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_AGGRESSIVE;
	public static final long J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_CRITICAL_REGIONS;
	public static final long J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_UNLOADING_CLASSES;
	public static final long J9SIZEOF_J9VMGC_SublistFragment;

	// Offsets

	public static final int _countOffset_;
	public static final int _deferredFlushIDOffset_;
	public static final int _fragmentCurrentOffset_;
	public static final int _fragmentSizeOffset_;
	public static final int _fragmentTopOffset_;
	public static final int _parentListOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9MMCONSTANT_EXPLICIT_GC_EXCLUSIVE_VMACCESS_ALREADY_ACQUIRED = 0;
		J9MMCONSTANT_EXPLICIT_GC_NATIVE_OUT_OF_MEMORY = 0;
		J9MMCONSTANT_EXPLICIT_GC_NOT_AGGRESSIVE = 0;
		J9MMCONSTANT_EXPLICIT_GC_RASDUMP_COMPACT = 0;
		J9MMCONSTANT_EXPLICIT_GC_SYSTEM_GC = 0;
		J9MMCONSTANT_IMPLICIT_GC_AGGRESSIVE = 0;
		J9MMCONSTANT_IMPLICIT_GC_DEFAULT = 0;
		J9MMCONSTANT_IMPLICIT_GC_EXCESSIVE = 0;
		J9MMCONSTANT_IMPLICIT_GC_PERCOLATE = 0;
		J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_ABORTED_SCAVENGE = 0;
		J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_AGGRESSIVE = 0;
		J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_CRITICAL_REGIONS = 0;
		J9MMCONSTANT_IMPLICIT_GC_PERCOLATE_UNLOADING_CLASSES = 0;
		J9SIZEOF_J9VMGC_SublistFragment = 0;
		_countOffset_ = 0;
		_deferredFlushIDOffset_ = 0;
		_fragmentCurrentOffset_ = 0;
		_fragmentSizeOffset_ = 0;
		_fragmentTopOffset_ = 0;
		_parentListOffset_ = 0;
	}

}
