/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: kernvars
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class kernvars {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _v_acl_configOffset_;
	public static final int _v_autostOffset_;
	public static final int _v_bufhwOffset_;
	public static final int _v_chown_restrictOffset_;
	public static final int _v_clistOffset_;
	public static final int _v_cluster_awareOffset_;
	public static final int _v_coreformatOffset_;
	public static final int _v_cpuguardOffset_;
	public static final int _v_enhanced_rbacOffset_;
	public static final int _v_fileOffset_;
	public static final int _v_file_maxOffset_;
	public static final int _v_fullcoreOffset_;
	public static final int _v_hardstackOffset_;
	public static final int _v_initlvlOffset_;
	public static final int _v_iostrunOffset_;
	public static final int _v_leastprivOffset_;
	public static final int _v_lockOffset_;
	public static final int _v_lock_maxOffset_;
	public static final int _v_max_lognameOffset_;
	public static final int _v_maxpoutOffset_;
	public static final int _v_maxupOffset_;
	public static final int _v_mbufhwOffset_;
	public static final int _v_memscrubOffset_;
	public static final int _v_minpoutOffset_;
	public static final int _v_ncargsOffset_;
	public static final int _v_ncpusOffset_;
	public static final int _v_ncpus_cfgOffset_;
	public static final int _v_ngroups_allowedOffset_;
	public static final int _v_num_xmfrecsOffset_;
	public static final int _v_pmu_accessOffset_;
	public static final int _v_pre520tuneOffset_;
	public static final int _v_procOffset_;
	public static final int _v_sed_configOffset_;
	public static final int _v_threadOffset_;
	public static final int _v_xmdbg_segsOffset_;
	public static final int _v_xmgcOffset_;
	public static final int _var_hdrOffset_;
	public static final int _vb_procOffset_;
	public static final int _vb_threadOffset_;
	public static final int _ve_fileOffset_;
	public static final int _ve_lockOffset_;
	public static final int _ve_procOffset_;
	public static final int _ve_threadOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_v_acl_configOffset_ = 0;
		_v_autostOffset_ = 0;
		_v_bufhwOffset_ = 0;
		_v_chown_restrictOffset_ = 0;
		_v_clistOffset_ = 0;
		_v_cluster_awareOffset_ = 0;
		_v_coreformatOffset_ = 0;
		_v_cpuguardOffset_ = 0;
		_v_enhanced_rbacOffset_ = 0;
		_v_fileOffset_ = 0;
		_v_file_maxOffset_ = 0;
		_v_fullcoreOffset_ = 0;
		_v_hardstackOffset_ = 0;
		_v_initlvlOffset_ = 0;
		_v_iostrunOffset_ = 0;
		_v_leastprivOffset_ = 0;
		_v_lockOffset_ = 0;
		_v_lock_maxOffset_ = 0;
		_v_max_lognameOffset_ = 0;
		_v_maxpoutOffset_ = 0;
		_v_maxupOffset_ = 0;
		_v_mbufhwOffset_ = 0;
		_v_memscrubOffset_ = 0;
		_v_minpoutOffset_ = 0;
		_v_ncargsOffset_ = 0;
		_v_ncpusOffset_ = 0;
		_v_ncpus_cfgOffset_ = 0;
		_v_ngroups_allowedOffset_ = 0;
		_v_num_xmfrecsOffset_ = 0;
		_v_pmu_accessOffset_ = 0;
		_v_pre520tuneOffset_ = 0;
		_v_procOffset_ = 0;
		_v_sed_configOffset_ = 0;
		_v_threadOffset_ = 0;
		_v_xmdbg_segsOffset_ = 0;
		_v_xmgcOffset_ = 0;
		_var_hdrOffset_ = 0;
		_vb_procOffset_ = 0;
		_vb_threadOffset_ = 0;
		_ve_fileOffset_ = 0;
		_ve_lockOffset_ = 0;
		_ve_procOffset_ = 0;
		_ve_threadOffset_ = 0;
	}

}
