/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: lpar_info_format2_t
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class lpar_info_format2_t {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _dispatch_latencyOffset_;
	public static final int _entitled_capacityOffset_;
	public static final int _group_idOffset_;
	public static final int _lpar_flagsOffset_;
	public static final int _min_req_vcpu_capacityOffset_;
	public static final int _online_lcpusOffset_;
	public static final int _online_memoryOffset_;
	public static final int _online_vcpusOffset_;
	public static final int _pad0Offset_;
	public static final int _pad1Offset_;
	public static final int _pcpus_in_poolOffset_;
	public static final int _pcpus_in_sysOffset_;
	public static final int _pool_idOffset_;
	public static final int _pool_idle_timeOffset_;
	public static final int _tot_dispatch_timeOffset_;
	public static final int _unalloc_capacityOffset_;
	public static final int _unalloc_weightOffset_;
	public static final int _variable_weightOffset_;
	public static final int _versionOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_dispatch_latencyOffset_ = 0;
		_entitled_capacityOffset_ = 0;
		_group_idOffset_ = 0;
		_lpar_flagsOffset_ = 0;
		_min_req_vcpu_capacityOffset_ = 0;
		_online_lcpusOffset_ = 0;
		_online_memoryOffset_ = 0;
		_online_vcpusOffset_ = 0;
		_pad0Offset_ = 0;
		_pad1Offset_ = 0;
		_pcpus_in_poolOffset_ = 0;
		_pcpus_in_sysOffset_ = 0;
		_pool_idOffset_ = 0;
		_pool_idle_timeOffset_ = 0;
		_tot_dispatch_timeOffset_ = 0;
		_unalloc_capacityOffset_ = 0;
		_unalloc_weightOffset_ = 0;
		_variable_weightOffset_ = 0;
		_versionOffset_ = 0;
	}

}
