/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;

public class TestClassLoader
extends ClassLoader {
    public static final String CLASS_LOADER_NAME = "JFR TestClassLoader";

    public TestClassLoader() {
        super(CLASS_LOADER_NAME, ClassLoader.getSystemClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        InputStream is = null;
        FilterInputStream dis = null;
        try {
            String resourceName = name.replace('.', '/') + ".class";
            is = this.getResourceAsStream(resourceName);
            if (is != null) {
                int i = is.available();
                byte[] buf = new byte[i];
                dis = new DataInputStream(is);
                ((DataInputStream)dis).readFully(buf);
                dis.close();
                URL url = this.getResource(resourceName);
                CodeSource cs = new CodeSource(url, (Certificate[])null);
                ProtectionDomain pd = new ProtectionDomain(cs, null);
                Class<?> clazz = this.defineClass(name, buf, 0, buf.length, pd);
                return clazz;
            }
        }
        catch (SecurityException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.loadClass(name);
    }
}

