/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: lc_time_tablePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the lc_time_tablePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=lc_time_table.class)
public class lc_time_tablePointer extends StructurePointer {

	// NULL
	public static final lc_time_tablePointer NULL = new lc_time_tablePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected lc_time_tablePointer(long address) {
		super(address);
	}

	public static lc_time_tablePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static lc_time_tablePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static lc_time_tablePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new lc_time_tablePointer(address);
	}

	public lc_time_tablePointer add(long count) {
		return lc_time_tablePointer.cast(address + (lc_time_table.SIZEOF * count));
	}

	public lc_time_tablePointer add(Scalar count) {
		return add(count.longValue());
	}

	public lc_time_tablePointer addOffset(long offset) {
		return lc_time_tablePointer.cast(address + offset);
	}

	public lc_time_tablePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public lc_time_tablePointer sub(long count) {
		return lc_time_tablePointer.cast(address - (lc_time_table.SIZEOF * count));
	}

	public lc_time_tablePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public lc_time_tablePointer subOffset(long offset) {
		return lc_time_tablePointer.cast(address - offset);
	}

	public lc_time_tablePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public lc_time_tablePointer untag(long mask) {
		return lc_time_tablePointer.cast(address & ~mask);
	}

	public lc_time_tablePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return lc_time_table.SIZEOF;
	}

	// Implementation methods

	// U8* abday
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_abdayOffset_", declaredType="U8*")
	public U8Pointer abday() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._abdayOffset_));
	}

	// U8* abday
	public PointerPointer abdayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._abdayOffset_));
	}

	// U8* abmon
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_abmonOffset_", declaredType="U8*")
	public U8Pointer abmon() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._abmonOffset_));
	}

	// U8* abmon
	public PointerPointer abmonEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._abmonOffset_));
	}

	// U8* am_pm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_am_pmOffset_", declaredType="U8*")
	public U8Pointer am_pm() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._am_pmOffset_));
	}

	// U8* am_pm
	public PointerPointer am_pmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._am_pmOffset_));
	}

	// U8* d_fmt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_d_fmtOffset_", declaredType="U8*")
	public U8Pointer d_fmt() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._d_fmtOffset_));
	}

	// U8* d_fmt
	public PointerPointer d_fmtEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._d_fmtOffset_));
	}

	// U8* d_t_fmt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_d_t_fmtOffset_", declaredType="U8*")
	public U8Pointer d_t_fmt() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._d_t_fmtOffset_));
	}

	// U8* d_t_fmt
	public PointerPointer d_t_fmtEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._d_t_fmtOffset_));
	}

	// U8* day
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dayOffset_", declaredType="U8*")
	public U8Pointer day() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._dayOffset_));
	}

	// U8* day
	public PointerPointer dayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._dayOffset_));
	}

	// I16 lc_length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_lengthOffset_", declaredType="I16")
	public I16 lc_length() throws CorruptDataException {
		return new I16(getShortAtOffset(lc_time_table._lc_lengthOffset_));
	}

	// I16 lc_length
	public I16Pointer lc_lengthEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(lc_time_table._lc_lengthOffset_));
	}

	// U8* lc_locale_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_locale_nameOffset_", declaredType="U8*")
	public U8Pointer lc_locale_name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._lc_locale_nameOffset_));
	}

	// U8* lc_locale_name
	public PointerPointer lc_locale_nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._lc_locale_nameOffset_));
	}

	// I16 lc_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_versionOffset_", declaredType="I16")
	public I16 lc_version() throws CorruptDataException {
		return new I16(getShortAtOffset(lc_time_table._lc_versionOffset_));
	}

	// I16 lc_version
	public I16Pointer lc_versionEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(lc_time_table._lc_versionOffset_));
	}

	// U8* misc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_miscOffset_", declaredType="U8*")
	public U8Pointer misc() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._miscOffset_));
	}

	// U8* misc
	public PointerPointer miscEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._miscOffset_));
	}

	// U8* mon
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_monOffset_", declaredType="U8*")
	public U8Pointer mon() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._monOffset_));
	}

	// U8* mon
	public PointerPointer monEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._monOffset_));
	}

	// U8* nlldate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nlldateOffset_", declaredType="U8*")
	public U8Pointer nlldate() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._nlldateOffset_));
	}

	// U8* nlldate
	public PointerPointer nlldateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._nlldateOffset_));
	}

	// U8* t_fmt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_fmtOffset_", declaredType="U8*")
	public U8Pointer t_fmt() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._t_fmtOffset_));
	}

	// U8* t_fmt
	public PointerPointer t_fmtEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._t_fmtOffset_));
	}

	// U8* tstrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tstrsOffset_", declaredType="U8*")
	public U8Pointer tstrs() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._tstrsOffset_));
	}

	// U8* tstrs
	public PointerPointer tstrsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._tstrsOffset_));
	}

	// U8* tunits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tunitsOffset_", declaredType="U8*")
	public U8Pointer tunits() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._tunitsOffset_));
	}

	// U8* tunits
	public PointerPointer tunitsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._tunitsOffset_));
	}

	// U8* year
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_yearOffset_", declaredType="U8*")
	public U8Pointer year() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lc_time_table._yearOffset_));
	}

	// U8* year
	public PointerPointer yearEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lc_time_table._yearOffset_));
	}

}
