/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: uidinfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the uidinfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=uidinfo.class)
public class uidinfoPointer extends StructurePointer {

	// NULL
	public static final uidinfoPointer NULL = new uidinfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected uidinfoPointer(long address) {
		super(address);
	}

	public static uidinfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static uidinfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static uidinfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new uidinfoPointer(address);
	}

	public uidinfoPointer add(long count) {
		return uidinfoPointer.cast(address + (uidinfo.SIZEOF * count));
	}

	public uidinfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public uidinfoPointer addOffset(long offset) {
		return uidinfoPointer.cast(address + offset);
	}

	public uidinfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public uidinfoPointer sub(long count) {
		return uidinfoPointer.cast(address - (uidinfo.SIZEOF * count));
	}

	public uidinfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public uidinfoPointer subOffset(long offset) {
		return uidinfoPointer.cast(address - offset);
	}

	public uidinfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public uidinfoPointer untag(long mask) {
		return uidinfoPointer.cast(address & ~mask);
	}

	public uidinfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return uidinfo.SIZEOF;
	}

	// Implementation methods

	// I64 pu_cnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pu_cntOffset_", declaredType="I64")
	public IDATA pu_cnt() throws CorruptDataException {
		return new I64(getLongAtOffset(uidinfo._pu_cntOffset_));
	}

	// I64 pu_cnt
	public IDATAPointer pu_cntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(uidinfo._pu_cntOffset_));
	}

	// cid_t pu_kcid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pu_kcidOffset_", declaredType="cid_t")
	public U16 pu_kcid() throws CorruptDataException {
		return new U16(getShortAtOffset(uidinfo._pu_kcidOffset_));
	}

	// cid_t pu_kcid
	public U16Pointer pu_kcidEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(uidinfo._pu_kcidOffset_));
	}

	// uidinfo* pu_next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pu_nextOffset_", declaredType="uidinfo*")
	public uidinfoPointer pu_next() throws CorruptDataException {
		return uidinfoPointer.cast(getPointerAtOffset(uidinfo._pu_nextOffset_));
	}

	// uidinfo* pu_next
	public PointerPointer pu_nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(uidinfo._pu_nextOffset_));
	}

	// I16[] pu_pad
	public I16Pointer pu_padEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(uidinfo._pu_padOffset_));
	}

	// uidinfo* pu_prev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pu_prevOffset_", declaredType="uidinfo*")
	public uidinfoPointer pu_prev() throws CorruptDataException {
		return uidinfoPointer.cast(getPointerAtOffset(uidinfo._pu_prevOffset_));
	}

	// uidinfo* pu_prev
	public PointerPointer pu_prevEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(uidinfo._pu_prevOffset_));
	}

	// uid_t pu_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pu_uidOffset_", declaredType="uid_t")
	public UDATA pu_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(uidinfo._pu_uidOffset_));
	}

	// uid_t pu_uid
	public UDATAPointer pu_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(uidinfo._pu_uidOffset_));
	}

}
