/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.format;

import java.util.Objects;
import java.util.Optional;
import jdk.test.lib.format.ArrayCodec;
import jdk.test.lib.format.Diff;
import jdk.test.lib.format.Format;

public class ArrayDiff<E>
implements Diff {
    private int failureIdx;
    private final int maxWidth;
    private final int contextBefore;
    private final ArrayCodec<E> first;
    private final ArrayCodec<E> second;

    private ArrayDiff(ArrayCodec<E> first, ArrayCodec<E> second, int width, int getContextBefore) {
        this.first = first;
        this.second = second;
        this.maxWidth = width;
        this.contextBefore = getContextBefore;
        this.failureIdx = first.findMismatchIndex(second);
    }

    public static ArrayDiff<?> of(Object first, Object second) {
        return ArrayDiff.of(first, second, 80, 2);
    }

    public static ArrayDiff<?> of(Object first, Object second, int width, int contextBefore) {
        boolean componentTypesAreSame;
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        boolean bothAreArrays = first.getClass().isArray() && second.getClass().isArray();
        boolean bl = componentTypesAreSame = first.getClass().getComponentType() == second.getClass().getComponentType();
        if (!bothAreArrays || !componentTypesAreSame) {
            throw new IllegalArgumentException("Both arguments should be arrays of the same type");
        }
        return new ArrayDiff(ArrayCodec.of(first), ArrayCodec.of(second), width, contextBefore);
    }

    @Override
    public String format() {
        if (this.areEqual()) {
            return "";
        }
        return this.format(false).orElseGet(() -> this.format(true).get());
    }

    @Override
    public boolean areEqual() {
        return this.first.equals(this.second);
    }

    private void extractAndAlignElements() {
        this.first.formatNext();
        this.second.formatNext();
        this.first.alignBy(this.second);
        this.second.alignBy(this.first);
    }

    private static String failureMarkForWidth(int width) {
        return new String("^").repeat(width);
    }

    private Optional<String> format(boolean bounded) {
        int idx = bounded ? Math.max(0, this.failureIdx - this.contextBefore) : 0;
        this.first.startFormatting(idx, bounded ? this.maxWidth : -1);
        this.second.startFormatting(idx, bounded ? this.maxWidth : -1);
        StringBuilder failureMark = new StringBuilder(Format.paddingForWidth(this.first.getEncodedLength()));
        while (!this.first.isExhausted() || !this.second.isExhausted()) {
            this.extractAndAlignElements();
            this.first.appendFormatted();
            this.second.appendFormatted();
            if (idx < this.failureIdx) {
                failureMark.append(Format.paddingForWidth(this.first.getElementLength()));
            } else if (idx == this.failureIdx) {
                int markLength = Math.max(this.first.getElementLength(), this.second.getElementLength()) - 1;
                failureMark.append(ArrayDiff.failureMarkForWidth(markLength));
            }
            int maxEncodedLength = Math.max(this.first.getEncodedLength(), this.second.getEncodedLength());
            if (!bounded && maxEncodedLength > this.maxWidth) {
                return Optional.empty();
            }
            ++idx;
        }
        return Optional.of(String.format("Arrays differ starting from [index: %d]:%n%s%n%s%n%s", this.failureIdx, this.first.getEncoded(), this.second.getEncoded(), failureMark.toString()));
    }
}

