/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: cputime_clockPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the cputime_clockPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=cputime_clock.class)
public class cputime_clockPointer extends StructurePointer {

	// NULL
	public static final cputime_clockPointer NULL = new cputime_clockPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected cputime_clockPointer(long address) {
		super(address);
	}

	public static cputime_clockPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static cputime_clockPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static cputime_clockPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new cputime_clockPointer(address);
	}

	public cputime_clockPointer add(long count) {
		return cputime_clockPointer.cast(address + (cputime_clock.SIZEOF * count));
	}

	public cputime_clockPointer add(Scalar count) {
		return add(count.longValue());
	}

	public cputime_clockPointer addOffset(long offset) {
		return cputime_clockPointer.cast(address + offset);
	}

	public cputime_clockPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public cputime_clockPointer sub(long count) {
		return cputime_clockPointer.cast(address - (cputime_clock.SIZEOF * count));
	}

	public cputime_clockPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public cputime_clockPointer subOffset(long offset) {
		return cputime_clockPointer.cast(address - offset);
	}

	public cputime_clockPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public cputime_clockPointer untag(long mask) {
		return cputime_clockPointer.cast(address & ~mask);
	}

	public cputime_clockPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return cputime_clock.SIZEOF;
	}

	// Implementation methods

	// posix_tmr* active_tmrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_active_tmrsOffset_", declaredType="posix_tmr*")
	public posix_tmrPointer active_tmrs() throws CorruptDataException {
		return posix_tmrPointer.cast(getPointerAtOffset(cputime_clock._active_tmrsOffset_));
	}

	// posix_tmr* active_tmrs
	public PointerPointer active_tmrsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(cputime_clock._active_tmrsOffset_));
	}

	// uint_t rt_ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rt_ticksOffset_", declaredType="uint_t")
	public UDATA rt_ticks() throws CorruptDataException {
		return new U32(getIntAtOffset(cputime_clock._rt_ticksOffset_));
	}

	// uint_t rt_ticks
	public UDATAPointer rt_ticksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(cputime_clock._rt_ticksOffset_));
	}

}
