/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: pag_list64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the pag_list64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=pag_list64.class)
public class pag_list64Pointer extends StructurePointer {

	// NULL
	public static final pag_list64Pointer NULL = new pag_list64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected pag_list64Pointer(long address) {
		super(address);
	}

	public static pag_list64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static pag_list64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static pag_list64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new pag_list64Pointer(address);
	}

	public pag_list64Pointer add(long count) {
		return pag_list64Pointer.cast(address + (pag_list64.SIZEOF * count));
	}

	public pag_list64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public pag_list64Pointer addOffset(long offset) {
		return pag_list64Pointer.cast(address + offset);
	}

	public pag_list64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public pag_list64Pointer sub(long count) {
		return pag_list64Pointer.cast(address - (pag_list64.SIZEOF * count));
	}

	public pag_list64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public pag_list64Pointer subOffset(long offset) {
		return pag_list64Pointer.cast(address - offset);
	}

	public pag_list64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public pag_list64Pointer untag(long mask) {
		return pag_list64Pointer.cast(address & ~mask);
	}

	public pag_list64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return pag_list64.SIZEOF;
	}

	// Implementation methods

	// I32 active
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_activeOffset_", declaredType="I32")
	public IDATA active() throws CorruptDataException {
		return new I32(getIntAtOffset(pag_list64._activeOffset_));
	}

	// I32 active
	public IDATAPointer activeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pag_list64._activeOffset_));
	}

	// U64 pag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pagOffset_", declaredType="U64")
	public UDATA pag() throws CorruptDataException {
		return new U64(getLongAtOffset(pag_list64._pagOffset_));
	}

	// U64 pag
	public UDATAPointer pagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pag_list64._pagOffset_));
	}

	// I32[] spare
	public IDATAPointer spareEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(pag_list64._spareOffset_));
	}

}
