/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: lconv
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class lconv {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _currency_symbolOffset_;
	public static final int _decimal_pointOffset_;
	public static final int _frac_digitsOffset_;
	public static final int _groupingOffset_;
	public static final int _int_curr_symbolOffset_;
	public static final int _int_frac_digitsOffset_;
	public static final int _int_n_cs_precedesOffset_;
	public static final int _int_n_sep_by_spaceOffset_;
	public static final int _int_n_sign_posnOffset_;
	public static final int _int_p_cs_precedesOffset_;
	public static final int _int_p_sep_by_spaceOffset_;
	public static final int _int_p_sign_posnOffset_;
	public static final int _left_parenthesisOffset_;
	public static final int _mon_decimal_pointOffset_;
	public static final int _mon_groupingOffset_;
	public static final int _mon_thousands_sepOffset_;
	public static final int _n_cs_precedesOffset_;
	public static final int _n_sep_by_spaceOffset_;
	public static final int _n_sign_posnOffset_;
	public static final int _negative_signOffset_;
	public static final int _p_cs_precedesOffset_;
	public static final int _p_sep_by_spaceOffset_;
	public static final int _p_sign_posnOffset_;
	public static final int _positive_signOffset_;
	public static final int _right_parenthesisOffset_;
	public static final int _thousands_sepOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_currency_symbolOffset_ = 0;
		_decimal_pointOffset_ = 0;
		_frac_digitsOffset_ = 0;
		_groupingOffset_ = 0;
		_int_curr_symbolOffset_ = 0;
		_int_frac_digitsOffset_ = 0;
		_int_n_cs_precedesOffset_ = 0;
		_int_n_sep_by_spaceOffset_ = 0;
		_int_n_sign_posnOffset_ = 0;
		_int_p_cs_precedesOffset_ = 0;
		_int_p_sep_by_spaceOffset_ = 0;
		_int_p_sign_posnOffset_ = 0;
		_left_parenthesisOffset_ = 0;
		_mon_decimal_pointOffset_ = 0;
		_mon_groupingOffset_ = 0;
		_mon_thousands_sepOffset_ = 0;
		_n_cs_precedesOffset_ = 0;
		_n_sep_by_spaceOffset_ = 0;
		_n_sign_posnOffset_ = 0;
		_negative_signOffset_ = 0;
		_p_cs_precedesOffset_ = 0;
		_p_sep_by_spaceOffset_ = 0;
		_p_sign_posnOffset_ = 0;
		_positive_signOffset_ = 0;
		_right_parenthesisOffset_ = 0;
		_thousands_sepOffset_ = 0;
	}

}
