/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9SharedClassMetadataWalkStatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9SharedClassMetadataWalkStatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9SharedClassMetadataWalkState.class)
public class J9SharedClassMetadataWalkStatePointer extends StructurePointer {

	// NULL
	public static final J9SharedClassMetadataWalkStatePointer NULL = new J9SharedClassMetadataWalkStatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9SharedClassMetadataWalkStatePointer(long address) {
		super(address);
	}

	public static J9SharedClassMetadataWalkStatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9SharedClassMetadataWalkStatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9SharedClassMetadataWalkStatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9SharedClassMetadataWalkStatePointer(address);
	}

	public J9SharedClassMetadataWalkStatePointer add(long count) {
		return J9SharedClassMetadataWalkStatePointer.cast(address + (J9SharedClassMetadataWalkState.SIZEOF * count));
	}

	public J9SharedClassMetadataWalkStatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9SharedClassMetadataWalkStatePointer addOffset(long offset) {
		return J9SharedClassMetadataWalkStatePointer.cast(address + offset);
	}

	public J9SharedClassMetadataWalkStatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9SharedClassMetadataWalkStatePointer sub(long count) {
		return J9SharedClassMetadataWalkStatePointer.cast(address - (J9SharedClassMetadataWalkState.SIZEOF * count));
	}

	public J9SharedClassMetadataWalkStatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9SharedClassMetadataWalkStatePointer subOffset(long offset) {
		return J9SharedClassMetadataWalkStatePointer.cast(address - offset);
	}

	public J9SharedClassMetadataWalkStatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9SharedClassMetadataWalkStatePointer untag(long mask) {
		return J9SharedClassMetadataWalkStatePointer.cast(address & ~mask);
	}

	public J9SharedClassMetadataWalkStatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9SharedClassMetadataWalkState.SIZEOF;
	}

	// Implementation methods

	// ShcItemHdr* entry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entryOffset_", declaredType="ShcItemHdr*")
	public ShcItemHdrPointer entry() throws CorruptDataException {
		return ShcItemHdrPointer.cast(getPointerAtOffset(J9SharedClassMetadataWalkState._entryOffset_));
	}

	// ShcItemHdr* entry
	public PointerPointer entryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassMetadataWalkState._entryOffset_));
	}

	// UDATA includeStale
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_includeStaleOffset_", declaredType="UDATA")
	public UDATA includeStale() throws CorruptDataException {
		return getUDATAAtOffset(J9SharedClassMetadataWalkState._includeStaleOffset_);
	}

	// UDATA includeStale
	public UDATAPointer includeStaleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassMetadataWalkState._includeStaleOffset_));
	}

	// UDATA length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lengthOffset_", declaredType="UDATA")
	public UDATA length() throws CorruptDataException {
		return getUDATAAtOffset(J9SharedClassMetadataWalkState._lengthOffset_);
	}

	// UDATA length
	public UDATAPointer lengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9SharedClassMetadataWalkState._lengthOffset_));
	}

	// U16 limitDataType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_limitDataTypeOffset_", declaredType="U16")
	public U16 limitDataType() throws CorruptDataException {
		return new U16(getShortAtOffset(J9SharedClassMetadataWalkState._limitDataTypeOffset_));
	}

	// U16 limitDataType
	public U16Pointer limitDataTypeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(J9SharedClassMetadataWalkState._limitDataTypeOffset_));
	}

	// void* metaStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_metaStartOffset_", declaredType="void*")
	public VoidPointer metaStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassMetadataWalkState._metaStartOffset_));
	}

	// void* metaStart
	public PointerPointer metaStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassMetadataWalkState._metaStartOffset_));
	}

	// ShcItemHdr* savedEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_savedEntryOffset_", declaredType="ShcItemHdr*")
	public ShcItemHdrPointer savedEntry() throws CorruptDataException {
		return ShcItemHdrPointer.cast(getPointerAtOffset(J9SharedClassMetadataWalkState._savedEntryOffset_));
	}

	// ShcItemHdr* savedEntry
	public PointerPointer savedEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassMetadataWalkState._savedEntryOffset_));
	}

	// void* savedMetaStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_savedMetaStartOffset_", declaredType="void*")
	public VoidPointer savedMetaStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9SharedClassMetadataWalkState._savedMetaStartOffset_));
	}

	// void* savedMetaStart
	public PointerPointer savedMetaStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9SharedClassMetadataWalkState._savedMetaStartOffset_));
	}

}
