/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: file_secattrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the file_secattrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=file_secattr.class)
public class file_secattrPointer extends StructurePointer {

	// NULL
	public static final file_secattrPointer NULL = new file_secattrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected file_secattrPointer(long address) {
		super(address);
	}

	public static file_secattrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static file_secattrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static file_secattrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new file_secattrPointer(address);
	}

	public file_secattrPointer add(long count) {
		return file_secattrPointer.cast(address + (file_secattr.SIZEOF * count));
	}

	public file_secattrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public file_secattrPointer addOffset(long offset) {
		return file_secattrPointer.cast(address + offset);
	}

	public file_secattrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public file_secattrPointer sub(long count) {
		return file_secattrPointer.cast(address - (file_secattr.SIZEOF * count));
	}

	public file_secattrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public file_secattrPointer subOffset(long offset) {
		return file_secattrPointer.cast(address - offset);
	}

	public file_secattrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public file_secattrPointer untag(long mask) {
		return file_secattrPointer.cast(address & ~mask);
	}

	public file_secattrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return file_secattr.SIZEOF;
	}

	// Implementation methods

	// sec_labels_t labels
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_labelsOffset_", declaredType="sec_labels_t")
	public sec_labelsPointer labels() throws CorruptDataException {
		return sec_labelsPointer.cast(nonNullFieldEA(file_secattr._labelsOffset_));
	}

	// sec_labels_t labels
	public PointerPointer labelsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(file_secattr._labelsOffset_));
	}

	// I32 refcount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_refcountOffset_", declaredType="I32")
	public IDATA refcount() throws CorruptDataException {
		return new I32(getIntAtOffset(file_secattr._refcountOffset_));
	}

	// I32 refcount
	public IDATAPointer refcountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(file_secattr._refcountOffset_));
	}

}
