/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: posix_tmrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the posix_tmrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=posix_tmr.class)
public class posix_tmrPointer extends StructurePointer {

	// NULL
	public static final posix_tmrPointer NULL = new posix_tmrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected posix_tmrPointer(long address) {
		super(address);
	}

	public static posix_tmrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static posix_tmrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static posix_tmrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new posix_tmrPointer(address);
	}

	public posix_tmrPointer add(long count) {
		return posix_tmrPointer.cast(address + (posix_tmr.SIZEOF * count));
	}

	public posix_tmrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public posix_tmrPointer addOffset(long offset) {
		return posix_tmrPointer.cast(address + offset);
	}

	public posix_tmrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public posix_tmrPointer sub(long count) {
		return posix_tmrPointer.cast(address - (posix_tmr.SIZEOF * count));
	}

	public posix_tmrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public posix_tmrPointer subOffset(long offset) {
		return posix_tmrPointer.cast(address - offset);
	}

	public posix_tmrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public posix_tmrPointer untag(long mask) {
		return posix_tmrPointer.cast(address & ~mask);
	}

	public posix_tmrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return posix_tmr.SIZEOF;
	}

	// Implementation methods

	// I16 tmr_active_overrun
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_active_overrunOffset_", declaredType="I16")
	public I16 tmr_active_overrun() throws CorruptDataException {
		return new I16(getShortAtOffset(posix_tmr._tmr_active_overrunOffset_));
	}

	// I16 tmr_active_overrun
	public I16Pointer tmr_active_overrunEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(posix_tmr._tmr_active_overrunOffset_));
	}

	// clockid_t tmr_clockid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_clockidOffset_", declaredType="clockid_t")
	public IDATA tmr_clockid() throws CorruptDataException {
		return new I64(getLongAtOffset(posix_tmr._tmr_clockidOffset_));
	}

	// clockid_t tmr_clockid
	public IDATAPointer tmr_clockidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(posix_tmr._tmr_clockidOffset_));
	}

	// void* tmr_notifunion.sip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_notifunion$sipOffset_", declaredType="void*")
	public VoidPointer tmr_notifunion$sip() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(posix_tmr._tmr_notifunion$sipOffset_));
	}

	// void* tmr_notifunion.sip
	public PointerPointer tmr_notifunion$sipEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(posix_tmr._tmr_notifunion$sipOffset_));
	}

	// tid_t tmr_notifunion.tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_notifunion$tidOffset_", declaredType="tid_t")
	public IDATA tmr_notifunion$tid() throws CorruptDataException {
		return new I64(getLongAtOffset(posix_tmr._tmr_notifunion$tidOffset_));
	}

	// tid_t tmr_notifunion.tid
	public IDATAPointer tmr_notifunion$tidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(posix_tmr._tmr_notifunion$tidOffset_));
	}

	// I32 tmr_notify
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_notifyOffset_", declaredType="I32")
	public IDATA tmr_notify() throws CorruptDataException {
		return new I32(getIntAtOffset(posix_tmr._tmr_notifyOffset_));
	}

	// I32 tmr_notify
	public IDATAPointer tmr_notifyEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(posix_tmr._tmr_notifyOffset_));
	}

	// I16 tmr_prev_overrun
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_prev_overrunOffset_", declaredType="I16")
	public I16 tmr_prev_overrun() throws CorruptDataException {
		return new I16(getShortAtOffset(posix_tmr._tmr_prev_overrunOffset_));
	}

	// I16 tmr_prev_overrun
	public I16Pointer tmr_prev_overrunEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(posix_tmr._tmr_prev_overrunOffset_));
	}

	// cputime_tmr tmr_union.cpu_tmr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_union$cpu_tmrOffset_", declaredType="cputime_tmr")
	public cputime_tmrPointer tmr_union$cpu_tmr() throws CorruptDataException {
		return cputime_tmrPointer.cast(nonNullFieldEA(posix_tmr._tmr_union$cpu_tmrOffset_));
	}

	// cputime_tmr tmr_union.cpu_tmr
	public PointerPointer tmr_union$cpu_tmrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(posix_tmr._tmr_union$cpu_tmrOffset_));
	}

	// trb* tmr_union.trb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmr_union$trbOffset_", declaredType="trb*")
	public trbPointer tmr_union$trb() throws CorruptDataException {
		return trbPointer.cast(getPointerAtOffset(posix_tmr._tmr_union$trbOffset_));
	}

	// trb* tmr_union.trb
	public PointerPointer tmr_union$trbEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(posix_tmr._tmr_union$trbOffset_));
	}

}
