/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9VMContinuation
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9VMContinuation {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _arg0EAOffset_;
	public static final int _bytecodesOffset_;
	public static final int _decompilationStackOffset_;
	public static final int _dropFlagsOffset_;
	public static final int _enteredMonitorsOffset_;
	public static final int _i2jStateOffset_;
	public static final int _j2iFrameOffset_;
	public static final int _jitGPRsOffset_;
	public static final int _jniMonitorEnterRecordsOffset_;
	public static final int _literalsOffset_;
	public static final int _monitorEnterRecordPoolOffset_;
	public static final int _monitorEnterRecordsOffset_;
	public static final int _nextWaitingContinuationOffset_;
	public static final int _objectWaitMonitorOffset_;
	public static final int _oldEntryLocalStorageOffset_;
	public static final int _ownedMonitorCountOffset_;
	public static final int _pcOffset_;
	public static final int _previousOwnerOffset_;
	public static final int _returnStateOffset_;
	public static final int _runtimeFlagsOffset_;
	public static final int _spOffset_;
	public static final int _stackObjectOffset_;
	public static final int _stackOverflowMarkOffset_;
	public static final int _stackOverflowMark2Offset_;
	public static final int _startTicksOffset_;
	public static final int _vthreadOffset_;
	public static final int _waitingMonitorEnterCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_arg0EAOffset_ = 0;
		_bytecodesOffset_ = 0;
		_decompilationStackOffset_ = 0;
		_dropFlagsOffset_ = 0;
		_enteredMonitorsOffset_ = 0;
		_i2jStateOffset_ = 0;
		_j2iFrameOffset_ = 0;
		_jitGPRsOffset_ = 0;
		_jniMonitorEnterRecordsOffset_ = 0;
		_literalsOffset_ = 0;
		_monitorEnterRecordPoolOffset_ = 0;
		_monitorEnterRecordsOffset_ = 0;
		_nextWaitingContinuationOffset_ = 0;
		_objectWaitMonitorOffset_ = 0;
		_oldEntryLocalStorageOffset_ = 0;
		_ownedMonitorCountOffset_ = 0;
		_pcOffset_ = 0;
		_previousOwnerOffset_ = 0;
		_returnStateOffset_ = 0;
		_runtimeFlagsOffset_ = 0;
		_spOffset_ = 0;
		_stackObjectOffset_ = 0;
		_stackOverflowMarkOffset_ = 0;
		_stackOverflowMark2Offset_ = 0;
		_startTicksOffset_ = 0;
		_vthreadOffset_ = 0;
		_waitingMonitorEnterCountOffset_ = 0;
	}

}
