/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: perfstat_memory_total_t
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class perfstat_memory_total_t {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _bytes_coalescedOffset_;
	public static final int _bytes_coalesced_mempoolOffset_;
	public static final int _comprsd_totalOffset_;
	public static final int _comprsd_wseg_pgsOffset_;
	public static final int _comprsd_wseg_sizeOffset_;
	public static final int _cpginsOffset_;
	public static final int _cpgoutsOffset_;
	public static final int _cpool_inuseOffset_;
	public static final int _cpool_sizeOffset_;
	public static final int _cyclesOffset_;
	public static final int _expanded_memoryOffset_;
	public static final int _iohwmOffset_;
	public static final int _iomeOffset_;
	public static final int _iomuOffset_;
	public static final int _max_cpool_sizeOffset_;
	public static final int _min_ucpool_sizeOffset_;
	public static final int _numpermOffset_;
	public static final int _pgbadOffset_;
	public static final int _pgexctOffset_;
	public static final int _pginsOffset_;
	public static final int _pgoutsOffset_;
	public static final int _pgsp_freeOffset_;
	public static final int _pgsp_rsvdOffset_;
	public static final int _pgsp_totalOffset_;
	public static final int _pgspinsOffset_;
	public static final int _pgspoutsOffset_;
	public static final int _pgstealsOffset_;
	public static final int _pmemOffset_;
	public static final int _real_availOffset_;
	public static final int _real_freeOffset_;
	public static final int _real_inuseOffset_;
	public static final int _real_pinnedOffset_;
	public static final int _real_processOffset_;
	public static final int _real_systemOffset_;
	public static final int _real_totalOffset_;
	public static final int _real_userOffset_;
	public static final int _scansOffset_;
	public static final int _target_cpool_sizeOffset_;
	public static final int _true_sizeOffset_;
	public static final int _ucpool_inuseOffset_;
	public static final int _ucpool_sizeOffset_;
	public static final int _versionOffset_;
	public static final int _virt_activeOffset_;
	public static final int _virt_totalOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_bytes_coalescedOffset_ = 0;
		_bytes_coalesced_mempoolOffset_ = 0;
		_comprsd_totalOffset_ = 0;
		_comprsd_wseg_pgsOffset_ = 0;
		_comprsd_wseg_sizeOffset_ = 0;
		_cpginsOffset_ = 0;
		_cpgoutsOffset_ = 0;
		_cpool_inuseOffset_ = 0;
		_cpool_sizeOffset_ = 0;
		_cyclesOffset_ = 0;
		_expanded_memoryOffset_ = 0;
		_iohwmOffset_ = 0;
		_iomeOffset_ = 0;
		_iomuOffset_ = 0;
		_max_cpool_sizeOffset_ = 0;
		_min_ucpool_sizeOffset_ = 0;
		_numpermOffset_ = 0;
		_pgbadOffset_ = 0;
		_pgexctOffset_ = 0;
		_pginsOffset_ = 0;
		_pgoutsOffset_ = 0;
		_pgsp_freeOffset_ = 0;
		_pgsp_rsvdOffset_ = 0;
		_pgsp_totalOffset_ = 0;
		_pgspinsOffset_ = 0;
		_pgspoutsOffset_ = 0;
		_pgstealsOffset_ = 0;
		_pmemOffset_ = 0;
		_real_availOffset_ = 0;
		_real_freeOffset_ = 0;
		_real_inuseOffset_ = 0;
		_real_pinnedOffset_ = 0;
		_real_processOffset_ = 0;
		_real_systemOffset_ = 0;
		_real_totalOffset_ = 0;
		_real_userOffset_ = 0;
		_scansOffset_ = 0;
		_target_cpool_sizeOffset_ = 0;
		_true_sizeOffset_ = 0;
		_ucpool_inuseOffset_ = 0;
		_ucpool_sizeOffset_ = 0;
		_versionOffset_ = 0;
		_virt_activeOffset_ = 0;
		_virt_totalOffset_ = 0;
	}

}
