/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GpuMetaDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GpuMetaDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GpuMetaData.class)
public class GpuMetaDataPointer extends StructurePointer {

	// NULL
	public static final GpuMetaDataPointer NULL = new GpuMetaDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GpuMetaDataPointer(long address) {
		super(address);
	}

	public static GpuMetaDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GpuMetaDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GpuMetaDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new GpuMetaDataPointer(address);
	}

	public GpuMetaDataPointer add(long count) {
		return GpuMetaDataPointer.cast(address + (GpuMetaData.SIZEOF * count));
	}

	public GpuMetaDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GpuMetaDataPointer addOffset(long offset) {
		return GpuMetaDataPointer.cast(address + offset);
	}

	public GpuMetaDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GpuMetaDataPointer sub(long count) {
		return GpuMetaDataPointer.cast(address - (GpuMetaData.SIZEOF * count));
	}

	public GpuMetaDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GpuMetaDataPointer subOffset(long offset) {
		return GpuMetaDataPointer.cast(address - offset);
	}

	public GpuMetaDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GpuMetaDataPointer untag(long mask) {
		return GpuMetaDataPointer.cast(address & ~mask);
	}

	public GpuMetaDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GpuMetaData.SIZEOF;
	}

	// Implementation methods

	// void* cuModuleArray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cuModuleArrayOffset_", declaredType="void*")
	public VoidPointer cuModuleArray() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(GpuMetaData._cuModuleArrayOffset_));
	}

	// void* cuModuleArray
	public PointerPointer cuModuleArrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GpuMetaData._cuModuleArrayOffset_));
	}

	// I32* lineNumberArray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lineNumberArrayOffset_", declaredType="I32*")
	public IDATAPointer lineNumberArray() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(GpuMetaData._lineNumberArrayOffset_));
	}

	// I32* lineNumberArray
	public PointerPointer lineNumberArrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GpuMetaData._lineNumberArrayOffset_));
	}

	// I32 maxNumCachedDevices
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxNumCachedDevicesOffset_", declaredType="I32")
	public IDATA maxNumCachedDevices() throws CorruptDataException {
		return new I32(getIntAtOffset(GpuMetaData._maxNumCachedDevicesOffset_));
	}

	// I32 maxNumCachedDevices
	public IDATAPointer maxNumCachedDevicesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(GpuMetaData._maxNumCachedDevicesOffset_));
	}

	// U8* methodSignature
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methodSignatureOffset_", declaredType="U8*")
	public U8Pointer methodSignature() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(GpuMetaData._methodSignatureOffset_));
	}

	// U8* methodSignature
	public PointerPointer methodSignatureEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GpuMetaData._methodSignatureOffset_));
	}

	// I32 numPtxKernels
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numPtxKernelsOffset_", declaredType="I32")
	public IDATA numPtxKernels() throws CorruptDataException {
		return new I32(getIntAtOffset(GpuMetaData._numPtxKernelsOffset_));
	}

	// I32 numPtxKernels
	public IDATAPointer numPtxKernelsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(GpuMetaData._numPtxKernelsOffset_));
	}

	// void** ptxArray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ptxArrayOffset_", declaredType="void**")
	public PointerPointer ptxArray() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(GpuMetaData._ptxArrayOffset_));
	}

	// void** ptxArray
	public PointerPointer ptxArrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GpuMetaData._ptxArrayOffset_));
	}

}
