/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: asoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the asoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=aso.class)
public class asoPointer extends StructurePointer {

	// NULL
	public static final asoPointer NULL = new asoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected asoPointer(long address) {
		super(address);
	}

	public static asoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static asoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static asoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new asoPointer(address);
	}

	public asoPointer add(long count) {
		return asoPointer.cast(address + (aso.SIZEOF * count));
	}

	public asoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public asoPointer addOffset(long offset) {
		return asoPointer.cast(address + offset);
	}

	public asoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public asoPointer sub(long count) {
		return asoPointer.cast(address - (aso.SIZEOF * count));
	}

	public asoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public asoPointer subOffset(long offset) {
		return asoPointer.cast(address - offset);
	}

	public asoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public asoPointer untag(long mask) {
		return asoPointer.cast(address & ~mask);
	}

	public asoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return aso.SIZEOF;
	}

	// Implementation methods

	// mrq_mask_t advrset_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_advrset_maskOffset_", declaredType="mrq_mask_t")
	public mrq_mask_tPointer advrset_mask() throws CorruptDataException {
		return mrq_mask_tPointer.cast(nonNullFieldEA(aso._advrset_maskOffset_));
	}

	// mrq_mask_t advrset_mask
	public PointerPointer advrset_maskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(aso._advrset_maskOffset_));
	}

	// U16 aso_shmat.field_16b
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_aso_shmat$field_16bOffset_", declaredType="U16")
	public U16 aso_shmat$field_16b() throws CorruptDataException {
		return new U16(getShortAtOffset(aso._aso_shmat$field_16bOffset_));
	}

	// U16 aso_shmat.field_16b
	public U16Pointer aso_shmat$field_16bEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(aso._aso_shmat$field_16bOffset_));
	}

	// U8[] aso_shmat.field_8b
	public U8Pointer aso_shmat$field_8bEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(aso._aso_shmat$field_8bOffset_));
	}

	// U64 dispatch_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dispatch_countOffset_", declaredType="U64")
	public UDATA dispatch_count() throws CorruptDataException {
		return new U64(getLongAtOffset(aso._dispatch_countOffset_));
	}

	// U64 dispatch_count
	public UDATAPointer dispatch_countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._dispatch_countOffset_));
	}

	// U64 dispatch_latency
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dispatch_latencyOffset_", declaredType="U64")
	public UDATA dispatch_latency() throws CorruptDataException {
		return new U64(getLongAtOffset(aso._dispatch_latencyOffset_));
	}

	// U64 dispatch_latency
	public UDATAPointer dispatch_latencyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._dispatch_latencyOffset_));
	}

	// U64 dispatch_latency_terminated
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dispatch_latency_terminatedOffset_", declaredType="U64")
	public UDATA dispatch_latency_terminated() throws CorruptDataException {
		return new U64(getLongAtOffset(aso._dispatch_latency_terminatedOffset_));
	}

	// U64 dispatch_latency_terminated
	public UDATAPointer dispatch_latency_terminatedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._dispatch_latency_terminatedOffset_));
	}

	// U32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
	public UDATA flags() throws CorruptDataException {
		return new U32(getIntAtOffset(aso._flagsOffset_));
	}

	// U32 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._flagsOffset_));
	}

	// U64 fp_process_load
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fp_process_loadOffset_", declaredType="U64")
	public UDATA fp_process_load() throws CorruptDataException {
		return new U64(getLongAtOffset(aso._fp_process_loadOffset_));
	}

	// U64 fp_process_load
	public UDATAPointer fp_process_loadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._fp_process_loadOffset_));
	}

	// U64 fp_process_load_terminated
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fp_process_load_terminatedOffset_", declaredType="U64")
	public UDATA fp_process_load_terminated() throws CorruptDataException {
		return new U64(getLongAtOffset(aso._fp_process_load_terminatedOffset_));
	}

	// U64 fp_process_load_terminated
	public UDATAPointer fp_process_load_terminatedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._fp_process_load_terminatedOffset_));
	}

	// I64 opt_jobid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_opt_jobidOffset_", declaredType="I64")
	public IDATA opt_jobid() throws CorruptDataException {
		return new I64(getLongAtOffset(aso._opt_jobidOffset_));
	}

	// I64 opt_jobid
	public IDATAPointer opt_jobidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(aso._opt_jobidOffset_));
	}

	// U32 opt_timeout
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_opt_timeoutOffset_", declaredType="U32")
	public UDATA opt_timeout() throws CorruptDataException {
		return new U32(getIntAtOffset(aso._opt_timeoutOffset_));
	}

	// U32 opt_timeout
	public UDATAPointer opt_timeoutEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._opt_timeoutOffset_));
	}

	// U32 opt_timeout_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_opt_timeout_countOffset_", declaredType="U32")
	public UDATA opt_timeout_count() throws CorruptDataException {
		return new U32(getIntAtOffset(aso._opt_timeout_countOffset_));
	}

	// U32 opt_timeout_count
	public UDATAPointer opt_timeout_countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._opt_timeout_countOffset_));
	}

	// sradid_t pref_srad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pref_sradOffset_", declaredType="sradid_t")
	public I16 pref_srad() throws CorruptDataException {
		return new I16(getShortAtOffset(aso._pref_sradOffset_));
	}

	// sradid_t pref_srad
	public I16Pointer pref_sradEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(aso._pref_sradOffset_));
	}

	// U64 process_load
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_process_loadOffset_", declaredType="U64")
	public UDATA process_load() throws CorruptDataException {
		return new U64(getLongAtOffset(aso._process_loadOffset_));
	}

	// U64 process_load
	public UDATAPointer process_loadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._process_loadOffset_));
	}

	// U64 process_load_terminated
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_process_load_terminatedOffset_", declaredType="U64")
	public UDATA process_load_terminated() throws CorruptDataException {
		return new U64(getLongAtOffset(aso._process_load_terminatedOffset_));
	}

	// U64 process_load_terminated
	public UDATAPointer process_load_terminatedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(aso._process_load_terminatedOffset_));
	}

}
