/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9CInterpreterStackFramePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9CInterpreterStackFramePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9CInterpreterStackFrame.class)
public class J9CInterpreterStackFramePointer extends StructurePointer {

	// NULL
	public static final J9CInterpreterStackFramePointer NULL = new J9CInterpreterStackFramePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9CInterpreterStackFramePointer(long address) {
		super(address);
	}

	public static J9CInterpreterStackFramePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9CInterpreterStackFramePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9CInterpreterStackFramePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9CInterpreterStackFramePointer(address);
	}

	public J9CInterpreterStackFramePointer add(long count) {
		return J9CInterpreterStackFramePointer.cast(address + (J9CInterpreterStackFrame.SIZEOF * count));
	}

	public J9CInterpreterStackFramePointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9CInterpreterStackFramePointer addOffset(long offset) {
		return J9CInterpreterStackFramePointer.cast(address + offset);
	}

	public J9CInterpreterStackFramePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9CInterpreterStackFramePointer sub(long count) {
		return J9CInterpreterStackFramePointer.cast(address - (J9CInterpreterStackFrame.SIZEOF * count));
	}

	public J9CInterpreterStackFramePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9CInterpreterStackFramePointer subOffset(long offset) {
		return J9CInterpreterStackFramePointer.cast(address - offset);
	}

	public J9CInterpreterStackFramePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9CInterpreterStackFramePointer untag(long mask) {
		return J9CInterpreterStackFramePointer.cast(address & ~mask);
	}

	public J9CInterpreterStackFramePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9CInterpreterStackFrame.SIZEOF;
	}

	// Implementation methods

	// UDATA[] align
	public UDATAPointer alignEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._alignOffset_));
	}

	// UDATA backChain
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_backChainOffset_", declaredType="UDATA")
	public UDATA backChain() throws CorruptDataException {
		return getUDATAAtOffset(J9CInterpreterStackFrame._backChainOffset_);
	}

	// UDATA backChain
	public UDATAPointer backChainEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._backChainOffset_));
	}

	// UDATA currentTOC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_currentTOCOffset_", declaredType="UDATA")
	public UDATA currentTOC() throws CorruptDataException {
		return getUDATAAtOffset(J9CInterpreterStackFrame._currentTOCOffset_);
	}

	// UDATA currentTOC
	public UDATAPointer currentTOCEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._currentTOCOffset_));
	}

	// U8[] jitFPRs
	public U8Pointer jitFPRsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._jitFPRsOffset_));
	}

	// J9JITGPRSpillArea jitGPRs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jitGPRsOffset_", declaredType="J9JITGPRSpillArea")
	public J9JITGPRSpillAreaPointer jitGPRs() throws CorruptDataException {
		return J9JITGPRSpillAreaPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._jitGPRsOffset_));
	}

	// J9JITGPRSpillArea jitGPRs
	public PointerPointer jitGPRsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._jitGPRsOffset_));
	}

	// U8[] jitVRs
	public U8Pointer jitVRsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._jitVRsOffset_));
	}

	// UDATA[] outgoingArguments
	public UDATAPointer outgoingArgumentsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._outgoingArgumentsOffset_));
	}

	// UDATA preservedCR
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_preservedCROffset_", declaredType="UDATA")
	public UDATA preservedCR() throws CorruptDataException {
		return getUDATAAtOffset(J9CInterpreterStackFrame._preservedCROffset_);
	}

	// UDATA preservedCR
	public UDATAPointer preservedCREA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._preservedCROffset_));
	}

	// U8[] preservedFPRs
	public U8Pointer preservedFPRsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._preservedFPRsOffset_));
	}

	// UDATA[] preservedGPRs
	public UDATAPointer preservedGPRsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._preservedGPRsOffset_));
	}

	// UDATA preservedLR
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_preservedLROffset_", declaredType="UDATA")
	public UDATA preservedLR() throws CorruptDataException {
		return getUDATAAtOffset(J9CInterpreterStackFrame._preservedLROffset_);
	}

	// UDATA preservedLR
	public UDATAPointer preservedLREA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._preservedLROffset_));
	}

	// U8[] preservedVRs
	public U8Pointer preservedVRsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._preservedVRsOffset_));
	}

	// UDATA reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedOffset_", declaredType="UDATA")
	public UDATA reserved() throws CorruptDataException {
		return getUDATAAtOffset(J9CInterpreterStackFrame._reservedOffset_);
	}

	// UDATA reserved
	public UDATAPointer reservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._reservedOffset_));
	}

	// UDATA tocSave
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tocSaveOffset_", declaredType="UDATA")
	public UDATA tocSave() throws CorruptDataException {
		return getUDATAAtOffset(J9CInterpreterStackFrame._tocSaveOffset_);
	}

	// UDATA tocSave
	public UDATAPointer tocSaveEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CInterpreterStackFrame._tocSaveOffset_));
	}

}
