/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LC_thread_localePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LC_thread_localePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LC_thread_locale.class)
public class _LC_thread_localePointer extends StructurePointer {

	// NULL
	public static final _LC_thread_localePointer NULL = new _LC_thread_localePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LC_thread_localePointer(long address) {
		super(address);
	}

	public static _LC_thread_localePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LC_thread_localePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LC_thread_localePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LC_thread_localePointer(address);
	}

	public _LC_thread_localePointer add(long count) {
		return _LC_thread_localePointer.cast(address + (_LC_thread_locale.SIZEOF * count));
	}

	public _LC_thread_localePointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LC_thread_localePointer addOffset(long offset) {
		return _LC_thread_localePointer.cast(address + offset);
	}

	public _LC_thread_localePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LC_thread_localePointer sub(long count) {
		return _LC_thread_localePointer.cast(address - (_LC_thread_locale.SIZEOF * count));
	}

	public _LC_thread_localePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LC_thread_localePointer subOffset(long offset) {
		return _LC_thread_localePointer.cast(address - offset);
	}

	public _LC_thread_localePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LC_thread_localePointer untag(long mask) {
		return _LC_thread_localePointer.cast(address & ~mask);
	}

	public _LC_thread_localePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LC_thread_locale.SIZEOF;
	}

	// Implementation methods

	// _LC_charmap_objhdl_t* __lc_charmap_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_charmap_ptrOffset_", declaredType="_LC_charmap_objhdl_t*")
	public _LC_charmap_objhdlPointer __lc_charmap_ptr() throws CorruptDataException {
		return _LC_charmap_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_charmap_ptrOffset_));
	}

	// _LC_charmap_objhdl_t* __lc_charmap_ptr
	public PointerPointer __lc_charmap_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_charmap_ptrOffset_));
	}

	// _LC_collate_objhdl_t* __lc_collate_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_collate_ptrOffset_", declaredType="_LC_collate_objhdl_t*")
	public _LC_collate_objhdlPointer __lc_collate_ptr() throws CorruptDataException {
		return _LC_collate_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_collate_ptrOffset_));
	}

	// _LC_collate_objhdl_t* __lc_collate_ptr
	public PointerPointer __lc_collate_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_collate_ptrOffset_));
	}

	// _LC_ctype_objhdl_t* __lc_ctype_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_ctype_ptrOffset_", declaredType="_LC_ctype_objhdl_t*")
	public _LC_ctype_objhdlPointer __lc_ctype_ptr() throws CorruptDataException {
		return _LC_ctype_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_ctype_ptrOffset_));
	}

	// _LC_ctype_objhdl_t* __lc_ctype_ptr
	public PointerPointer __lc_ctype_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_ctype_ptrOffset_));
	}

	// I32 __lc_isiso1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_isiso1Offset_", declaredType="I32")
	public IDATA __lc_isiso1() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_thread_locale.___lc_isiso1Offset_));
	}

	// I32 __lc_isiso1
	public IDATAPointer __lc_isiso1EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_isiso1Offset_));
	}

	// _LC_locale_objhdl_t* __lc_locale_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_locale_ptrOffset_", declaredType="_LC_locale_objhdl_t*")
	public _LC_locale_objhdlPointer __lc_locale_ptr() throws CorruptDataException {
		return _LC_locale_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_locale_ptrOffset_));
	}

	// _LC_locale_objhdl_t* __lc_locale_ptr
	public PointerPointer __lc_locale_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_locale_ptrOffset_));
	}

	// _LC_monetary_objhdl_t* __lc_monetary_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_monetary_ptrOffset_", declaredType="_LC_monetary_objhdl_t*")
	public _LC_monetary_objhdlPointer __lc_monetary_ptr() throws CorruptDataException {
		return _LC_monetary_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_monetary_ptrOffset_));
	}

	// _LC_monetary_objhdl_t* __lc_monetary_ptr
	public PointerPointer __lc_monetary_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_monetary_ptrOffset_));
	}

	// _LC_numeric_objhdl_t* __lc_numeric_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_numeric_ptrOffset_", declaredType="_LC_numeric_objhdl_t*")
	public _LC_numeric_objhdlPointer __lc_numeric_ptr() throws CorruptDataException {
		return _LC_numeric_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_numeric_ptrOffset_));
	}

	// _LC_numeric_objhdl_t* __lc_numeric_ptr
	public PointerPointer __lc_numeric_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_numeric_ptrOffset_));
	}

	// _LC_resp_objhdl_t* __lc_resp_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_resp_ptrOffset_", declaredType="_LC_resp_objhdl_t*")
	public _LC_resp_objhdlPointer __lc_resp_ptr() throws CorruptDataException {
		return _LC_resp_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_resp_ptrOffset_));
	}

	// _LC_resp_objhdl_t* __lc_resp_ptr
	public PointerPointer __lc_resp_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_resp_ptrOffset_));
	}

	// _LC_time_objhdl_t* __lc_time_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lc_time_ptrOffset_", declaredType="_LC_time_objhdl_t*")
	public _LC_time_objhdlPointer __lc_time_ptr() throws CorruptDataException {
		return _LC_time_objhdlPointer.cast(getPointerAtOffset(_LC_thread_locale.___lc_time_ptrOffset_));
	}

	// _LC_time_objhdl_t* __lc_time_ptr
	public PointerPointer __lc_time_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale.___lc_time_ptrOffset_));
	}

	// U8* locale_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_locale_nameOffset_", declaredType="U8*")
	public U8Pointer locale_name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_LC_thread_locale._locale_nameOffset_));
	}

	// U8* locale_name
	public PointerPointer locale_nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_thread_locale._locale_nameOffset_));
	}

}
