/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: lwpsinfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the lwpsinfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=lwpsinfo.class)
public class lwpsinfoPointer extends StructurePointer {

	// NULL
	public static final lwpsinfoPointer NULL = new lwpsinfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected lwpsinfoPointer(long address) {
		super(address);
	}

	public static lwpsinfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static lwpsinfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static lwpsinfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new lwpsinfoPointer(address);
	}

	public lwpsinfoPointer add(long count) {
		return lwpsinfoPointer.cast(address + (lwpsinfo.SIZEOF * count));
	}

	public lwpsinfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public lwpsinfoPointer addOffset(long offset) {
		return lwpsinfoPointer.cast(address + offset);
	}

	public lwpsinfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public lwpsinfoPointer sub(long count) {
		return lwpsinfoPointer.cast(address - (lwpsinfo.SIZEOF * count));
	}

	public lwpsinfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public lwpsinfoPointer subOffset(long offset) {
		return lwpsinfoPointer.cast(address - offset);
	}

	public lwpsinfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public lwpsinfoPointer untag(long mask) {
		return lwpsinfoPointer.cast(address & ~mask);
	}

	public lwpsinfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return lwpsinfo.SIZEOF;
	}

	// Implementation methods

	// U64[] pr__pad
	public UDATAPointer pr__padEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(lwpsinfo._pr__padOffset_));
	}

	// U32 pr__pad1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr__pad1Offset_", declaredType="U32")
	public UDATA pr__pad1() throws CorruptDataException {
		return new U32(getIntAtOffset(lwpsinfo._pr__pad1Offset_));
	}

	// U32 pr__pad1
	public UDATAPointer pr__pad1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr__pad1Offset_));
	}

	// prptr64_t pr_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_addrOffset_", declaredType="prptr64_t")
	public VoidPointer pr_addr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(lwpsinfo._pr_addrOffset_));
	}

	// prptr64_t pr_addr
	public PointerPointer pr_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lwpsinfo._pr_addrOffset_));
	}

	// I32 pr_bindpro
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_bindproOffset_", declaredType="I32")
	public IDATA pr_bindpro() throws CorruptDataException {
		return new I32(getIntAtOffset(lwpsinfo._pr_bindproOffset_));
	}

	// I32 pr_bindpro
	public IDATAPointer pr_bindproEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr_bindproOffset_));
	}

	// U8[] pr_clname
	public U8Pointer pr_clnameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lwpsinfo._pr_clnameOffset_));
	}

	// U32 pr_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_flagOffset_", declaredType="U32")
	public UDATA pr_flag() throws CorruptDataException {
		return new U32(getIntAtOffset(lwpsinfo._pr_flagOffset_));
	}

	// U32 pr_flag
	public UDATAPointer pr_flagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr_flagOffset_));
	}

	// U64 pr_lwpid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_lwpidOffset_", declaredType="U64")
	public UDATA pr_lwpid() throws CorruptDataException {
		return new U64(getLongAtOffset(lwpsinfo._pr_lwpidOffset_));
	}

	// U64 pr_lwpid
	public UDATAPointer pr_lwpidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr_lwpidOffset_));
	}

	// uchar_t pr_nice
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_niceOffset_", declaredType="uchar_t")
	public U8 pr_nice() throws CorruptDataException {
		return new U8(getByteAtOffset(lwpsinfo._pr_niceOffset_));
	}

	// uchar_t pr_nice
	public U8Pointer pr_niceEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lwpsinfo._pr_niceOffset_));
	}

	// I32 pr_onpro
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_onproOffset_", declaredType="I32")
	public IDATA pr_onpro() throws CorruptDataException {
		return new I32(getIntAtOffset(lwpsinfo._pr_onproOffset_));
	}

	// I32 pr_onpro
	public IDATAPointer pr_onproEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr_onproOffset_));
	}

	// U32 pr_policy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_policyOffset_", declaredType="U32")
	public UDATA pr_policy() throws CorruptDataException {
		return new U32(getIntAtOffset(lwpsinfo._pr_policyOffset_));
	}

	// U32 pr_policy
	public UDATAPointer pr_policyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr_policyOffset_));
	}

	// I32 pr_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_priOffset_", declaredType="I32")
	public IDATA pr_pri() throws CorruptDataException {
		return new I32(getIntAtOffset(lwpsinfo._pr_priOffset_));
	}

	// I32 pr_pri
	public IDATAPointer pr_priEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr_priOffset_));
	}

	// U32 pr_ptid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_ptidOffset_", declaredType="U32")
	public UDATA pr_ptid() throws CorruptDataException {
		return new U32(getIntAtOffset(lwpsinfo._pr_ptidOffset_));
	}

	// U32 pr_ptid
	public UDATAPointer pr_ptidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lwpsinfo._pr_ptidOffset_));
	}

	// U8 pr_sname
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_snameOffset_", declaredType="U8")
	public U8 pr_sname() throws CorruptDataException {
		return new U8(getByteAtOffset(lwpsinfo._pr_snameOffset_));
	}

	// U8 pr_sname
	public U8Pointer pr_snameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lwpsinfo._pr_snameOffset_));
	}

	// U8 pr_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_stateOffset_", declaredType="U8")
	public U8 pr_state() throws CorruptDataException {
		return new U8(getByteAtOffset(lwpsinfo._pr_stateOffset_));
	}

	// U8 pr_state
	public U8Pointer pr_stateEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lwpsinfo._pr_stateOffset_));
	}

	// prptr64_t pr_wchan
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_wchanOffset_", declaredType="prptr64_t")
	public VoidPointer pr_wchan() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(lwpsinfo._pr_wchanOffset_));
	}

	// prptr64_t pr_wchan
	public PointerPointer pr_wchanEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lwpsinfo._pr_wchanOffset_));
	}

	// uchar_t pr_wtype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_wtypeOffset_", declaredType="uchar_t")
	public U8 pr_wtype() throws CorruptDataException {
		return new U8(getByteAtOffset(lwpsinfo._pr_wtypeOffset_));
	}

	// uchar_t pr_wtype
	public U8Pointer pr_wtypeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lwpsinfo._pr_wtypeOffset_));
	}

}
