/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: procPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the procPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=proc.class)
public class procPointer extends StructurePointer {

	// NULL
	public static final procPointer NULL = new procPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected procPointer(long address) {
		super(address);
	}

	public static procPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static procPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static procPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new procPointer(address);
	}

	public procPointer add(long count) {
		return procPointer.cast(address + (proc.SIZEOF * count));
	}

	public procPointer add(Scalar count) {
		return add(count.longValue());
	}

	public procPointer addOffset(long offset) {
		return procPointer.cast(address + offset);
	}

	public procPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public procPointer sub(long count) {
		return procPointer.cast(address - (proc.SIZEOF * count));
	}

	public procPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public procPointer subOffset(long offset) {
		return procPointer.cast(address - offset);
	}

	public procPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public procPointer untag(long mask) {
		return procPointer.cast(address & ~mask);
	}

	public procPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return proc.SIZEOF;
	}

	// Implementation methods

	// proc_counts p_acct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_acctOffset_", declaredType="proc_counts")
	public proc_countsPointer p_acct() throws CorruptDataException {
		return proc_countsPointer.cast(nonNullFieldEA(proc._p_acctOffset_));
	}

	// proc_counts p_acct
	public PointerPointer p_acctEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_acctOffset_));
	}

	// ushort p_active
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_activeOffset_", declaredType="ushort")
	public U16 p_active() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_activeOffset_));
	}

	// ushort p_active
	public U16Pointer p_activeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_activeOffset_));
	}

	// vmhandle_t p_adspace
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_adspaceOffset_", declaredType="vmhandle_t")
	public UDATA p_adspace() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_adspaceOffset_));
	}

	// vmhandle_t p_adspace
	public UDATAPointer p_adspaceEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_adspaceOffset_));
	}

	// aso p_aso
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_asoOffset_", declaredType="aso")
	public asoPointer p_aso() throws CorruptDataException {
		return asoPointer.cast(nonNullFieldEA(proc._p_asoOffset_));
	}

	// aso p_aso
	public PointerPointer p_asoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_asoOffset_));
	}

	// uint p_atomic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_atomicOffset_", declaredType="uint")
	public UDATA p_atomic() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_atomicOffset_));
	}

	// uint p_atomic
	public UDATAPointer p_atomicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_atomicOffset_));
	}

	// U8 p_boost_level
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_boost_levelOffset_", declaredType="U8")
	public U8 p_boost_level() throws CorruptDataException {
		return new U8(getByteAtOffset(proc._p_boost_levelOffset_));
	}

	// U8 p_boost_level
	public U8Pointer p_boost_levelEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(proc._p_boost_levelOffset_));
	}

	// U8 p_boost_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_boost_typeOffset_", declaredType="U8")
	public U8 p_boost_type() throws CorruptDataException {
		return new U8(getByteAtOffset(proc._p_boost_typeOffset_));
	}

	// U8 p_boost_type
	public U8Pointer p_boost_typeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(proc._p_boost_typeOffset_));
	}

	// ushort p_boundcount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_boundcountOffset_", declaredType="ushort")
	public U16 p_boundcount() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_boundcountOffset_));
	}

	// ushort p_boundcount
	public U16Pointer p_boundcountEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_boundcountOffset_));
	}

	// U32 p_caccel_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_caccel_countOffset_", declaredType="U32")
	public UDATA p_caccel_count() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_caccel_countOffset_));
	}

	// U32 p_caccel_count
	public UDATAPointer p_caccel_countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_caccel_countOffset_));
	}

	// U32 p_caccel_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_caccel_flagsOffset_", declaredType="U32")
	public UDATA p_caccel_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_caccel_flagsOffset_));
	}

	// U32 p_caccel_flags
	public UDATAPointer p_caccel_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_caccel_flagsOffset_));
	}

	// Simple_lock p_caccel_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_caccel_lockOffset_", declaredType="Simple_lock")
	public _simple_lockPointer p_caccel_lock() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(proc._p_caccel_lockOffset_));
	}

	// Simple_lock p_caccel_lock
	public PointerPointer p_caccel_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_caccel_lockOffset_));
	}

	// proc* p_caccel_next_proc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_caccel_next_procOffset_", declaredType="proc*")
	public procPointer p_caccel_next_proc() throws CorruptDataException {
		return procPointer.cast(getPointerAtOffset(proc._p_caccel_next_procOffset_));
	}

	// proc* p_caccel_next_proc
	public PointerPointer p_caccel_next_procEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_caccel_next_procOffset_));
	}

	// proc* p_caccel_prev_proc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_caccel_prev_procOffset_", declaredType="proc*")
	public procPointer p_caccel_prev_proc() throws CorruptDataException {
		return procPointer.cast(getPointerAtOffset(proc._p_caccel_prev_procOffset_));
	}

	// proc* p_caccel_prev_proc
	public PointerPointer p_caccel_prev_procEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_caccel_prev_procOffset_));
	}

	// void* p_caccel_uctxlist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_caccel_uctxlistOffset_", declaredType="void*")
	public VoidPointer p_caccel_uctxlist() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_caccel_uctxlistOffset_));
	}

	// void* p_caccel_uctxlist
	public PointerPointer p_caccel_uctxlistEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_caccel_uctxlistOffset_));
	}

	// I32 p_chkblock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_chkblockOffset_", declaredType="I32")
	public IDATA p_chkblock() throws CorruptDataException {
		return new I32(getIntAtOffset(proc._p_chkblockOffset_));
	}

	// I32 p_chkblock
	public IDATAPointer p_chkblockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_chkblockOffset_));
	}

	// void* p_chkfile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_chkfileOffset_", declaredType="void*")
	public VoidPointer p_chkfile() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_chkfileOffset_));
	}

	// void* p_chkfile
	public PointerPointer p_chkfileEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_chkfileOffset_));
	}

	// cputime_clock p_clock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_clockOffset_", declaredType="cputime_clock")
	public cputime_clockPointer p_clock() throws CorruptDataException {
		return cputime_clockPointer.cast(nonNullFieldEA(proc._p_clockOffset_));
	}

	// cputime_clock p_clock
	public PointerPointer p_clockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_clockOffset_));
	}

	// I16 p_cpticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_cpticksOffset_", declaredType="I16")
	public I16 p_cpticks() throws CorruptDataException {
		return new I16(getShortAtOffset(proc._p_cpticksOffset_));
	}

	// I16 p_cpticks
	public I16Pointer p_cpticksEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(proc._p_cpticksOffset_));
	}

	// proc$diskiostat p_diskiostat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_diskiostatOffset_", declaredType="proc$diskiostat")
	public proc$diskiostatPointer p_diskiostat() throws CorruptDataException {
		return proc$diskiostatPointer.cast(nonNullFieldEA(proc._p_diskiostatOffset_));
	}

	// proc$diskiostat p_diskiostat
	public PointerPointer p_diskiostatEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_diskiostatOffset_));
	}

	// ushort p_entry_probes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_entry_probesOffset_", declaredType="ushort")
	public U16 p_entry_probes() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_entry_probesOffset_));
	}

	// ushort p_entry_probes
	public U16Pointer p_entry_probesEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_entry_probesOffset_));
	}

	// void* p_etrc_procd_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_etrc_procd_ptrOffset_", declaredType="void*")
	public VoidPointer p_etrc_procd_ptr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_etrc_procd_ptrOffset_));
	}

	// void* p_etrc_procd_ptr
	public PointerPointer p_etrc_procd_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_etrc_procd_ptrOffset_));
	}

	// ushort p_exit_probes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_exit_probesOffset_", declaredType="ushort")
	public U16 p_exit_probes() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_exit_probesOffset_));
	}

	// ushort p_exit_probes
	public U16Pointer p_exit_probesEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_exit_probesOffset_));
	}

	// proc_eye_catch_t p_eyec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_eyecOffset_", declaredType="proc_eye_catch_t")
	public UDATA p_eyec() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_eyecOffset_));
	}

	// proc_eye_catch_t p_eyec
	public UDATAPointer p_eyecEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_eyecOffset_));
	}

	// uint p_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_flagOffset_", declaredType="uint")
	public UDATA p_flag() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_flagOffset_));
	}

	// uint p_flag
	public UDATAPointer p_flagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_flagOffset_));
	}

	// uint p_flag2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_flag2Offset_", declaredType="uint")
	public UDATA p_flag2() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_flag2Offset_));
	}

	// uint p_flag2
	public UDATAPointer p_flag2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_flag2Offset_));
	}

	// U64 p_forktime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_forktimeOffset_", declaredType="U64")
	public UDATA p_forktime() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_forktimeOffset_));
	}

	// U64 p_forktime
	public UDATAPointer p_forktimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_forktimeOffset_));
	}

	// ksiginfo* p_infoq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_infoqOffset_", declaredType="ksiginfo*")
	public ksiginfoPointer p_infoq() throws CorruptDataException {
		return ksiginfoPointer.cast(getPointerAtOffset(proc._p_infoqOffset_));
	}

	// ksiginfo* p_infoq
	public PointerPointer p_infoqEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_infoqOffset_));
	}

	// uint p_int
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_intOffset_", declaredType="uint")
	public UDATA p_int() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_intOffset_));
	}

	// uint p_int
	public UDATAPointer p_intEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_intOffset_));
	}

	// U64 p_interval_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_interval_startOffset_", declaredType="U64")
	public UDATA p_interval_start() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_interval_startOffset_));
	}

	// U64 p_interval_start
	public UDATAPointer p_interval_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_interval_startOffset_));
	}

	// ushort p_io_priority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_io_priorityOffset_", declaredType="ushort")
	public U16 p_io_priority() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_io_priorityOffset_));
	}

	// ushort p_io_priority
	public U16Pointer p_io_priorityEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_io_priorityOffset_));
	}

	// void* p_job
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_jobOffset_", declaredType="void*")
	public VoidPointer p_job() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_jobOffset_));
	}

	// void* p_job
	public PointerPointer p_jobEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_jobOffset_));
	}

	// void* p_lgpage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_lgpageOffset_", declaredType="void*")
	public VoidPointer p_lgpage() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_lgpageOffset_));
	}

	// void* p_lgpage
	public PointerPointer p_lgpageEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_lgpageOffset_));
	}

	// ushort p_local
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_localOffset_", declaredType="ushort")
	public U16 p_local() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_localOffset_));
	}

	// ushort p_local
	public U16Pointer p_localEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_localOffset_));
	}

	// u_longlong_t p_maj_pf_data_term
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_maj_pf_data_termOffset_", declaredType="u_longlong_t")
	public UDATA p_maj_pf_data_term() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_maj_pf_data_termOffset_));
	}

	// u_longlong_t p_maj_pf_data_term
	public UDATAPointer p_maj_pf_data_termEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_maj_pf_data_termOffset_));
	}

	// u_longlong_t p_maj_pf_kernel_term
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_maj_pf_kernel_termOffset_", declaredType="u_longlong_t")
	public UDATA p_maj_pf_kernel_term() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_maj_pf_kernel_termOffset_));
	}

	// u_longlong_t p_maj_pf_kernel_term
	public UDATAPointer p_maj_pf_kernel_termEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_maj_pf_kernel_termOffset_));
	}

	// u_longlong_t p_maj_pf_text_term
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_maj_pf_text_termOffset_", declaredType="u_longlong_t")
	public UDATA p_maj_pf_text_term() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_maj_pf_text_termOffset_));
	}

	// u_longlong_t p_maj_pf_text_term
	public UDATAPointer p_maj_pf_text_termEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_maj_pf_text_termOffset_));
	}

	// U64 p_majflt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_majfltOffset_", declaredType="U64")
	public UDATA p_majflt() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_majfltOffset_));
	}

	// U64 p_majflt
	public UDATAPointer p_majfltEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_majfltOffset_));
	}

	// uint p_majfltsec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_majfltsecOffset_", declaredType="uint")
	public UDATA p_majfltsec() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_majfltsecOffset_));
	}

	// uint p_majfltsec
	public UDATAPointer p_majfltsecEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_majfltsecOffset_));
	}

	// time_t p_memory_lbolt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_memory_lboltOffset_", declaredType="time_t")
	public IDATA p_memory_lbolt() throws CorruptDataException {
		return new I64(getLongAtOffset(proc._p_memory_lboltOffset_));
	}

	// time_t p_memory_lbolt
	public IDATAPointer p_memory_lboltEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_memory_lboltOffset_));
	}

	// u_longlong_t p_min_pf_data_term
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_min_pf_data_termOffset_", declaredType="u_longlong_t")
	public UDATA p_min_pf_data_term() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_min_pf_data_termOffset_));
	}

	// u_longlong_t p_min_pf_data_term
	public UDATAPointer p_min_pf_data_termEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_min_pf_data_termOffset_));
	}

	// u_longlong_t p_min_pf_kernel_term
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_min_pf_kernel_termOffset_", declaredType="u_longlong_t")
	public UDATA p_min_pf_kernel_term() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_min_pf_kernel_termOffset_));
	}

	// u_longlong_t p_min_pf_kernel_term
	public UDATAPointer p_min_pf_kernel_termEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_min_pf_kernel_termOffset_));
	}

	// u_longlong_t p_min_pf_text_term
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_min_pf_text_termOffset_", declaredType="u_longlong_t")
	public UDATA p_min_pf_text_term() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_min_pf_text_termOffset_));
	}

	// u_longlong_t p_min_pf_text_term
	public UDATAPointer p_min_pf_text_termEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_min_pf_text_termOffset_));
	}

	// U64 p_minflt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_minfltOffset_", declaredType="U64")
	public UDATA p_minflt() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_minfltOffset_));
	}

	// U64 p_minflt
	public UDATAPointer p_minfltEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_minfltOffset_));
	}

	// I16 p_msgcnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_msgcntOffset_", declaredType="I16")
	public I16 p_msgcnt() throws CorruptDataException {
		return new I16(getShortAtOffset(proc._p_msgcntOffset_));
	}

	// I16 p_msgcnt
	public I16Pointer p_msgcntEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(proc._p_msgcntOffset_));
	}

	// U8 p_nice
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_niceOffset_", declaredType="U8")
	public U8 p_nice() throws CorruptDataException {
		return new U8(getByteAtOffset(proc._p_niceOffset_));
	}

	// U8 p_nice
	public U8Pointer p_niceEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(proc._p_niceOffset_));
	}

	// void* p_nx_accel_data_p
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_nx_accel_data_pOffset_", declaredType="void*")
	public VoidPointer p_nx_accel_data_p() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_nx_accel_data_pOffset_));
	}

	// void* p_nx_accel_data_p
	public PointerPointer p_nx_accel_data_pEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_nx_accel_data_pOffset_));
	}

	// U8[] p_pad
	public U8Pointer p_padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(proc._p_padOffset_));
	}

	// uint p_pctcpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_pctcpuOffset_", declaredType="uint")
	public UDATA p_pctcpu() throws CorruptDataException {
		return new U32(getIntAtOffset(proc._p_pctcpuOffset_));
	}

	// uint p_pctcpu
	public UDATAPointer p_pctcpuEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_pctcpuOffset_));
	}

	// ulong p_pevent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_peventOffset_", declaredType="ulong")
	public UDATA p_pevent() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_peventOffset_));
	}

	// ulong p_pevent
	public UDATAPointer p_peventEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_peventOffset_));
	}

	// pid_t p_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_pidOffset_", declaredType="pid_t")
	public IDATA p_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(proc._p_pidOffset_));
	}

	// pid_t p_pid
	public IDATAPointer p_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_pidOffset_));
	}

	// I16 p_process_srad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_process_sradOffset_", declaredType="I16")
	public I16 p_process_srad() throws CorruptDataException {
		return new I16(getShortAtOffset(proc._p_process_sradOffset_));
	}

	// I16 p_process_srad
	public I16Pointer p_process_sradEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(proc._p_process_sradOffset_));
	}

	// void* p_prtrcset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_prtrcsetOffset_", declaredType="void*")
	public VoidPointer p_prtrcset() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_prtrcsetOffset_));
	}

	// void* p_prtrcset
	public PointerPointer p_prtrcsetEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_prtrcsetOffset_));
	}

	// void* p_ptbpt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_ptbptOffset_", declaredType="void*")
	public VoidPointer p_ptbpt() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_ptbptOffset_));
	}

	// void* p_ptbpt
	public PointerPointer p_ptbptEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_ptbptOffset_));
	}

	// tid_t p_ptsynch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_ptsynchOffset_", declaredType="tid_t")
	public IDATA p_ptsynch() throws CorruptDataException {
		return new I64(getLongAtOffset(proc._p_ptsynchOffset_));
	}

	// tid_t p_ptsynch
	public IDATAPointer p_ptsynchEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_ptsynchOffset_));
	}

	// pvproc* p_pvprocp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_pvprocpOffset_", declaredType="pvproc*")
	public pvprocPointer p_pvprocp() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(proc._p_pvprocpOffset_));
	}

	// pvproc* p_pvprocp
	public PointerPointer p_pvprocpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_pvprocpOffset_));
	}

	// I64 p_repage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_repageOffset_", declaredType="I64")
	public IDATA p_repage() throws CorruptDataException {
		return new I64(getLongAtOffset(proc._p_repageOffset_));
	}

	// I64 p_repage
	public IDATAPointer p_repageEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_repageOffset_));
	}

	// void* p_rs_attinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_rs_attinfoOffset_", declaredType="void*")
	public VoidPointer p_rs_attinfo() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_rs_attinfoOffset_));
	}

	// void* p_rs_attinfo
	public PointerPointer p_rs_attinfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_rs_attinfoOffset_));
	}

	// ulong p_rss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_rssOffset_", declaredType="ulong")
	public UDATA p_rss() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_rssOffset_));
	}

	// ulong p_rss
	public UDATAPointer p_rssEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_rssOffset_));
	}

	// posix_tmr*[] p_rt_timer
	public PointerPointer p_rt_timerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_rt_timerOffset_));
	}

	// I32 p_sched_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sched_countOffset_", declaredType="I32")
	public IDATA p_sched_count() throws CorruptDataException {
		return new I32(getIntAtOffset(proc._p_sched_countOffset_));
	}

	// I32 p_sched_count
	public IDATAPointer p_sched_countEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_sched_countOffset_));
	}

	// U8 p_sched_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sched_priOffset_", declaredType="U8")
	public U8 p_sched_pri() throws CorruptDataException {
		return new U8(getByteAtOffset(proc._p_sched_priOffset_));
	}

	// U8 p_sched_pri
	public U8Pointer p_sched_priEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(proc._p_sched_priOffset_));
	}

	// sigset64_t p_sig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sigOffset_", declaredType="sigset64_t")
	public sigset64_tPointer p_sig() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(proc._p_sigOffset_));
	}

	// sigset64_t p_sig
	public PointerPointer p_sigEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_sigOffset_));
	}

	// sigset64_t p_sigcatch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sigcatchOffset_", declaredType="sigset64_t")
	public sigset64_tPointer p_sigcatch() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(proc._p_sigcatchOffset_));
	}

	// sigset64_t p_sigcatch
	public PointerPointer p_sigcatchEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_sigcatchOffset_));
	}

	// sigset64_t p_sigignore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sigignoreOffset_", declaredType="sigset64_t")
	public sigset64_tPointer p_sigignore() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(proc._p_sigignoreOffset_));
	}

	// sigset64_t p_sigignore
	public PointerPointer p_sigignoreEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_sigignoreOffset_));
	}

	// sigset64_t p_siginfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_siginfoOffset_", declaredType="sigset64_t")
	public sigset64_tPointer p_siginfo() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(proc._p_siginfoOffset_));
	}

	// sigset64_t p_siginfo
	public PointerPointer p_siginfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_siginfoOffset_));
	}

	// U64 p_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sizeOffset_", declaredType="U64")
	public UDATA p_size() throws CorruptDataException {
		return new U64(getLongAtOffset(proc._p_sizeOffset_));
	}

	// U64 p_size
	public UDATAPointer p_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(proc._p_sizeOffset_));
	}

	// I16 p_sradassign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sradassignOffset_", declaredType="I16")
	public I16 p_sradassign() throws CorruptDataException {
		return new I16(getShortAtOffset(proc._p_sradassignOffset_));
	}

	// I16 p_sradassign
	public I16Pointer p_sradassignEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(proc._p_sradassignOffset_));
	}

	// ushort p_suspended
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_suspendedOffset_", declaredType="ushort")
	public U16 p_suspended() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_suspendedOffset_));
	}

	// ushort p_suspended
	public U16Pointer p_suspendedEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_suspendedOffset_));
	}

	// ushort p_terminating
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_terminatingOffset_", declaredType="ushort")
	public U16 p_terminating() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_terminatingOffset_));
	}

	// ushort p_terminating
	public U16Pointer p_terminatingEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_terminatingOffset_));
	}

	// ushort p_threadcount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_threadcountOffset_", declaredType="ushort")
	public U16 p_threadcount() throws CorruptDataException {
		return new U16(getShortAtOffset(proc._p_threadcountOffset_));
	}

	// ushort p_threadcount
	public U16Pointer p_threadcountEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(proc._p_threadcountOffset_));
	}

	// I32 p_thrsetcnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_thrsetcntOffset_", declaredType="I32")
	public IDATA p_thrsetcnt() throws CorruptDataException {
		return new I32(getIntAtOffset(proc._p_thrsetcntOffset_));
	}

	// I32 p_thrsetcnt
	public IDATAPointer p_thrsetcntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_thrsetcntOffset_));
	}

	// I32 p_thsradcnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_thsradcntOffset_", declaredType="I32")
	public IDATA p_thsradcnt() throws CorruptDataException {
		return new I32(getIntAtOffset(proc._p_thsradcntOffset_));
	}

	// I32 p_thsradcnt
	public IDATAPointer p_thsradcntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_thsradcntOffset_));
	}

	// void* p_uprobe
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_uprobeOffset_", declaredType="void*")
	public VoidPointer p_uprobe() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(proc._p_uprobeOffset_));
	}

	// void* p_uprobe
	public PointerPointer p_uprobeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(proc._p_uprobeOffset_));
	}

	// I32 p_wlmocthrds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_wlmocthrdsOffset_", declaredType="I32")
	public IDATA p_wlmocthrds() throws CorruptDataException {
		return new I32(getIntAtOffset(proc._p_wlmocthrdsOffset_));
	}

	// I32 p_wlmocthrds
	public IDATAPointer p_wlmocthrdsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_wlmocthrdsOffset_));
	}

	// I32 p_wlmthrds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_wlmthrdsOffset_", declaredType="I32")
	public IDATA p_wlmthrds() throws CorruptDataException {
		return new I32(getIntAtOffset(proc._p_wlmthrdsOffset_));
	}

	// I32 p_wlmthrds
	public IDATAPointer p_wlmthrdsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(proc._p_wlmthrdsOffset_));
	}

	// U8 sysidmod
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysidmodOffset_", declaredType="U8")
	public U8 sysidmod() throws CorruptDataException {
		return new U8(getByteAtOffset(proc._sysidmodOffset_));
	}

	// U8 sysidmod
	public U8Pointer sysidmodEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(proc._sysidmodOffset_));
	}

	// U8 unused1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unused1Offset_", declaredType="U8")
	public U8 unused1() throws CorruptDataException {
		return new U8(getByteAtOffset(proc._unused1Offset_));
	}

	// U8 unused1
	public U8Pointer unused1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(proc._unused1Offset_));
	}

}
