/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ptxsprsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ptxsprsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ptxsprs.class)
public class ptxsprsPointer extends StructurePointer {

	// NULL
	public static final ptxsprsPointer NULL = new ptxsprsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ptxsprsPointer(long address) {
		super(address);
	}

	public static ptxsprsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ptxsprsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ptxsprsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ptxsprsPointer(address);
	}

	public ptxsprsPointer add(long count) {
		return ptxsprsPointer.cast(address + (ptxsprs.SIZEOF * count));
	}

	public ptxsprsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ptxsprsPointer addOffset(long offset) {
		return ptxsprsPointer.cast(address + offset);
	}

	public ptxsprsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ptxsprsPointer sub(long count) {
		return ptxsprsPointer.cast(address - (ptxsprs.SIZEOF * count));
	}

	public ptxsprsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ptxsprsPointer subOffset(long offset) {
		return ptxsprsPointer.cast(address - offset);
	}

	public ptxsprsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ptxsprsPointer untag(long mask) {
		return ptxsprsPointer.cast(address & ~mask);
	}

	public ptxsprsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ptxsprs.SIZEOF;
	}

	// Implementation methods

	// U32 pt_cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_crOffset_", declaredType="U32")
	public UDATA pt_cr() throws CorruptDataException {
		return new U32(getIntAtOffset(ptxsprs._pt_crOffset_));
	}

	// U32 pt_cr
	public UDATAPointer pt_crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_crOffset_));
	}

	// U64 pt_ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_ctrOffset_", declaredType="U64")
	public UDATA pt_ctr() throws CorruptDataException {
		return new U64(getLongAtOffset(ptxsprs._pt_ctrOffset_));
	}

	// U64 pt_ctr
	public UDATAPointer pt_ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_ctrOffset_));
	}

	// U32 pt_fpscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_fpscrOffset_", declaredType="U32")
	public UDATA pt_fpscr() throws CorruptDataException {
		return new U32(getIntAtOffset(ptxsprs._pt_fpscrOffset_));
	}

	// U32 pt_fpscr
	public UDATAPointer pt_fpscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_fpscrOffset_));
	}

	// U32 pt_fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_fpscrxOffset_", declaredType="U32")
	public UDATA pt_fpscrx() throws CorruptDataException {
		return new U32(getIntAtOffset(ptxsprs._pt_fpscrxOffset_));
	}

	// U32 pt_fpscrx
	public UDATAPointer pt_fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_fpscrxOffset_));
	}

	// U64 pt_iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_iarOffset_", declaredType="U64")
	public UDATA pt_iar() throws CorruptDataException {
		return new U64(getLongAtOffset(ptxsprs._pt_iarOffset_));
	}

	// U64 pt_iar
	public UDATAPointer pt_iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_iarOffset_));
	}

	// U64 pt_lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_lrOffset_", declaredType="U64")
	public UDATA pt_lr() throws CorruptDataException {
		return new U64(getLongAtOffset(ptxsprs._pt_lrOffset_));
	}

	// U64 pt_lr
	public UDATAPointer pt_lrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_lrOffset_));
	}

	// U64 pt_msr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_msrOffset_", declaredType="U64")
	public UDATA pt_msr() throws CorruptDataException {
		return new U64(getLongAtOffset(ptxsprs._pt_msrOffset_));
	}

	// U64 pt_msr
	public UDATAPointer pt_msrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_msrOffset_));
	}

	// U32 pt_xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_xerOffset_", declaredType="U32")
	public UDATA pt_xer() throws CorruptDataException {
		return new U32(getIntAtOffset(ptxsprs._pt_xerOffset_));
	}

	// U32 pt_xer
	public UDATAPointer pt_xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptxsprs._pt_xerOffset_));
	}

}
