/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: pvprocPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the pvprocPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=pvproc.class)
public class pvprocPointer extends StructurePointer {

	// NULL
	public static final pvprocPointer NULL = new pvprocPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected pvprocPointer(long address) {
		super(address);
	}

	public static pvprocPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static pvprocPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static pvprocPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new pvprocPointer(address);
	}

	public pvprocPointer add(long count) {
		return pvprocPointer.cast(address + (pvproc.SIZEOF * count));
	}

	public pvprocPointer add(Scalar count) {
		return add(count.longValue());
	}

	public pvprocPointer addOffset(long offset) {
		return pvprocPointer.cast(address + offset);
	}

	public pvprocPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public pvprocPointer sub(long count) {
		return pvprocPointer.cast(address - (pvproc.SIZEOF * count));
	}

	public pvprocPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public pvprocPointer subOffset(long offset) {
		return pvprocPointer.cast(address - offset);
	}

	public pvprocPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public pvprocPointer untag(long mask) {
		return pvprocPointer.cast(address & ~mask);
	}

	public pvprocPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return pvproc.SIZEOF;
	}

	// Implementation methods

	// I16 pv_acctflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_acctflagsOffset_", declaredType="I16")
	public I16 pv_acctflags() throws CorruptDataException {
		return new I16(getShortAtOffset(pvproc._pv_acctflagsOffset_));
	}

	// I16 pv_acctflags
	public I16Pointer pv_acctflagsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(pvproc._pv_acctflagsOffset_));
	}

	// I32[] pv_af1.pv_aff_stat_int
	public IDATAPointer pv_af1$pv_aff_stat_intEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(pvproc._pv_af1$pv_aff_stat_intOffset_));
	}

	// I64[] pv_af1.pv_aff_stat_long
	public IDATAPointer pv_af1$pv_aff_stat_longEA() throws CorruptDataException {
		return I64Pointer.cast(nonNullFieldEA(pvproc._pv_af1$pv_aff_stat_longOffset_));
	}

	// void* pv_aff_stat_ext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_aff_stat_extOffset_", declaredType="void*")
	public VoidPointer pv_aff_stat_ext() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_aff_stat_extOffset_));
	}

	// void* pv_aff_stat_ext
	public PointerPointer pv_aff_stat_extEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_aff_stat_extOffset_));
	}

	// dev64_t pv_app_dev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_app_devOffset_", declaredType="dev64_t")
	public UDATA pv_app_dev() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_app_devOffset_));
	}

	// dev64_t pv_app_dev
	public UDATAPointer pv_app_devEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_app_devOffset_));
	}

	// uint_t pv_app_gen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_app_genOffset_", declaredType="uint_t")
	public UDATA pv_app_gen() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_app_genOffset_));
	}

	// uint_t pv_app_gen
	public UDATAPointer pv_app_genEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_app_genOffset_));
	}

	// ino64_t pv_app_ino
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_app_inoOffset_", declaredType="ino64_t")
	public UDATA pv_app_ino() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_app_inoOffset_));
	}

	// ino64_t pv_app_ino
	public UDATAPointer pv_app_inoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_app_inoOffset_));
	}

	// I32 pv_arch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_archOffset_", declaredType="I32")
	public IDATA pv_arch() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_archOffset_));
	}

	// I32 pv_arch
	public IDATAPointer pv_archEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_archOffset_));
	}

	// U64 pv_as_map
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_as_mapOffset_", declaredType="U64")
	public UDATA pv_as_map() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_as_mapOffset_));
	}

	// U64 pv_as_map
	public UDATAPointer pv_as_mapEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_as_mapOffset_));
	}

	// uint_t pv_aso_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_aso_stateOffset_", declaredType="uint_t")
	public UDATA pv_aso_state() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_aso_stateOffset_));
	}

	// uint_t pv_aso_state
	public UDATAPointer pv_aso_stateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_aso_stateOffset_));
	}

	// kernext_svc* pv_asyncio
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_asyncioOffset_", declaredType="kernext_svc*")
	public kernext_svcPointer pv_asyncio() throws CorruptDataException {
		return kernext_svcPointer.cast(getPointerAtOffset(pvproc._pv_asyncioOffset_));
	}

	// kernext_svc* pv_asyncio
	public PointerPointer pv_asyncioEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_asyncioOffset_));
	}

	// uint pv_atomic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_atomicOffset_", declaredType="uint")
	public UDATA pv_atomic() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_atomicOffset_));
	}

	// uint pv_atomic
	public UDATAPointer pv_atomicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_atomicOffset_));
	}

	// uint pv_auditmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_auditmaskOffset_", declaredType="uint")
	public UDATA pv_auditmask() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_auditmaskOffset_));
	}

	// uint pv_auditmask
	public UDATAPointer pv_auditmaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_auditmaskOffset_));
	}

	// ushort pv_bopflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_bopflagsOffset_", declaredType="ushort")
	public U16 pv_bopflags() throws CorruptDataException {
		return new U16(getShortAtOffset(pvproc._pv_bopflagsOffset_));
	}

	// ushort pv_bopflags
	public U16Pointer pv_bopflagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvproc._pv_bopflagsOffset_));
	}

	// ushort pv_bopmcnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_bopmcntOffset_", declaredType="ushort")
	public U16 pv_bopmcnt() throws CorruptDataException {
		return new U16(getShortAtOffset(pvproc._pv_bopmcntOffset_));
	}

	// ushort pv_bopmcnt
	public U16Pointer pv_bopmcntEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvproc._pv_bopmcntOffset_));
	}

	// void* pv_cached_credp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_cached_credpOffset_", declaredType="void*")
	public VoidPointer pv_cached_credp() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_cached_credpOffset_));
	}

	// void* pv_cached_credp
	public PointerPointer pv_cached_credpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_cached_credpOffset_));
	}

	// pvproc* pv_child
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_childOffset_", declaredType="pvproc*")
	public pvprocPointer pv_child() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_childOffset_));
	}

	// pvproc* pv_child
	public PointerPointer pv_childEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_childOffset_));
	}

	// tid_t pv_chksynch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_chksynchOffset_", declaredType="tid_t")
	public IDATA pv_chksynch() throws CorruptDataException {
		return new I64(getLongAtOffset(pvproc._pv_chksynchOffset_));
	}

	// tid_t pv_chksynch
	public IDATAPointer pv_chksynchEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_chksynchOffset_));
	}

	// pvthread* pv_chktv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_chktvOffset_", declaredType="pvthread*")
	public pvthreadPointer pv_chktv() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(pvproc._pv_chktvOffset_));
	}

	// pvthread* pv_chktv
	public PointerPointer pv_chktvEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_chktvOffset_));
	}

	// class_id_t pv_class
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_classOffset_", declaredType="class_id_t")
	public UDATA pv_class() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_classOffset_));
	}

	// class_id_t pv_class
	public UDATAPointer pv_classEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_classOffset_));
	}

	// cre_t pv_cre
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_creOffset_", declaredType="cre_t")
	public U16 pv_cre() throws CorruptDataException {
		return new U16(getShortAtOffset(pvproc._pv_creOffset_));
	}

	// cre_t pv_cre
	public U16Pointer pv_creEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvproc._pv_creOffset_));
	}

	// ushort pv_cre_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_cre_flagsOffset_", declaredType="ushort")
	public U16 pv_cre_flags() throws CorruptDataException {
		return new U16(getShortAtOffset(pvproc._pv_cre_flagsOffset_));
	}

	// ushort pv_cre_flags
	public U16Pointer pv_cre_flagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvproc._pv_cre_flagsOffset_));
	}

	// crid_t pv_crid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_cridOffset_", declaredType="crid_t")
	public IDATA pv_crid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_cridOffset_));
	}

	// crid_t pv_crid
	public IDATAPointer pv_cridEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_cridOffset_));
	}

	// uint pv_crid_token
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_crid_tokenOffset_", declaredType="uint")
	public UDATA pv_crid_token() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_crid_tokenOffset_));
	}

	// uint pv_crid_token
	public UDATAPointer pv_crid_tokenEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_crid_tokenOffset_));
	}

	// pvproc* pv_cridnext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_cridnextOffset_", declaredType="pvproc*")
	public pvprocPointer pv_cridnext() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_cridnextOffset_));
	}

	// pvproc* pv_cridnext
	public PointerPointer pv_cridnextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_cridnextOffset_));
	}

	// pvproc* pv_dblist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_dblistOffset_", declaredType="pvproc*")
	public pvprocPointer pv_dblist() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_dblistOffset_));
	}

	// pvproc* pv_dblist
	public PointerPointer pv_dblistEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_dblistOffset_));
	}

	// pvproc* pv_dbnext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_dbnextOffset_", declaredType="pvproc*")
	public pvprocPointer pv_dbnext() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_dbnextOffset_));
	}

	// pvproc* pv_dbnext
	public PointerPointer pv_dbnextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_dbnextOffset_));
	}

	// void* pv_ewlmproc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_ewlmprocOffset_", declaredType="void*")
	public VoidPointer pv_ewlmproc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_ewlmprocOffset_));
	}

	// void* pv_ewlmproc
	public PointerPointer pv_ewlmprocEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_ewlmprocOffset_));
	}

	// proc_eye_catch_t pv_eyec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_eyecOffset_", declaredType="proc_eye_catch_t")
	public UDATA pv_eyec() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_eyecOffset_));
	}

	// proc_eye_catch_t pv_eyec
	public UDATAPointer pv_eyecEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_eyecOffset_));
	}

	// uint pv_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_flagOffset_", declaredType="uint")
	public UDATA pv_flag() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_flagOffset_));
	}

	// uint pv_flag
	public UDATAPointer pv_flagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_flagOffset_));
	}

	// uint pv_flag2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_flag2Offset_", declaredType="uint")
	public UDATA pv_flag2() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_flag2Offset_));
	}

	// uint pv_flag2
	public UDATAPointer pv_flag2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_flag2Offset_));
	}

	// ushort pv_flag3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_flag3Offset_", declaredType="ushort")
	public U16 pv_flag3() throws CorruptDataException {
		return new U16(getShortAtOffset(pvproc._pv_flag3Offset_));
	}

	// ushort pv_flag3
	public U16Pointer pv_flag3EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvproc._pv_flag3Offset_));
	}

	// uchar pv_flag3e
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_flag3eOffset_", declaredType="uchar")
	public U8 pv_flag3e() throws CorruptDataException {
		return new U8(getByteAtOffset(pvproc._pv_flag3eOffset_));
	}

	// uchar pv_flag3e
	public U8Pointer pv_flag3eEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvproc._pv_flag3eOffset_));
	}

	// uchar pv_flag3p
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_flag3pOffset_", declaredType="uchar")
	public U8 pv_flag3p() throws CorruptDataException {
		return new U8(getByteAtOffset(pvproc._pv_flag3pOffset_));
	}

	// uchar pv_flag3p
	public U8Pointer pv_flag3pEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvproc._pv_flag3pOffset_));
	}

	// pvproc* pv_ganchor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_ganchorOffset_", declaredType="pvproc*")
	public pvprocPointer pv_ganchor() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_ganchorOffset_));
	}

	// pvproc* pv_ganchor
	public PointerPointer pv_ganchorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_ganchorOffset_));
	}

	// void* pv_gcipc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_gcipcOffset_", declaredType="void*")
	public VoidPointer pv_gcipc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_gcipcOffset_));
	}

	// void* pv_gcipc
	public PointerPointer pv_gcipcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_gcipcOffset_));
	}

	// prochr* pv_handlers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_handlersOffset_", declaredType="prochr*")
	public prochrPointer pv_handlers() throws CorruptDataException {
		return prochrPointer.cast(getPointerAtOffset(pvproc._pv_handlersOffset_));
	}

	// prochr* pv_handlers
	public PointerPointer pv_handlersEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_handlersOffset_));
	}

	// Simple_lock pv_handlers_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_handlers_lockOffset_", declaredType="Simple_lock")
	public _simple_lockPointer pv_handlers_lock() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvproc._pv_handlers_lockOffset_));
	}

	// Simple_lock pv_handlers_lock
	public PointerPointer pv_handlers_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_handlers_lockOffset_));
	}

	// ptipc* pv_ipc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_ipcOffset_", declaredType="ptipc*")
	public ptipcPointer pv_ipc() throws CorruptDataException {
		return ptipcPointer.cast(getPointerAtOffset(pvproc._pv_ipcOffset_));
	}

	// ptipc* pv_ipc
	public PointerPointer pv_ipcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_ipcOffset_));
	}

	// cid_t pv_kcid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_kcidOffset_", declaredType="cid_t")
	public U16 pv_kcid() throws CorruptDataException {
		return new U16(getShortAtOffset(pvproc._pv_kcidOffset_));
	}

	// cid_t pv_kcid
	public U16Pointer pv_kcidEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvproc._pv_kcidOffset_));
	}

	// pvproc* pv_last_child
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_last_childOffset_", declaredType="pvproc*")
	public pvprocPointer pv_last_child() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_last_childOffset_));
	}

	// pvproc* pv_last_child
	public PointerPointer pv_last_childEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_last_childOffset_));
	}

	// Simple_lock pv_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_lockOffset_", declaredType="Simple_lock")
	public _simple_lockPointer pv_lock() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvproc._pv_lockOffset_));
	}

	// Simple_lock pv_lock
	public PointerPointer pv_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_lockOffset_));
	}

	// Simple_lock pv_lock_d
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_lock_dOffset_", declaredType="Simple_lock")
	public _simple_lockPointer pv_lock_d() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvproc._pv_lock_dOffset_));
	}

	// Simple_lock pv_lock_d
	public PointerPointer pv_lock_dEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_lock_dOffset_));
	}

	// void* pv_mcrp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_mcrpOffset_", declaredType="void*")
	public VoidPointer pv_mcrp() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_mcrpOffset_));
	}

	// void* pv_mcrp
	public PointerPointer pv_mcrpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_mcrpOffset_));
	}

	// U64[] pv_mempools
	public UDATAPointer pv_mempoolsEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(pvproc._pv_mempoolsOffset_));
	}

	// U64 pv_ncpages
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_ncpagesOffset_", declaredType="U64")
	public UDATA pv_ncpages() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_ncpagesOffset_));
	}

	// U64 pv_ncpages
	public UDATAPointer pv_ncpagesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_ncpagesOffset_));
	}

	// U64 pv_nframes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_nframesOffset_", declaredType="U64")
	public UDATA pv_nframes() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_nframesOffset_));
	}

	// U64 pv_nframes
	public UDATAPointer pv_nframesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_nframesOffset_));
	}

	// ulong pv_nodegen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_nodegenOffset_", declaredType="ulong")
	public UDATA pv_nodegen() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_nodegenOffset_));
	}

	// ulong pv_nodegen
	public UDATAPointer pv_nodegenEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_nodegenOffset_));
	}

	// U64 pv_npsblks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_npsblksOffset_", declaredType="U64")
	public UDATA pv_npsblks() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_npsblksOffset_));
	}

	// U64 pv_npsblks
	public UDATAPointer pv_npsblksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_npsblksOffset_));
	}

	// U64 pv_nvpages
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_nvpagesOffset_", declaredType="U64")
	public UDATA pv_nvpages() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_nvpagesOffset_));
	}

	// U64 pv_nvpages
	public UDATAPointer pv_nvpagesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_nvpagesOffset_));
	}

	// void* pv_p11_ctx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_p11_ctxOffset_", declaredType="void*")
	public VoidPointer pv_p11_ctx() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_p11_ctxOffset_));
	}

	// void* pv_p11_ctx
	public PointerPointer pv_p11_ctxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_p11_ctxOffset_));
	}

	// I32 pv_pad0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pad0Offset_", declaredType="I32")
	public IDATA pv_pad0() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_pad0Offset_));
	}

	// I32 pv_pad0
	public IDATAPointer pv_pad0EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_pad0Offset_));
	}

	// I32 pv_pad1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pad1Offset_", declaredType="I32")
	public IDATA pv_pad1() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_pad1Offset_));
	}

	// I32 pv_pad1
	public IDATAPointer pv_pad1EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_pad1Offset_));
	}

	// I32 pv_pad2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pad2Offset_", declaredType="I32")
	public IDATA pv_pad2() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_pad2Offset_));
	}

	// I32 pv_pad2
	public IDATAPointer pv_pad2EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_pad2Offset_));
	}

	// Simple_lock pv_parent_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_parent_lockOffset_", declaredType="Simple_lock")
	public _simple_lockPointer pv_parent_lock() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvproc._pv_parent_lockOffset_));
	}

	// Simple_lock pv_parent_lock
	public PointerPointer pv_parent_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_parent_lockOffset_));
	}

	// pid_t pv_pgrp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pgrpOffset_", declaredType="pid_t")
	public IDATA pv_pgrp() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_pgrpOffset_));
	}

	// pid_t pv_pgrp
	public IDATAPointer pv_pgrpEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_pgrpOffset_));
	}

	// pvproc* pv_pgrpb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pgrpbOffset_", declaredType="pvproc*")
	public pvprocPointer pv_pgrpb() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_pgrpbOffset_));
	}

	// pvproc* pv_pgrpb
	public PointerPointer pv_pgrpbEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_pgrpbOffset_));
	}

	// pvproc* pv_pgrpl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pgrplOffset_", declaredType="pvproc*")
	public pvprocPointer pv_pgrpl() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_pgrplOffset_));
	}

	// pvproc* pv_pgrpl
	public PointerPointer pv_pgrplEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_pgrplOffset_));
	}

	// pid_t pv_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pidOffset_", declaredType="pid_t")
	public IDATA pv_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_pidOffset_));
	}

	// pid_t pv_pid
	public IDATAPointer pv_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_pidOffset_));
	}

	// void* pv_pnda
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_pndaOffset_", declaredType="void*")
	public VoidPointer pv_pnda() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_pndaOffset_));
	}

	// void* pv_pnda
	public PointerPointer pv_pndaEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_pndaOffset_));
	}

	// U8 pv_policy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_policyOffset_", declaredType="U8")
	public U8 pv_policy() throws CorruptDataException {
		return new U8(getByteAtOffset(pvproc._pv_policyOffset_));
	}

	// U8 pv_policy
	public U8Pointer pv_policyEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvproc._pv_policyOffset_));
	}

	// pid_t pv_ppid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_ppidOffset_", declaredType="pid_t")
	public IDATA pv_ppid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_ppidOffset_));
	}

	// pid_t pv_ppid
	public IDATAPointer pv_ppidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_ppidOffset_));
	}

	// U8 pv_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_priOffset_", declaredType="U8")
	public U8 pv_pri() throws CorruptDataException {
		return new U8(getByteAtOffset(pvproc._pv_priOffset_));
	}

	// U8 pv_pri
	public U8Pointer pv_priEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvproc._pv_priOffset_));
	}

	// vnode* pv_procfsvn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_procfsvnOffset_", declaredType="vnode*")
	public vnodePointer pv_procfsvn() throws CorruptDataException {
		return vnodePointer.cast(getPointerAtOffset(pvproc._pv_procfsvnOffset_));
	}

	// vnode* pv_procfsvn
	public PointerPointer pv_procfsvnEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_procfsvnOffset_));
	}

	// proc* pv_procp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_procpOffset_", declaredType="proc*")
	public procPointer pv_procp() throws CorruptDataException {
		return procPointer.cast(getPointerAtOffset(pvproc._pv_procpOffset_));
	}

	// proc* pv_procp
	public PointerPointer pv_procpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_procpOffset_));
	}

	// I32 pv_projid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_projidOffset_", declaredType="I32")
	public IDATA pv_projid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_projidOffset_));
	}

	// I32 pv_projid
	public IDATAPointer pv_projidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_projidOffset_));
	}

	// void* pv_rset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_rsetOffset_", declaredType="void*")
	public VoidPointer pv_rset() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvproc._pv_rsetOffset_));
	}

	// void* pv_rset
	public PointerPointer pv_rsetEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_rsetOffset_));
	}

	// trusage64 pv_ru
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_ruOffset_", declaredType="trusage64")
	public trusage64Pointer pv_ru() throws CorruptDataException {
		return trusage64Pointer.cast(nonNullFieldEA(pvproc._pv_ruOffset_));
	}

	// trusage64 pv_ru
	public PointerPointer pv_ruEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_ruOffset_));
	}

	// pvproc* pv_sched_back
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_sched_backOffset_", declaredType="pvproc*")
	public pvprocPointer pv_sched_back() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_sched_backOffset_));
	}

	// pvproc* pv_sched_back
	public PointerPointer pv_sched_backEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_sched_backOffset_));
	}

	// pvproc* pv_sched_next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_sched_nextOffset_", declaredType="pvproc*")
	public pvprocPointer pv_sched_next() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_sched_nextOffset_));
	}

	// pvproc* pv_sched_next
	public PointerPointer pv_sched_nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_sched_nextOffset_));
	}

	// I16 pv_secflag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_secflagOffset_", declaredType="I16")
	public I16 pv_secflag() throws CorruptDataException {
		return new I16(getShortAtOffset(pvproc._pv_secflagOffset_));
	}

	// I16 pv_secflag
	public I16Pointer pv_secflagEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(pvproc._pv_secflagOffset_));
	}

	// Simple_lock pv_session_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_session_lockOffset_", declaredType="Simple_lock")
	public _simple_lockPointer pv_session_lock() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvproc._pv_session_lockOffset_));
	}

	// Simple_lock pv_session_lock
	public PointerPointer pv_session_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_session_lockOffset_));
	}

	// I32 pv_si_status
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_si_statusOffset_", declaredType="I32")
	public IDATA pv_si_status() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_si_statusOffset_));
	}

	// I32 pv_si_status
	public IDATAPointer pv_si_statusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_si_statusOffset_));
	}

	// pvproc* pv_sib_back
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_sib_backOffset_", declaredType="pvproc*")
	public pvprocPointer pv_sib_back() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_sib_backOffset_));
	}

	// pvproc* pv_sib_back
	public PointerPointer pv_sib_backEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_sib_backOffset_));
	}

	// pvproc* pv_siblings
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_siblingsOffset_", declaredType="pvproc*")
	public pvprocPointer pv_siblings() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_siblingsOffset_));
	}

	// pvproc* pv_siblings
	public PointerPointer pv_siblingsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_siblingsOffset_));
	}

	// pid_t pv_sid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_sidOffset_", declaredType="pid_t")
	public IDATA pv_sid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_sidOffset_));
	}

	// pid_t pv_sid
	public IDATAPointer pv_sidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_sidOffset_));
	}

	// U8 pv_sigs_queued
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_sigs_queuedOffset_", declaredType="U8")
	public U8 pv_sigs_queued() throws CorruptDataException {
		return new U8(getByteAtOffset(pvproc._pv_sigs_queuedOffset_));
	}

	// U8 pv_sigs_queued
	public U8Pointer pv_sigs_queuedEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvproc._pv_sigs_queuedOffset_));
	}

	// ulong[] pv_spare
	public UDATAPointer pv_spareEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(pvproc._pv_spareOffset_));
	}

	// I32 pv_sprojid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_sprojidOffset_", declaredType="I32")
	public IDATA pv_sprojid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_sprojidOffset_));
	}

	// I32 pv_sprojid
	public IDATAPointer pv_sprojidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_sprojidOffset_));
	}

	// U8 pv_stat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_statOffset_", declaredType="U8")
	public U8 pv_stat() throws CorruptDataException {
		return new U8(getByteAtOffset(pvproc._pv_statOffset_));
	}

	// U8 pv_stat
	public U8Pointer pv_statEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvproc._pv_statOffset_));
	}

	// I32 pv_static_environment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_static_environmentOffset_", declaredType="I32")
	public IDATA pv_static_environment() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_static_environmentOffset_));
	}

	// I32 pv_static_environment
	public IDATAPointer pv_static_environmentEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_static_environmentOffset_));
	}

	// U64 pv_subproj
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_subprojOffset_", declaredType="U64")
	public UDATA pv_subproj() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_subprojOffset_));
	}

	// U64 pv_subproj
	public UDATAPointer pv_subprojEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_subprojOffset_));
	}

	// uid_t pv_suid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_suidOffset_", declaredType="uid_t")
	public UDATA pv_suid() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_suidOffset_));
	}

	// uid_t pv_suid
	public UDATAPointer pv_suidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_suidOffset_));
	}

	// tid_t pv_synch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_synchOffset_", declaredType="tid_t")
	public IDATA pv_synch() throws CorruptDataException {
		return new I64(getLongAtOffset(pvproc._pv_synchOffset_));
	}

	// tid_t pv_synch
	public IDATAPointer pv_synchEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_synchOffset_));
	}

	// time_t pv_termtime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_termtimeOffset_", declaredType="time_t")
	public IDATA pv_termtime() throws CorruptDataException {
		return new I64(getLongAtOffset(pvproc._pv_termtimeOffset_));
	}

	// time_t pv_termtime
	public IDATAPointer pv_termtimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_termtimeOffset_));
	}

	// pvthread* pv_threadlist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_threadlistOffset_", declaredType="pvthread*")
	public pvthreadPointer pv_threadlist() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(pvproc._pv_threadlistOffset_));
	}

	// pvthread* pv_threadlist
	public PointerPointer pv_threadlistEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_threadlistOffset_));
	}

	// DRW_lock pv_time_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_time_lockOffset_", declaredType="DRW_lock")
	public _drw_lockPointer pv_time_lock() throws CorruptDataException {
		return _drw_lockPointer.cast(nonNullFieldEA(pvproc._pv_time_lockOffset_));
	}

	// DRW_lock pv_time_lock
	public PointerPointer pv_time_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_time_lockOffset_));
	}

	// U64 pv_totalcputime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_totalcputimeOffset_", declaredType="U64")
	public UDATA pv_totalcputime() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_totalcputimeOffset_));
	}

	// U64 pv_totalcputime
	public UDATAPointer pv_totalcputimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_totalcputimeOffset_));
	}

	// U64 pv_totaldiskio
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_totaldiskioOffset_", declaredType="U64")
	public UDATA pv_totaldiskio() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_totaldiskioOffset_));
	}

	// U64 pv_totaldiskio
	public UDATAPointer pv_totaldiskioEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_totaldiskioOffset_));
	}

	// U64 pv_totalscputime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_totalscputimeOffset_", declaredType="U64")
	public UDATA pv_totalscputime() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_totalscputimeOffset_));
	}

	// U64 pv_totalscputime
	public UDATAPointer pv_totalscputimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_totalscputimeOffset_));
	}

	// pvproc* pv_ttyl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_ttylOffset_", declaredType="pvproc*")
	public pvprocPointer pv_ttyl() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvproc._pv_ttylOffset_));
	}

	// pvproc* pv_ttyl
	public PointerPointer pv_ttylEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_ttylOffset_));
	}

	// uid_t pv_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_uidOffset_", declaredType="uid_t")
	public UDATA pv_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(pvproc._pv_uidOffset_));
	}

	// uid_t pv_uid
	public UDATAPointer pv_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_uidOffset_));
	}

	// uidinfo* pv_uidinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_uidinfoOffset_", declaredType="uidinfo*")
	public uidinfoPointer pv_uidinfo() throws CorruptDataException {
		return uidinfoPointer.cast(getPointerAtOffset(pvproc._pv_uidinfoOffset_));
	}

	// uidinfo* pv_uidinfo
	public PointerPointer pv_uidinfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_uidinfoOffset_));
	}

	// Simple_lock pv_usched_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_usched_lockOffset_", declaredType="Simple_lock")
	public _simple_lockPointer pv_usched_lock() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvproc._pv_usched_lockOffset_));
	}

	// Simple_lock pv_usched_lock
	public PointerPointer pv_usched_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_usched_lockOffset_));
	}

	// pvthread* pv_uschedp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_uschedpOffset_", declaredType="pvthread*")
	public pvthreadPointer pv_uschedp() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(pvproc._pv_uschedpOffset_));
	}

	// pvthread* pv_uschedp
	public PointerPointer pv_uschedpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_uschedpOffset_));
	}

	// vm_xproc_data* pv_vmm_xproc_data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_vmm_xproc_dataOffset_", declaredType="vm_xproc_data*")
	public vm_xproc_dataPointer pv_vmm_xproc_data() throws CorruptDataException {
		return vm_xproc_dataPointer.cast(getPointerAtOffset(pvproc._pv_vmm_xproc_dataOffset_));
	}

	// vm_xproc_data* pv_vmm_xproc_data
	public PointerPointer pv_vmm_xproc_dataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_vmm_xproc_dataOffset_));
	}

	// pid_t pv_vpgrp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_vpgrpOffset_", declaredType="pid_t")
	public IDATA pv_vpgrp() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_vpgrpOffset_));
	}

	// pid_t pv_vpgrp
	public IDATAPointer pv_vpgrpEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_vpgrpOffset_));
	}

	// pid_t pv_vpid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_vpidOffset_", declaredType="pid_t")
	public IDATA pv_vpid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_vpidOffset_));
	}

	// pid_t pv_vpid
	public IDATAPointer pv_vpidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_vpidOffset_));
	}

	// pid_t pv_vppid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_vppidOffset_", declaredType="pid_t")
	public IDATA pv_vppid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_vppidOffset_));
	}

	// pid_t pv_vppid
	public IDATAPointer pv_vppidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_vppidOffset_));
	}

	// pid_t pv_vsid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_vsidOffset_", declaredType="pid_t")
	public IDATA pv_vsid() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_vsidOffset_));
	}

	// pid_t pv_vsid
	public IDATAPointer pv_vsidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_vsidOffset_));
	}

	// I32 pv_wlm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_wlmOffset_", declaredType="I32")
	public IDATA pv_wlm() throws CorruptDataException {
		return new I32(getIntAtOffset(pvproc._pv_wlmOffset_));
	}

	// I32 pv_wlm
	public IDATAPointer pv_wlmEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_wlmOffset_));
	}

	// U64 pv_wlm_nvpages
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_wlm_nvpagesOffset_", declaredType="U64")
	public UDATA pv_wlm_nvpages() throws CorruptDataException {
		return new U64(getLongAtOffset(pvproc._pv_wlm_nvpagesOffset_));
	}

	// U64 pv_wlm_nvpages
	public UDATAPointer pv_wlm_nvpagesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvproc._pv_wlm_nvpagesOffset_));
	}

	// tid_t pv_xproc_synch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_xproc_synchOffset_", declaredType="tid_t")
	public IDATA pv_xproc_synch() throws CorruptDataException {
		return new I64(getLongAtOffset(pvproc._pv_xproc_synchOffset_));
	}

	// tid_t pv_xproc_synch
	public IDATAPointer pv_xproc_synchEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvproc._pv_xproc_synchOffset_));
	}

	// ushort pv_xstat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_xstatOffset_", declaredType="ushort")
	public U16 pv_xstat() throws CorruptDataException {
		return new U16(getShortAtOffset(pvproc._pv_xstatOffset_));
	}

	// ushort pv_xstat
	public U16Pointer pv_xstatEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvproc._pv_xstatOffset_));
	}

	// pvthread* pv_zombies
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pv_zombiesOffset_", declaredType="pvthread*")
	public pvthreadPointer pv_zombies() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(pvproc._pv_zombiesOffset_));
	}

	// pvthread* pv_zombies
	public PointerPointer pv_zombiesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvproc._pv_zombiesOffset_));
	}

}
