/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _pt_watchpoints_hdrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _pt_watchpoints_hdrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_pt_watchpoints_hdr.class)
public class _pt_watchpoints_hdrPointer extends StructurePointer {

	// NULL
	public static final _pt_watchpoints_hdrPointer NULL = new _pt_watchpoints_hdrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _pt_watchpoints_hdrPointer(long address) {
		super(address);
	}

	public static _pt_watchpoints_hdrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _pt_watchpoints_hdrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _pt_watchpoints_hdrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _pt_watchpoints_hdrPointer(address);
	}

	public _pt_watchpoints_hdrPointer add(long count) {
		return _pt_watchpoints_hdrPointer.cast(address + (_pt_watchpoints_hdr.SIZEOF * count));
	}

	public _pt_watchpoints_hdrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _pt_watchpoints_hdrPointer addOffset(long offset) {
		return _pt_watchpoints_hdrPointer.cast(address + offset);
	}

	public _pt_watchpoints_hdrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _pt_watchpoints_hdrPointer sub(long count) {
		return _pt_watchpoints_hdrPointer.cast(address - (_pt_watchpoints_hdr.SIZEOF * count));
	}

	public _pt_watchpoints_hdrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _pt_watchpoints_hdrPointer subOffset(long offset) {
		return _pt_watchpoints_hdrPointer.cast(address - offset);
	}

	public _pt_watchpoints_hdrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _pt_watchpoints_hdrPointer untag(long mask) {
		return _pt_watchpoints_hdrPointer.cast(address & ~mask);
	}

	public _pt_watchpoints_hdrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _pt_watchpoints_hdr.SIZEOF;
	}

	// Implementation methods

	// U32:1 pt_validate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_validateOffset_", declaredType="U32:1")
	public UDATA pt_validate() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoints_hdr._pt_validate_s_, _pt_watchpoints_hdr._pt_validate_b_);
	}

	// U32 pt_watchpoint_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_watchpoint_sizeOffset_", declaredType="U32")
	public UDATA pt_watchpoint_size() throws CorruptDataException {
		return new U32(getIntAtOffset(_pt_watchpoints_hdr._pt_watchpoint_sizeOffset_));
	}

	// U32 pt_watchpoint_size
	public UDATAPointer pt_watchpoint_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pt_watchpoints_hdr._pt_watchpoint_sizeOffset_));
	}

	// U32 pt_watchpoints_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_watchpoints_countOffset_", declaredType="U32")
	public UDATA pt_watchpoints_count() throws CorruptDataException {
		return new U32(getIntAtOffset(_pt_watchpoints_hdr._pt_watchpoints_countOffset_));
	}

	// U32 pt_watchpoints_count
	public UDATAPointer pt_watchpoints_countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pt_watchpoints_hdr._pt_watchpoints_countOffset_));
	}

	// offset_t pt_watchpoints_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_watchpoints_offsetOffset_", declaredType="offset_t")
	public IDATA pt_watchpoints_offset() throws CorruptDataException {
		return new I64(getLongAtOffset(_pt_watchpoints_hdr._pt_watchpoints_offsetOffset_));
	}

	// offset_t pt_watchpoints_offset
	public IDATAPointer pt_watchpoints_offsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_pt_watchpoints_hdr._pt_watchpoints_offsetOffset_));
	}

	// U32:1 pt_wp_mapped
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_mappedOffset_", declaredType="U32:1")
	public UDATA pt_wp_mapped() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoints_hdr._pt_wp_mapped_s_, _pt_watchpoints_hdr._pt_wp_mapped_b_);
	}

	// U32:1 pt_wp_read
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_readOffset_", declaredType="U32:1")
	public UDATA pt_wp_read() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoints_hdr._pt_wp_read_s_, _pt_watchpoints_hdr._pt_wp_read_b_);
	}

	// U32:1 pt_wp_shmem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_shmemOffset_", declaredType="U32:1")
	public UDATA pt_wp_shmem() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoints_hdr._pt_wp_shmem_s_, _pt_watchpoints_hdr._pt_wp_shmem_b_);
	}

	// U32:1 pt_wp_thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_threadOffset_", declaredType="U32:1")
	public UDATA pt_wp_thread() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoints_hdr._pt_wp_thread_s_, _pt_watchpoints_hdr._pt_wp_thread_b_);
	}

	// U32:1 pt_wp_value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_valueOffset_", declaredType="U32:1")
	public UDATA pt_wp_value() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoints_hdr._pt_wp_value_s_, _pt_watchpoints_hdr._pt_wp_value_b_);
	}

	// U32:1 pt_wp_write
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_wp_writeOffset_", declaredType="U32:1")
	public UDATA pt_wp_write() throws CorruptDataException {
		return getU32Bitfield(_pt_watchpoints_hdr._pt_wp_write_s_, _pt_watchpoints_hdr._pt_wp_write_b_);
	}

	// U32 reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedOffset_", declaredType="U32")
	public UDATA reserved() throws CorruptDataException {
		return new U32(getIntAtOffset(_pt_watchpoints_hdr._reservedOffset_));
	}

	// U32 reserved
	public UDATAPointer reservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pt_watchpoints_hdr._reservedOffset_));
	}

}
