/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _pthread_EBB_registration_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _pthread_EBB_registration_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_pthread_EBB_registration_t.class)
public class _pthread_EBB_registration_tPointer extends StructurePointer {

	// NULL
	public static final _pthread_EBB_registration_tPointer NULL = new _pthread_EBB_registration_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _pthread_EBB_registration_tPointer(long address) {
		super(address);
	}

	public static _pthread_EBB_registration_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _pthread_EBB_registration_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _pthread_EBB_registration_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _pthread_EBB_registration_tPointer(address);
	}

	public _pthread_EBB_registration_tPointer add(long count) {
		return _pthread_EBB_registration_tPointer.cast(address + (_pthread_EBB_registration_t.SIZEOF * count));
	}

	public _pthread_EBB_registration_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _pthread_EBB_registration_tPointer addOffset(long offset) {
		return _pthread_EBB_registration_tPointer.cast(address + offset);
	}

	public _pthread_EBB_registration_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _pthread_EBB_registration_tPointer sub(long count) {
		return _pthread_EBB_registration_tPointer.cast(address - (_pthread_EBB_registration_t.SIZEOF * count));
	}

	public _pthread_EBB_registration_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _pthread_EBB_registration_tPointer subOffset(long offset) {
		return _pthread_EBB_registration_tPointer.cast(address - offset);
	}

	public _pthread_EBB_registration_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _pthread_EBB_registration_tPointer untag(long mask) {
		return _pthread_EBB_registration_tPointer.cast(address & ~mask);
	}

	public _pthread_EBB_registration_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _pthread_EBB_registration_t.SIZEOF;
	}

	// Implementation methods

	// uint _ptebb_cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptebb_crOffset_", declaredType="uint")
	public UDATA _ptebb_cr() throws CorruptDataException {
		return new U32(getIntAtOffset(_pthread_EBB_registration_t.__ptebb_crOffset_));
	}

	// uint _ptebb_cr
	public UDATAPointer _ptebb_crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pthread_EBB_registration_t.__ptebb_crOffset_));
	}

	// ulong _ptebb_ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptebb_ctrOffset_", declaredType="ulong")
	public UDATA _ptebb_ctr() throws CorruptDataException {
		return new U64(getLongAtOffset(_pthread_EBB_registration_t.__ptebb_ctrOffset_));
	}

	// ulong _ptebb_ctr
	public UDATAPointer _ptebb_ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pthread_EBB_registration_t.__ptebb_ctrOffset_));
	}

	// eye_catch4b_t _ptebb_eyecatcher
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptebb_eyecatcherOffset_", declaredType="eye_catch4b_t")
	public UDATA _ptebb_eyecatcher() throws CorruptDataException {
		return new U32(getIntAtOffset(_pthread_EBB_registration_t.__ptebb_eyecatcherOffset_));
	}

	// eye_catch4b_t _ptebb_eyecatcher
	public UDATAPointer _ptebb_eyecatcherEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pthread_EBB_registration_t.__ptebb_eyecatcherOffset_));
	}

	// void* _ptebb_handler_address
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptebb_handler_addressOffset_", declaredType="void*")
	public VoidPointer _ptebb_handler_address() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_pthread_EBB_registration_t.__ptebb_handler_addressOffset_));
	}

	// void* _ptebb_handler_address
	public PointerPointer _ptebb_handler_addressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_pthread_EBB_registration_t.__ptebb_handler_addressOffset_));
	}

	// void* _ptebb_handler_data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptebb_handler_dataOffset_", declaredType="void*")
	public VoidPointer _ptebb_handler_data() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_pthread_EBB_registration_t.__ptebb_handler_dataOffset_));
	}

	// void* _ptebb_handler_data
	public PointerPointer _ptebb_handler_dataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_pthread_EBB_registration_t.__ptebb_handler_dataOffset_));
	}

	// ulong _ptebb_r2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptebb_r2Offset_", declaredType="ulong")
	public UDATA _ptebb_r2() throws CorruptDataException {
		return new U64(getLongAtOffset(_pthread_EBB_registration_t.__ptebb_r2Offset_));
	}

	// ulong _ptebb_r2
	public UDATAPointer _ptebb_r2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pthread_EBB_registration_t.__ptebb_r2Offset_));
	}

	// ulong _ptebb_r3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptebb_r3Offset_", declaredType="ulong")
	public UDATA _ptebb_r3() throws CorruptDataException {
		return new U64(getLongAtOffset(_pthread_EBB_registration_t.__ptebb_r3Offset_));
	}

	// ulong _ptebb_r3
	public UDATAPointer _ptebb_r3EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pthread_EBB_registration_t.__ptebb_r3Offset_));
	}

	// ulong[] reserved
	public UDATAPointer reservedEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(_pthread_EBB_registration_t._reservedOffset_));
	}

}
